/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuildProxy2;
import hudson.maven.Messages;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Result;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.Future;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import jenkins.model.Jenkins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenBuilder
implements DelegatingCallable<Result, IOException> {
    private static final long serialVersionUID = -2687215937784908860L;
    protected final List<String> goals;
    protected final Map<String, String> systemProps;
    protected final BuildListener listener;
    private transient List<Future<?>> futures;

    protected AbstractMavenBuilder(BuildListener listener, List<String> goals, Map<String, String> systemProps) {
        this.listener = listener;
        this.goals = goals;
        this.systemProps = systemProps;
    }

    protected String formatArgs(List<String> args) {
        StringBuilder buf = new StringBuilder("Executing Maven: ");
        for (String arg : args) {
            String argPassword = "-Dpassword=";
            String filteredArg = arg;
            if (arg.startsWith("-Dpassword=")) {
                filteredArg = "-Dpassword=*********";
            }
            buf.append(' ').append(filteredArg);
        }
        return buf.toString();
    }

    protected void registerSystemProperties() {
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            if ("".equals(e.getKey())) continue;
            if (e.getValue() == null) {
                throw new IllegalArgumentException("Global Environment Variable " + e.getKey() + " has a null value");
            }
            System.getProperties().put(e.getKey(), e.getValue());
        }
    }

    protected String format(NumberFormat n, long nanoTime) {
        return n.format(nanoTime / 1000000L);
    }

    public ClassLoader getClassLoader() {
        return Jenkins.getInstance().getPluginManager().uberClassLoader;
    }

    protected void initializeAsynchronousExecutions() {
        this.futures = new CopyOnWriteArrayList();
    }

    protected void recordAsynchronousExecution(Future<?> future) {
        this.futures.add(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected Result waitForAsynchronousExecutions() {
        try {
            boolean messageReported = false;
            for (Future<?> f : this.futures) {
                try {
                    if (!messageReported && !f.isDone()) {
                        messageReported = true;
                        this.listener.getLogger().println(Messages.MavenBuilder_Waiting());
                    }
                    f.get();
                }
                catch (InterruptedException e) {
                    for (Future<?> g : this.futures) {
                        g.cancel(true);
                    }
                    this.listener.getLogger().println(Messages.MavenBuilder_Aborted());
                    Result result = Executor.currentExecutor().abortResult();
                    Object var8_8 = null;
                    this.futures.clear();
                    return result;
                }
                catch (ExecutionException e) {
                    e.printStackTrace(this.listener.error(Messages.MavenBuilder_AsyncFailed()));
                }
            }
            Result result = null;
            Object var8_9 = null;
            this.futures.clear();
            return result;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.futures.clear();
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FilterImpl
    extends MavenBuildProxy2.Filter<MavenBuildProxy2>
    implements Serializable {
        private MavenBuildInformation mavenBuildInformation;
        private transient Channel channel;
        private static final long serialVersionUID = 1L;

        public FilterImpl(MavenBuildProxy2 core, MavenBuildInformation mavenBuildInformation) {
            super(core);
            this.mavenBuildInformation = mavenBuildInformation;
        }

        public FilterImpl(MavenBuildProxy2 core, MavenBuildInformation mavenBuildInformation, Channel channel) {
            super(core);
            this.mavenBuildInformation = mavenBuildInformation;
            if (channel == null) {
                throw new NullPointerException("channel must not be null!");
            }
            this.channel = channel;
        }

        @Override
        public void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
            AbstractMavenBuilder.this.recordAsynchronousExecution(this.channel.callAsync((Callable)new MavenBuildProxy.Filter.AsyncInvoker(this.core, program)));
        }

        @Override
        public MavenBuildInformation getMavenBuildInformation() {
            return this.mavenBuildInformation;
        }

        public Object readResolve() {
            this.channel = Channel.current();
            return this;
        }
    }
}

