/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Launcher;
import hudson.maven.AbstractMavenBuilder;
import hudson.maven.ExecutedMojo;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy2;
import hudson.maven.MavenProcessFactory;
import hudson.maven.MavenReporter;
import hudson.maven.Messages;
import hudson.maven.ModuleName;
import hudson.maven.MojoInfo;
import hudson.maven.util.ExecutionEventLogger;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import hudson.util.IOException2;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.maven.cli.PrintStreamLogger;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.logging.Logger;
import org.jvnet.hudson.maven3.agent.Maven3Main;
import org.jvnet.hudson.maven3.launcher.Maven3Launcher;
import org.jvnet.hudson.maven3.listeners.HudsonMavenExecutionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maven3Builder
extends AbstractMavenBuilder
implements DelegatingCallable<Result, IOException> {
    private final boolean profile = MavenProcessFactory.profile;
    HudsonMavenExecutionResult mavenExecutionResult;
    private final Map<ModuleName, MavenBuildProxy2> proxies;
    private final Map<ModuleName, MavenBuild.ProxyImpl2> sourceProxies;
    private final Map<ModuleName, List<MavenReporter>> reporters = new HashMap<ModuleName, List<MavenReporter>>();
    private final MavenBuildInformation mavenBuildInformation;
    public static boolean markAsSuccess;
    private static final long serialVersionUID = 1L;
    public static boolean DEBUG;
    private static final java.util.logging.Logger LOGGER;

    protected Maven3Builder(BuildListener listener, Map<ModuleName, MavenBuild.ProxyImpl2> proxies, Map<ModuleName, List<MavenReporter>> reporters, List<String> goals, Map<String, String> systemProps, MavenBuildInformation mavenBuildInformation) {
        super(listener, goals, systemProps);
        this.mavenBuildInformation = mavenBuildInformation;
        this.sourceProxies = new HashMap<ModuleName, MavenBuild.ProxyImpl2>(proxies);
        this.proxies = new HashMap<ModuleName, MavenBuild.ProxyImpl2>(proxies);
        for (Map.Entry<ModuleName, MavenBuildProxy2> e : this.proxies.entrySet()) {
            e.setValue(new AbstractMavenBuilder.FilterImpl(e.getValue(), this.mavenBuildInformation));
        }
        this.reporters.putAll(reporters);
    }

    public Result call() throws IOException {
        MavenExecutionListener mavenExecutionListener = new MavenExecutionListener(this);
        try {
            this.initializeAsynchronousExecutions();
            Maven3Launcher.setMavenExecutionListener((ExecutionListener)mavenExecutionListener);
            markAsSuccess = false;
            this.registerSystemProperties();
            this.listener.getLogger().println(this.formatArgs(this.goals));
            int r = Maven3Main.launch((String[])this.goals.toArray(new String[this.goals.size()]));
            long startTime = System.nanoTime();
            Result waitForAsyncExecutionsResult = this.waitForAsynchronousExecutions();
            if (waitForAsyncExecutionsResult != null) {
                return waitForAsyncExecutionsResult;
            }
            mavenExecutionListener.overheadTime += System.nanoTime() - startTime;
            if (this.profile) {
                NumberFormat n = NumberFormat.getInstance();
                PrintStream logger = this.listener.getLogger();
                logger.println("Total overhead was " + this.format(n, mavenExecutionListener.overheadTime) + "ms");
                Channel ch = Channel.current();
                logger.println("Class loading " + this.format(n, ch.classLoadingTime.get()) + "ms, " + ch.classLoadingCount + " classes");
                logger.println("Resource loading " + this.format(n, ch.resourceLoadingTime.get()) + "ms, " + ch.resourceLoadingCount + " times");
            }
            this.mavenExecutionResult = Maven3Launcher.getMavenExecutionResult();
            PrintStream logger = this.listener.getLogger();
            if (r == 0 && this.mavenExecutionResult.getThrowables().isEmpty()) {
                return Result.SUCCESS;
            }
            if (!this.mavenExecutionResult.getThrowables().isEmpty()) {
                logger.println("mavenExecutionResult exceptions not empty");
                for (Throwable throwable : this.mavenExecutionResult.getThrowables()) {
                    logger.println("message : " + throwable.getMessage());
                    if (throwable.getCause() != null) {
                        logger.println("cause : " + throwable.getCause().getMessage());
                    }
                    logger.println("Stack trace : ");
                    throwable.printStackTrace(logger);
                }
            }
            if (markAsSuccess) {
                this.listener.getLogger().println(Messages.MavenBuilder_Failed());
                return Result.SUCCESS;
            }
            return Result.FAILURE;
        }
        catch (NoSuchMethodException e) {
            throw new IOException2((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new IOException2((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new IOException2((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException2((Throwable)e);
        }
        catch (Exception e) {
            throw new IOException2((Throwable)e);
        }
    }

    void end(Launcher launcher) throws IOException, InterruptedException {
        for (Map.Entry<ModuleName, MavenBuild.ProxyImpl2> e : this.sourceProxies.entrySet()) {
            MavenBuild.ProxyImpl2 p = e.getValue();
            for (MavenReporter r : this.reporters.get(e.getKey())) {
                r.end(p.owner(), launcher, this.listener);
                p.appendLastLog();
            }
            p.close();
        }
    }

    static {
        DEBUG = false;
        LOGGER = java.util.logging.Logger.getLogger(Maven3Builder.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MavenExecutionListener
    extends AbstractExecutionListener
    implements Serializable,
    ExecutionListener {
        private static final long serialVersionUID = 4942789836756366116L;
        private final Maven3Builder maven3Builder;
        long overheadTime;
        private final Map<ModuleName, MavenBuildProxy2> proxies;
        private final Map<ModuleName, List<ExecutedMojo>> executedMojosPerModule = new ConcurrentHashMap<ModuleName, List<ExecutedMojo>>();
        private final Map<ModuleName, List<MavenReporter>> reporters = new ConcurrentHashMap<ModuleName, List<MavenReporter>>();
        private final Map<ModuleName, Long> currentMojoStartPerModuleName = new ConcurrentHashMap<ModuleName, Long>();
        private ExecutionEventLogger eventLogger;

        public MavenExecutionListener(Maven3Builder maven3Builder) {
            this.maven3Builder = maven3Builder;
            this.proxies = new ConcurrentHashMap<ModuleName, MavenBuildProxy2>(maven3Builder.proxies);
            for (Map.Entry<ModuleName, MavenBuildProxy2> e : this.proxies.entrySet()) {
                Maven3Builder maven3Builder2 = maven3Builder;
                maven3Builder2.getClass();
                e.setValue(maven3Builder2.new AbstractMavenBuilder.FilterImpl(e.getValue(), maven3Builder.mavenBuildInformation, Channel.current()));
                this.executedMojosPerModule.put(e.getKey(), new CopyOnWriteArrayList());
            }
            this.reporters.putAll(new ConcurrentHashMap(maven3Builder.reporters));
            this.eventLogger = new ExecutionEventLogger((Logger)new PrintStreamLogger(maven3Builder.listener.getLogger()));
        }

        private MavenBuildProxy2 getMavenBuildProxy2(MavenProject mavenProject) {
            for (Map.Entry<ModuleName, MavenBuildProxy2> entry : this.proxies.entrySet()) {
                if (entry.getKey().compareTo(new ModuleName(mavenProject)) != 0) continue;
                return entry.getValue();
            }
            return null;
        }

        private ExpressionEvaluator getExpressionEvaluator(MavenSession session, MojoExecution mojoExecution) {
            return new PluginParameterExpressionEvaluator(session, mojoExecution);
        }

        private List<MavenReporter> getMavenReporters(MavenProject mavenProject) {
            return this.reporters.get(new ModuleName(mavenProject));
        }

        private void initMojoStartTime(MavenProject mavenProject) {
            this.currentMojoStartPerModuleName.put(new ModuleName(mavenProject), new Date().getTime());
        }

        private Long getMojoStartTime(MavenProject mavenProject) {
            return this.currentMojoStartPerModuleName.get(new ModuleName(mavenProject));
        }

        public void projectDiscoveryStarted(ExecutionEvent event) {
            this.eventLogger.projectDiscoveryStarted(event);
        }

        public void sessionStarted(ExecutionEvent event) {
            this.eventLogger.sessionStarted(event);
            List projects = event.getSession().getProjects();
            this.debug("Projects to build: " + projects);
            HashSet<ModuleName> buildingProjects = new HashSet<ModuleName>();
            for (MavenProject mavenProject : projects) {
                buildingProjects.add(new ModuleName(mavenProject));
            }
            for (Map.Entry entry : this.proxies.entrySet()) {
                if (buildingProjects.contains(entry.getKey())) continue;
                MavenBuildProxy2 proxy = (MavenBuildProxy2)entry.getValue();
                proxy.start();
                proxy.setResult(Result.NOT_BUILT);
                proxy.end();
            }
        }

        public void sessionEnded(ExecutionEvent event) {
            this.debug("sessionEnded");
            this.eventLogger.sessionEnded(event);
        }

        public void projectSkipped(ExecutionEvent event) {
            this.debug("projectSkipped " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + ":" + event.getProject().getVersion());
            this.eventLogger.projectSkipped(event);
        }

        public void projectStarted(ExecutionEvent event) {
            this.debug("projectStarted " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + ":" + event.getProject().getVersion());
            this.recordProjectStarted(event);
            this.eventLogger.projectStarted(event);
        }

        private void recordProjectStarted(ExecutionEvent event) {
            MavenProject mavenProject = event.getProject();
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            mavenBuildProxy2.start();
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.enterModule(mavenBuildProxy2, mavenProject, this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.preBuild(mavenBuildProxy2, mavenProject, this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void projectSucceeded(ExecutionEvent event) {
            this.debug("projectSucceeded " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + ":" + event.getProject().getVersion());
            this.recordProjectSucceeded(event);
            this.eventLogger.projectSucceeded(event);
        }

        private void recordProjectSucceeded(ExecutionEvent event) {
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(event.getProject());
            mavenBuildProxy2.setResult(Result.SUCCESS);
            List<MavenReporter> mavenReporters = this.getMavenReporters(event.getProject());
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.leaveModule(mavenBuildProxy2, event.getProject(), this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.postBuild(mavenBuildProxy2, event.getProject(), this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            mavenBuildProxy2.end();
        }

        public void projectFailed(ExecutionEvent event) {
            this.debug("projectFailed " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + ":" + event.getProject().getVersion());
            this.recordProjectFailed(event);
            this.eventLogger.projectFailed(event);
        }

        private void recordProjectFailed(ExecutionEvent event) {
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(event.getProject());
            mavenBuildProxy2.setResult(Result.FAILURE);
            MavenProject mavenProject = event.getProject();
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.leaveModule(mavenBuildProxy2, mavenProject, this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.postBuild(mavenBuildProxy2, mavenProject, this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            mavenBuildProxy2.end();
        }

        public void mojoSkipped(ExecutionEvent event) {
            this.debug("mojoSkipped " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.eventLogger.mojoSkipped(event);
        }

        public void mojoStarted(ExecutionEvent event) {
            this.debug("mojoStarted " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.recordMojoStarted(event);
            this.eventLogger.mojoStarted(event);
        }

        private void recordMojoStarted(ExecutionEvent event) {
            this.initMojoStartTime(event.getProject());
            MavenProject mavenProject = event.getProject();
            MojoInfo mojoInfo = new MojoInfo(event);
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.preExecute(mavenBuildProxy2, mavenProject, mojoInfo, this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void mojoSucceeded(ExecutionEvent event) {
            this.debug("mojoSucceeded " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.recordMojoSucceeded(event);
            this.eventLogger.mojoSucceeded(event);
        }

        private void recordMojoSucceeded(ExecutionEvent event) {
            MavenProject mavenProject = event.getProject();
            MojoInfo mojoInfo = new MojoInfo(event);
            this.recordExecutionTime(event, mojoInfo);
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            mavenBuildProxy2.setExecutedMojos(this.executedMojosPerModule.get(new ModuleName(event)));
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.postExecute(mavenBuildProxy2, mavenProject, mojoInfo, this.maven3Builder.listener, this.getExecutionException(event));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void recordExecutionTime(ExecutionEvent event, MojoInfo mojoInfo) {
            Long startTime;
            MavenProject p = event.getProject();
            List<ExecutedMojo> m = this.executedMojosPerModule.get(new ModuleName(p));
            if (m == null) {
                m = new CopyOnWriteArrayList<ExecutedMojo>();
                this.executedMojosPerModule.put(new ModuleName(p), m);
            }
            m.add(new ExecutedMojo(mojoInfo, (startTime = this.getMojoStartTime(event.getProject())) == null ? 0L : new Date().getTime() - startTime));
        }

        public void mojoFailed(ExecutionEvent event) {
            this.debug("mojoFailed " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.recordMojoFailed(event);
            this.eventLogger.mojoFailed(event);
        }

        private void debug(String msg) {
            LOGGER.fine(msg);
            if (DEBUG) {
                this.maven3Builder.listener.getLogger().println(msg);
            }
        }

        private void recordMojoFailed(ExecutionEvent event) {
            MavenProject mavenProject = event.getProject();
            MojoInfo mojoInfo = new MojoInfo(event);
            this.recordExecutionTime(event, mojoInfo);
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            mavenBuildProxy2.setExecutedMojos(this.executedMojosPerModule.get(new ModuleName(event)));
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.postExecute(mavenBuildProxy2, mavenProject, mojoInfo, this.maven3Builder.listener, this.getExecutionException(event));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private Exception getExecutionException(ExecutionEvent event) {
            try {
                return event.getException();
            }
            catch (NoSuchMethodError e) {
                return null;
            }
        }

        public void forkStarted(ExecutionEvent event) {
            LOGGER.fine("mojo forkStarted " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.recordMojoStarted(event);
        }

        public void forkSucceeded(ExecutionEvent event) {
            LOGGER.fine("mojo forkSucceeded " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.recordMojoSucceeded(event);
        }

        public void forkFailed(ExecutionEvent event) {
            LOGGER.fine("mojo forkFailed " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.recordMojoFailed(event);
        }

        public void forkedProjectStarted(ExecutionEvent event) {
            LOGGER.fine("forkedProjectStarted " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + event.getProject().getVersion());
            this.recordProjectStarted(event);
            this.eventLogger.forkedProjectStarted(event);
        }

        public void forkedProjectSucceeded(ExecutionEvent event) {
            LOGGER.fine("forkedProjectSucceeded " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + event.getProject().getVersion());
            this.recordProjectSucceeded(event);
            this.eventLogger.forkedProjectSucceeded(event);
        }

        public void forkedProjectFailed(ExecutionEvent event) {
            LOGGER.fine("forkedProjectFailed " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + ":" + event.getProject().getVersion());
            this.recordProjectFailed(event);
        }
    }
}

