/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.AbstractMavenProcessFactory;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenProcessFactory;
import hudson.maven.Messages;
import hudson.maven.ProcessCache;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Which;
import hudson.tasks.Maven;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.jvnet.hudson.maven3.agent.Maven3Main;
import org.jvnet.hudson.maven3.launcher.Maven3Launcher;

public class Maven3ProcessFactory
extends AbstractMavenProcessFactory
implements ProcessCache.Factory {
    private static final FilenameFilter CLASSWORLDS_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.contains("plexus-classworlds") && name.endsWith(".jar");
        }
    };

    Maven3ProcessFactory(MavenModuleSet mms, Launcher launcher, EnvVars envVars, String mavenOpts, FilePath workDir) {
        super(mms, launcher, envVars, mavenOpts, workDir);
    }

    protected String getMavenAgentClassPath(Maven.MavenInstallation mvn, boolean isMaster, FilePath slaveRoot, BuildListener listener) throws IOException, InterruptedException {
        String classWorldsJar = (String)this.getLauncher().getChannel().call((Callable)new GetClassWorldsJar(mvn.getHome(), (TaskListener)listener));
        return (isMaster ? Which.jarFile(Maven3Main.class).getAbsolutePath() : slaveRoot.child("maven3-agent.jar").getRemote()) + (this.getLauncher().isUnix() ? ":" : ";") + classWorldsJar;
    }

    protected String getMainClassName() {
        return Maven3Main.class.getName();
    }

    protected String getMavenInterceptorClassPath(Maven.MavenInstallation mvn, boolean isMaster, FilePath slaveRoot) throws IOException, InterruptedException {
        return isMaster ? Which.jarFile(Maven3Launcher.class).getAbsolutePath() : slaveRoot.child("maven3-interceptor.jar").getRemote();
    }

    protected String getMavenInterceptorOverride(Maven.MavenInstallation mvn, boolean isMaster, FilePath slaveRoot) throws IOException, InterruptedException {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetClassWorldsJar
    implements Callable<String, IOException> {
        private static final long serialVersionUID = -2599434124883557137L;
        private final String mvnHome;
        private final TaskListener listener;

        private GetClassWorldsJar(String mvnHome, TaskListener listener) {
            this.mvnHome = mvnHome;
            this.listener = listener;
        }

        public String call() throws IOException {
            File bootDir;
            File[] classworlds;
            File home = new File(this.mvnHome);
            if (MavenProcessFactory.debug) {
                this.listener.getLogger().println("Using mvnHome: " + this.mvnHome);
            }
            if ((classworlds = (bootDir = new File(home, "boot")).listFiles(CLASSWORLDS_FILTER)) == null || classworlds.length == 0) {
                this.listener.error(Messages.MavenProcessFactory_ClassWorldsNotFound(home));
                throw new Run.RunnerAbortedException();
            }
            return classworlds[0].getAbsolutePath();
        }
    }
}

