/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Functions;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenProjectActionBuilder;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MavenReporters;
import hudson.maven.Messages;
import hudson.maven.ModuleDependency;
import hudson.maven.ModuleName;
import hudson.maven.PomInfo;
import hudson.maven.RedeployPublisher;
import hudson.maven.reporters.MavenMailer;
import hudson.model.Action;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JDK;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Resource;
import hudson.model.Saveable;
import hudson.tasks.LogRotator;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenModule
extends AbstractMavenProject<MavenModule, MavenBuild>
implements Saveable {
    private DescribableList<MavenReporter, Descriptor<MavenReporter>> reporters = new DescribableList((Saveable)this);
    private String displayName;
    private String version;
    private String packaging;
    private transient ModuleName moduleName;
    private String relativePath;
    private String goals;
    private volatile Set<ModuleDependency> dependencies;
    private volatile List<ModuleName> children;
    volatile transient int nestLevel;
    private static final Logger LOGGER = Logger.getLogger(MavenModule.class.getName());

    MavenModule(MavenModuleSet parent, PomInfo pom, int firstBuildNumber) throws IOException {
        super(parent, pom.name.toFileSystemName());
        this.reconfigure(pom);
        this.updateNextBuildNumber(firstBuildNumber);
    }

    public LogRotator getLogRotator() {
        return this.getParent().getLogRotator();
    }

    public void setLogRotator(LogRotator logRotator) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsLogRotator() {
        return false;
    }

    public boolean isBuildable() {
        return super.isBuildable() && this.getParent().isBuildable();
    }

    public List<MavenModule> getSubsidiaries() {
        ArrayList<MavenModule> r = new ArrayList<MavenModule>();
        for (MavenModule mm : this.getParent().getModules()) {
            if (mm == this || !mm.getRelativePath().startsWith(this.getRelativePath())) continue;
            r.add(mm);
        }
        return r;
    }

    void reconfigure(PomInfo pom) {
        MavenReporter reporter;
        this.displayName = pom.displayName;
        this.version = pom.version;
        this.packaging = pom.packaging;
        this.relativePath = pom.relativePath;
        this.dependencies = pom.dependencies;
        this.children = pom.children;
        this.nestLevel = pom.getNestLevel();
        this.disabled = false;
        if (pom.mailNotifier != null && (reporter = (MavenReporter)this.getReporters().get(MavenMailer.class)) != null) {
            MavenMailer mailer = (MavenMailer)reporter;
            mailer.dontNotifyEveryUnstableBuild = !pom.mailNotifier.isSendOnFailure();
            String recipients = pom.mailNotifier.getConfiguration().getProperty("recipients");
            if (recipients != null) {
                mailer.recipients = recipients;
            }
        }
    }

    public boolean isSameModule(PomInfo pom) {
        return pom.isSimilar(this.moduleName, this.dependencies);
    }

    protected void doSetName(String name) {
        this.moduleName = ModuleName.fromFileSystemName(name);
        super.doSetName(this.moduleName.toString());
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        if (this.reporters == null) {
            this.reporters = new DescribableList((Saveable)this);
        }
        this.reporters.setOwner((Saveable)this);
        if (this.dependencies == null) {
            this.dependencies = Collections.emptySet();
        } else {
            HashSet<ModuleDependency> deps = new HashSet<ModuleDependency>(this.dependencies.size());
            for (ModuleDependency d : this.dependencies) {
                if (d instanceof ModuleDependency) {
                    deps.add(d);
                    continue;
                }
                deps.add(new ModuleDependency((ModuleName)((Object)d), "*", false));
            }
            this.dependencies = deps;
        }
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGoals() {
        if (this.goals != null) {
            return this.goals;
        }
        return this.getParent().getGoals();
    }

    public String getUserConfiguredGoals() {
        return this.goals;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return new DescribableList((Saveable)this);
    }

    public JDK getJDK() {
        return this.getParent().getJDK();
    }

    protected Class<MavenBuild> getBuildClass() {
        return MavenBuild.class;
    }

    protected MavenBuild newBuild() throws IOException {
        return (MavenBuild)super.newBuild();
    }

    public ModuleName getModuleName() {
        return this.moduleName;
    }

    public ModuleDependency asDependency() {
        return new ModuleDependency(this.moduleName, (String)Functions.defaulted((Object)this.version, (Object)"*"), "maven-plugin".equals(this.packaging));
    }

    public String getShortUrl() {
        return this.moduleName.toFileSystemName() + '/';
    }

    @Exported(visibility=2)
    public String getDisplayName() {
        return this.displayName;
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)Messages.MavenModule_Pronoun());
    }

    public boolean isNameEditable() {
        return false;
    }

    public MavenModuleSet getParent() {
        return (MavenModuleSet)super.getParent();
    }

    public List<MavenModule> getChildren() {
        List<ModuleName> l = this.children;
        if (l == null) {
            return null;
        }
        ArrayList<MavenModule> modules = new ArrayList<MavenModule>(l.size());
        for (ModuleName n : l) {
            MavenModule m = this.getParent().modules.get(n);
            if (m == null) continue;
            modules.add(m);
        }
        return modules;
    }

    public Label getAssignedLabel() {
        Node n = this.getParent().getLastBuiltOn();
        if (n == null) {
            return null;
        }
        return n.getSelfLabel();
    }

    public Resource getWorkspaceResource() {
        return new Resource(this.getParent().getWorkspaceResource(), this.getDisplayName() + " workspace");
    }

    public boolean isFingerprintConfigured() {
        return true;
    }

    protected void updateTransientActions() {
        super.updateTransientActions();
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        ModuleDependency moduleDependency;
        if (!this.isBuildable() || this.getParent().ignoreUpstremChanges()) {
            return;
        }
        MavenDependencyComputationData data = (MavenDependencyComputationData)graph.getComputationalData(MavenDependencyComputationData.class);
        boolean hasDependenciesWithUnknownVersion = this.hasDependenciesWithUnknownVersion();
        if (data == null) {
            HashMap<ModuleDependency, MavenModule> modules = new HashMap<ModuleDependency, MavenModule>();
            for (MavenModule m : this.getAllMavenModules()) {
                if (!m.isBuildable()) continue;
                moduleDependency = m.asDependency();
                MavenModule old = (MavenModule)((Object)modules.get(moduleDependency));
                MavenModule relevant = this.chooseMoreRelevantModule(old, m, moduleDependency);
                modules.put(moduleDependency, relevant);
                if (!hasDependenciesWithUnknownVersion) continue;
                modules.put(moduleDependency.withUnknownVersion(), relevant);
            }
            data = new MavenDependencyComputationData(modules);
            data.withUnknownVersions = hasDependenciesWithUnknownVersion;
            graph.putComputationalData(MavenDependencyComputationData.class, (Object)data);
        } else if (hasDependenciesWithUnknownVersion && !data.withUnknownVersions) {
            for (MavenModule m : this.getAllMavenModules()) {
                if (m.isDisabled()) continue;
                ModuleDependency moduleDependency2 = m.asDependency().withUnknownVersion();
                data.allModules.put(moduleDependency2, m);
            }
            data.withUnknownVersions = true;
        }
        HashMap<ModuleDependency, MavenModule> myParentsModules = new HashMap<ModuleDependency, MavenModule>();
        for (MavenModule m : this.getParent().getModules()) {
            if (m.isDisabled()) continue;
            moduleDependency = m.asDependency();
            myParentsModules.put(moduleDependency, m);
            if (!hasDependenciesWithUnknownVersion) continue;
            myParentsModules.put(moduleDependency.withUnknownVersion(), m);
        }
        AbstractMavenProject dest = this.getParent().isAggregatorStyleBuild() ? this.getParent() : this;
        for (ModuleDependency d : this.dependencies) {
            AbstractMavenProject.MavenModuleDependency dep;
            MavenModule src = (MavenModule)((Object)myParentsModules.get(d));
            if (src == null) {
                src = data.allModules.get(d);
            }
            if (src == null || (dep = new AbstractMavenProject.MavenModuleDependency(src.getParent().isAggregatorStyleBuild() ? src.getParent() : src, dest)).pointsItself()) continue;
            graph.addDependency((DependencyGraph.Dependency)dep);
        }
    }

    protected Collection<MavenModule> getAllMavenModules() {
        return Jenkins.getInstance().getAllItems(MavenModule.class);
    }

    private boolean hasDependenciesWithUnknownVersion() {
        for (ModuleDependency dep : this.dependencies) {
            if (!"*".equals(dep.version)) continue;
            return true;
        }
        return false;
    }

    private MavenModule chooseMoreRelevantModule(MavenModule mm1, MavenModule mm2, ModuleDependency moduleDependency) {
        MavenModule lessRelevant;
        MavenModule moreRelevant;
        int relevancy2;
        if (mm1 == null) {
            return mm2;
        }
        if (mm2 == null) {
            return mm1;
        }
        int relevancy1 = this.getDependencyRelevancy(mm1);
        if (relevancy1 > (relevancy2 = this.getDependencyRelevancy(mm2))) {
            moreRelevant = mm1;
            lessRelevant = mm2;
        } else if (relevancy2 > relevancy1) {
            moreRelevant = mm2;
            lessRelevant = mm1;
        } else if (mm1.getParent().getName().compareTo(mm2.getParent().getName()) < 0) {
            moreRelevant = mm2;
            lessRelevant = mm1;
        } else {
            moreRelevant = mm1;
            lessRelevant = mm2;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Choosing " + moreRelevant.getParent().getName() + " over " + lessRelevant.getParent().getName() + " for module " + moduleDependency.getName() + ". Relevancies: " + relevancy1 + ", " + relevancy2);
        }
        return moreRelevant;
    }

    private int getDependencyRelevancy(MavenModule mm) {
        int relevancy = 0;
        for (String goal : Util.tokenize((String)mm.getGoals())) {
            if ("deploy".equals(goal) || "deploy:deploy".equals(goal)) {
                return 2;
            }
            if (!"install".equals(goal)) continue;
            relevancy = 1;
        }
        for (Publisher publisher : mm.getParent().getPublishers()) {
            if (!(publisher instanceof RedeployPublisher)) continue;
            return 2;
        }
        return relevancy;
    }

    @Override
    protected void addTransientActionsFromBuild(MavenBuild build, List<Action> collection, Set<Class> added) {
        if (build == null) {
            return;
        }
        List<MavenProjectActionBuilder> list = build.projectActionReporters;
        if (list == null) {
            return;
        }
        for (MavenProjectActionBuilder step : list) {
            if (!added.add(step.getClass())) continue;
            try {
                collection.addAll(step.getProjectActions(this));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to getProjectAction from " + step + ". Report issue to plugin developers.", e);
            }
        }
    }

    public Maven.MavenInstallation inferMavenInstallation() {
        return this.getParent().inferMavenInstallation();
    }

    public DescribableList<MavenReporter, Descriptor<MavenReporter>> getReporters() {
        return this.reporters;
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        this.reporters.rebuild(req, req.getSubmittedForm(), MavenReporters.getConfigurableList());
        this.goals = Util.fixEmpty((String)req.getParameter("goals").trim());
        Jenkins.getInstance().rebuildDependencyGraph();
    }

    protected void performDelete() throws IOException, InterruptedException {
        super.performDelete();
        this.getParent().onModuleDeleted(this);
    }

    protected List<MavenReporter> createReporters() {
        ArrayList<MavenReporter> reporterList = new ArrayList<MavenReporter>();
        this.getReporters().addAllTo(reporterList);
        this.getParent().getReporters().addAllTo(reporterList);
        for (MavenReporterDescriptor d : MavenReporterDescriptor.all()) {
            MavenReporter auto;
            if (this.getReporters().contains((Descriptor)d) || (auto = d.newAutoInstance(this)) == null) continue;
            reporterList.add(auto);
        }
        return reporterList;
    }

    public String toString() {
        return super.toString() + '[' + this.getFullName() + ']' + "[relativePath:" + this.getRelativePath() + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MavenDependencyComputationData {
        boolean withUnknownVersions = false;
        Map<ModuleDependency, MavenModule> allModules;

        public MavenDependencyComputationData(Map<ModuleDependency, MavenModule> modules) {
            this.allModules = modules;
        }
    }
}

