/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Indenter;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporters;
import hudson.maven.Messages;
import hudson.maven.ModuleName;
import hudson.maven.PomInfo;
import hudson.maven.settings.SettingsProviderUtils;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.ResourceActivity;
import hudson.model.Result;
import hudson.model.SCMedItem;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.search.CollectionSearchIndex;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrappers;
import hudson.tasks.Builder;
import hudson.tasks.Fingerprinter;
import hudson.tasks.JavadocArchiver;
import hudson.tasks.Mailer;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.Function1;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.math.NumberUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenModuleSet
extends AbstractMavenProject<MavenModuleSet, MavenModuleSetBuild>
implements TopLevelItem,
ItemGroup<MavenModule>,
SCMedItem,
Saveable,
BuildableItemWithBuildWrappers {
    transient Map<ModuleName, MavenModule> modules = new CopyOnWriteMap.Tree();
    transient List<MavenModule> sortedActiveModules;
    private ModuleName rootModule;
    private String rootPOM;
    private String goals;
    private String alternateSettings;
    private String defaultGoals;
    private String mavenName;
    private String mavenOpts;
    private boolean aggregatorStyleBuild = true;
    private boolean incrementalBuild = false;
    private boolean usePrivateRepository = false;
    private boolean ignoreUpstremChanges = false;
    private boolean archivingDisabled = false;
    private boolean resolveDependencies = false;
    private boolean processPlugins = false;
    private int mavenValidationLevel = -1;
    private boolean runHeadless = false;
    private String settingConfigId;
    private String globalSettingConfigId;
    protected transient String globalSettingConfigPath;
    private DescribableList<MavenReporter, Descriptor<MavenReporter>> reporters = new DescribableList((Saveable)this);
    private DescribableList<Publisher, Descriptor<Publisher>> publishers = new DescribableList((Saveable)this);
    private DescribableList<BuildWrapper, Descriptor<BuildWrapper>> buildWrappers = new DescribableList((Saveable)this);
    private DescribableList<Builder, Descriptor<Builder>> prebuilders = new DescribableList((Saveable)this);
    private DescribableList<Builder, Descriptor<Builder>> postbuilders = new DescribableList((Saveable)this);
    private Result runPostStepsIfResult;
    @Extension(ordinal=900.0)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public MavenModuleSet(String name) {
        this((ItemGroup)Jenkins.getInstance(), name);
    }

    public MavenModuleSet(ItemGroup parent, String name) {
        super(parent, name);
    }

    public DescribableList<Builder, Descriptor<Builder>> getPrebuilders() {
        return this.prebuilders;
    }

    public DescribableList<Builder, Descriptor<Builder>> getPostbuilders() {
        return this.postbuilders;
    }

    public Result getRunPostStepsIfResult() {
        return (Result)Functions.defaulted((Object)this.runPostStepsIfResult, (Object)Result.FAILURE);
    }

    public void setRunPostStepsIfResult(Result v) {
        this.runPostStepsIfResult = (Result)Functions.defaulted((Object)v, (Object)Result.FAILURE);
    }

    public String getUrlChildPrefix() {
        return ".";
    }

    public Collection<MavenModule> getItems() {
        return this.modules.values();
    }

    @Exported
    public Collection<MavenModule> getModules() {
        return this.getItems();
    }

    public MavenModule getItem(String name) {
        return this.modules.get(ModuleName.fromString(name));
    }

    public MavenModule getModule(String name) {
        return this.getItem(name);
    }

    protected void updateTransientActions() {
        super.updateTransientActions();
    }

    @Override
    protected List<Action> createTransientActions() {
        List<Action> r = super.createTransientActions();
        for (MavenModule module : this.modules.values()) {
            module.updateTransientActions();
        }
        if (this.publishers != null) {
            for (Publisher step : this.publishers) {
                r.addAll(step.getProjectActions((AbstractProject)this));
            }
        }
        if (this.buildWrappers != null) {
            for (Publisher step : this.buildWrappers) {
                r.addAll(step.getProjectActions((AbstractProject)this));
            }
        }
        return r;
    }

    @Override
    protected void addTransientActionsFromBuild(MavenModuleSetBuild build, List<Action> collection, Set<Class> added) {
        if (build == null) {
            return;
        }
        for (Action a : build.getActions()) {
            if (!(a instanceof MavenAggregatedReport) || !added.add(a.getClass())) continue;
            collection.add(((MavenAggregatedReport)a).getProjectAction(this));
        }
        List<MavenReporter> list = build.projectActionReporters;
        if (list == null) {
            return;
        }
        for (MavenReporter step : list) {
            Action a;
            if (!added.add(step.getClass()) || (a = step.getAggregatedProjectAction(this)) == null) continue;
            collection.add(a);
        }
    }

    void onModuleDeleted(MavenModule module) {
        this.modules.remove(module.getModuleName());
    }

    public boolean hasDisabledModule() {
        for (MavenModule m : this.modules.values()) {
            if (!m.isDisabled()) continue;
            return true;
        }
        return false;
    }

    public List<MavenModule> getDisabledModules(boolean disabled) {
        if (!disabled && this.sortedActiveModules != null) {
            return this.sortedActiveModules;
        }
        ArrayList<MavenModule> r = new ArrayList<MavenModule>();
        for (MavenModule m : this.modules.values()) {
            if (m.isDisabled() != disabled) continue;
            r.add(m);
        }
        return r;
    }

    public Indenter<MavenModule> createIndenter() {
        return new Indenter<MavenModule>(){

            protected int getNestLevel(MavenModule job) {
                return job.nestLevel;
            }
        };
    }

    public boolean isIncrementalBuild() {
        return this.incrementalBuild;
    }

    public boolean isAggregatorStyleBuild() {
        return this.aggregatorStyleBuild;
    }

    public boolean usesPrivateRepository() {
        return this.usePrivateRepository;
    }

    public boolean ignoreUpstremChanges() {
        return this.ignoreUpstremChanges;
    }

    public boolean runHeadless() {
        return this.runHeadless;
    }

    public boolean isArchivingDisabled() {
        return this.archivingDisabled;
    }

    public void setIncrementalBuild(boolean incrementalBuild) {
        this.incrementalBuild = incrementalBuild;
    }

    public void setAggregatorStyleBuild(boolean aggregatorStyleBuild) {
        this.aggregatorStyleBuild = aggregatorStyleBuild;
    }

    public void setUsePrivateRepository(boolean usePrivateRepository) {
        this.usePrivateRepository = usePrivateRepository;
    }

    public void setIgnoreUpstremChanges(boolean ignoreUpstremChanges) {
        this.ignoreUpstremChanges = ignoreUpstremChanges;
    }

    public void setRunHeadless(boolean runHeadless) {
        this.runHeadless = runHeadless;
    }

    public void setIsArchivingDisabled(boolean archivingDisabled) {
        this.archivingDisabled = archivingDisabled;
    }

    public boolean isResolveDependencies() {
        return this.resolveDependencies;
    }

    public void setResolveDependencies(boolean resolveDependencies) {
        this.resolveDependencies = resolveDependencies;
    }

    public boolean isProcessPlugins() {
        return this.processPlugins;
    }

    public void setProcessPlugins(boolean processPlugins) {
        this.processPlugins = processPlugins;
    }

    public int getMavenValidationLevel() {
        return this.mavenValidationLevel;
    }

    public String getSettingConfigId() {
        return this.settingConfigId;
    }

    public void setSettingConfigId(String settingConfigId) {
        this.settingConfigId = settingConfigId;
    }

    public String getGlobalSettingConfigId() {
        return this.globalSettingConfigId;
    }

    public void setGlobalSettingConfigId(String globalSettingConfigId) {
        this.globalSettingConfigId = globalSettingConfigId;
    }

    public DescribableList<MavenReporter, Descriptor<MavenReporter>> getReporters() {
        return this.reporters;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishers() {
        return this.publishers;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return this.publishers;
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        return this.buildWrappers;
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappers() {
        return this.buildWrappers;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (ModuleName.isValid(token)) {
            return this.getModule(token);
        }
        return super.getDynamic(token, req, rsp);
    }

    public File getRootDirFor(MavenModule child) {
        return new File(this.getModulesDir(), child.getModuleName().toFileSystemName());
    }

    public void onRenamed(MavenModule item, String oldName, String newName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void onDeleted(MavenModule item) throws IOException {
    }

    public Collection<Job> getAllJobs() {
        HashSet<MavenModule> jobs = new HashSet<MavenModule>(this.getItems());
        jobs.add((MavenModule)((Object)this));
        return jobs;
    }

    protected Class<MavenModuleSetBuild> getBuildClass() {
        return MavenModuleSetBuild.class;
    }

    protected SearchIndexBuilder makeSearchIndex() {
        return super.makeSearchIndex().add((SearchIndex)new CollectionSearchIndex<MavenModule>(){

            protected MavenModule get(String key) {
                for (MavenModule m : MavenModuleSet.this.modules.values()) {
                    if (!m.getDisplayName().equals(key)) continue;
                    return m;
                }
                return null;
            }

            protected Collection<MavenModule> all() {
                return MavenModuleSet.this.modules.values();
            }

            protected String getName(MavenModule o) {
                return o.getName();
            }
        });
    }

    public boolean isFingerprintConfigured() {
        return true;
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        this.modules = Collections.emptyMap();
        super.onLoad(parent, name);
        this.modules = ItemGroupMixIn.loadChildren((ItemGroup)this, (File)this.getModulesDir(), (Function1)new Function1<ModuleName, MavenModule>(){

            public ModuleName call(MavenModule module) {
                return module.getModuleName();
            }
        });
        MavenModule root = this.getRootModule();
        if (root != null && root.getChildren() != null) {
            ArrayList<MavenModule> sortedList = new ArrayList<MavenModule>();
            Stack<MavenModule> q = new Stack<MavenModule>();
            root.nestLevel = 0;
            q.push(root);
            while (!q.isEmpty()) {
                MavenModule p = (MavenModule)((Object)q.pop());
                sortedList.add(p);
                List<MavenModule> children = p.getChildren();
                if (children == null) continue;
                for (MavenModule m : children) {
                    m.nestLevel = p.nestLevel + 1;
                }
                for (int i = children.size() - 1; i >= 0; --i) {
                    q.push(children.get(i));
                }
            }
            this.sortedActiveModules = sortedList;
        } else {
            this.sortedActiveModules = this.getDisabledModules(false);
        }
        if (this.reporters == null) {
            this.reporters = new DescribableList((Saveable)this);
        }
        this.reporters.setOwner((Saveable)this);
        if (this.publishers == null) {
            this.publishers = new DescribableList((Saveable)this);
        }
        this.publishers.setOwner((Saveable)this);
        if (this.buildWrappers == null) {
            this.buildWrappers = new DescribableList((Saveable)this);
        }
        this.buildWrappers.setOwner((Saveable)this);
        if (this.prebuilders == null) {
            this.prebuilders = new DescribableList((Saveable)this);
        }
        this.prebuilders.setOwner((Saveable)this);
        if (this.postbuilders == null) {
            this.postbuilders = new DescribableList((Saveable)this);
        }
        this.postbuilders.setOwner((Saveable)this);
        this.updateTransientActions();
    }

    private File getModulesDir() {
        return new File(this.getRootDir(), "modules");
    }

    public synchronized int assignBuildNumber() throws IOException {
        this.updateNextBuildNumber();
        return super.assignBuildNumber();
    }

    public void logRotate() throws IOException, InterruptedException {
        super.logRotate();
        for (MavenModule m : this.modules.values()) {
            m.logRotate();
        }
    }

    void updateNextBuildNumber() throws IOException {
        int next = this.nextBuildNumber;
        for (MavenModule m : this.modules.values()) {
            next = Math.max(next, m.getNextBuildNumber());
        }
        if (this.nextBuildNumber != next) {
            this.nextBuildNumber = next;
            this.saveNextBuildNumber();
        }
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        this.publishers.buildDependencyGraph((AbstractProject)this, graph);
        this.buildWrappers.buildDependencyGraph((AbstractProject)this, graph);
        this.prebuilders.buildDependencyGraph((AbstractProject)this, graph);
        this.postbuilders.buildDependencyGraph((AbstractProject)this, graph);
    }

    public MavenModule getRootModule() {
        if (this.rootModule == null) {
            return null;
        }
        return this.modules.get(this.rootModule);
    }

    public Maven.MavenInstallation inferMavenInstallation() {
        return this.getMaven();
    }

    protected Set<ResourceActivity> getResourceActivities() {
        HashSet<ResourceActivity> activities = new HashSet<ResourceActivity>();
        activities.addAll(super.getResourceActivities());
        activities.addAll(Util.filter(this.publishers, ResourceActivity.class));
        activities.addAll(Util.filter(this.buildWrappers, ResourceActivity.class));
        activities.addAll(Util.filter(this.prebuilders, ResourceActivity.class));
        activities.addAll(Util.filter(this.postbuilders, ResourceActivity.class));
        return activities;
    }

    public String getRootPOM() {
        if (this.rootPOM == null) {
            return "pom.xml";
        }
        return this.rootPOM;
    }

    public void setRootPOM(String rootPOM) {
        this.rootPOM = rootPOM;
    }

    public AbstractProject<?, ?> asProject() {
        return this;
    }

    public String getGoals() {
        if (this.goals == null) {
            if (this.defaultGoals != null) {
                return this.defaultGoals;
            }
            return "install";
        }
        return this.goals;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    private boolean checkMavenOption(String shortForm, String longForm) {
        for (String t : Util.tokenize((String)this.getGoals())) {
            if (!t.equals(shortForm) && !t.equals(longForm)) continue;
            return true;
        }
        return false;
    }

    private List<String> getMavenArgument(String shortForm, String longForm) {
        ArrayList<String> args = new ArrayList<String>();
        boolean switchFound = false;
        for (String t : Util.tokenize((String)this.getGoals())) {
            if (switchFound) {
                args.add(t);
                switchFound = false;
                continue;
            }
            if (t.equals(shortForm) || t.equals(longForm)) {
                switchFound = true;
                continue;
            }
            if (t.startsWith(shortForm)) {
                args.add(t.substring(shortForm.length()));
                continue;
            }
            if (!t.startsWith(longForm)) continue;
            args.add(t.substring(longForm.length()));
        }
        return args;
    }

    public String getAlternateSettings() {
        return this.alternateSettings;
    }

    public void setAlternateSettings(String alternateSettings) throws IOException {
        this.alternateSettings = alternateSettings;
        this.save();
    }

    public String getProfiles() {
        return Util.join(this.getMavenArgument("-P", "--activate-profiles"), (String)",");
    }

    public Properties getMavenProperties() {
        Properties props = new Properties();
        for (String arg : this.getMavenArgument("-D", "--define")) {
            int idx = arg.indexOf(61);
            if (idx < 0) {
                props.put(arg, "true");
                continue;
            }
            props.put(arg.substring(0, idx), arg.substring(idx + 1));
        }
        return props;
    }

    public boolean isNonRecursive() {
        return this.checkMavenOption("-N", "--non-recursive");
    }

    public String getMavenOpts() {
        if (this.mavenOpts != null && this.mavenOpts.trim().length() > 0) {
            return this.mavenOpts.replaceAll("[\t\r\n]+", " ");
        }
        String globalOpts = DESCRIPTOR.getGlobalMavenOpts();
        if (globalOpts != null) {
            return globalOpts.replaceAll("[\t\r\n]+", " ");
        }
        return globalOpts;
    }

    public List<Config> getAllMavenSettingsConfigs() {
        ArrayList<Config> mavenSettingsConfigs = new ArrayList<Config>();
        ExtensionList configProviders = ConfigProvider.all();
        if (configProviders != null && configProviders.size() > 0) {
            for (ConfigProvider configProvider : configProviders) {
                if (!SettingsProviderUtils.isMavenSettingsProvider(configProvider)) continue;
                mavenSettingsConfigs.addAll(configProvider.getAllConfigs());
            }
        }
        return mavenSettingsConfigs;
    }

    public List<Config> getAllGlobalMavenSettingsConfigs() {
        ArrayList<Config> globalMavenSettingsConfigs = new ArrayList<Config>();
        ExtensionList configProviders = ConfigProvider.all();
        if (configProviders != null && configProviders.size() > 0) {
            for (ConfigProvider configProvider : configProviders) {
                if (!SettingsProviderUtils.isGlobalMavenSettingsProvider(configProvider)) continue;
                globalMavenSettingsConfigs.addAll(configProvider.getAllConfigs());
            }
        }
        return globalMavenSettingsConfigs;
    }

    public void setMavenOpts(String mavenOpts) {
        this.mavenOpts = mavenOpts;
    }

    public Maven.MavenInstallation getMaven() {
        for (Maven.MavenInstallation i : DESCRIPTOR.getMavenDescriptor().getInstallations()) {
            if (this.mavenName != null && !i.getName().equals(this.mavenName)) continue;
            return i;
        }
        return null;
    }

    public void setMaven(String mavenName) {
        this.mavenName = mavenName;
    }

    public List<Queue.Item> getQueueItems() {
        ArrayList<Queue.Item> r = new ArrayList<Queue.Item>();
        for (Queue.Item item : Jenkins.getInstance().getQueue().getItems()) {
            Queue.Task t = item.task;
            if ((!(t instanceof MavenModule) || ((MavenModule)t).getParent() != this) && t != this) continue;
            r.add(item);
        }
        return r;
    }

    public String getUserConfiguredGoals() {
        return this.goals;
    }

    void reconfigure(PomInfo rootPom) throws IOException {
        if (this.rootModule != null && this.rootModule.equals(rootPom.name)) {
            return;
        }
        this.rootModule = rootPom.name;
        this.defaultGoals = rootPom.defaultGoal;
        this.save();
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.rootPOM = Util.fixEmpty((String)req.getParameter("rootPOM").trim());
        if (this.rootPOM != null && this.rootPOM.equals("pom.xml")) {
            this.rootPOM = null;
        }
        this.goals = Util.fixEmpty((String)req.getParameter("goals").trim());
        this.alternateSettings = Util.fixEmpty((String)req.getParameter("alternateSettings").trim());
        this.mavenOpts = Util.fixEmpty((String)req.getParameter("mavenOpts").trim());
        this.mavenName = req.getParameter("maven_version");
        this.aggregatorStyleBuild = !req.hasParameter("maven.perModuleBuild");
        this.usePrivateRepository = req.hasParameter("maven.usePrivateRepository");
        this.ignoreUpstremChanges = !json.has("triggerByDependency");
        this.runHeadless = req.hasParameter("maven.runHeadless");
        this.incrementalBuild = req.hasParameter("maven.incrementalBuild");
        this.archivingDisabled = req.hasParameter("maven.archivingDisabled");
        this.resolveDependencies = req.hasParameter("maven.resolveDependencies");
        this.processPlugins = req.hasParameter("maven.processPlugins");
        this.mavenValidationLevel = NumberUtils.toInt((String)req.getParameter("maven.validationLevel"), (int)-1);
        this.reporters.rebuild(req, json, MavenReporters.getConfigurableList());
        this.publishers.rebuild(req, json, BuildStepDescriptor.filter((List)Publisher.all(), ((Object)((Object)this)).getClass()));
        this.buildWrappers.rebuild(req, json, BuildWrappers.getFor((AbstractProject)this));
        this.settingConfigId = req.getParameter("maven.mavenSettingsConfigId");
        this.globalSettingConfigId = req.getParameter("maven.mavenGlobalSettingConfigId");
        this.runPostStepsIfResult = Result.fromString((String)req.getParameter("post-steps.runIfResult"));
        this.prebuilders.rebuildHetero(req, json, (Collection)Builder.all(), "prebuilder");
        this.postbuilders.rebuildHetero(req, json, (Collection)Builder.all(), "postbuilder");
    }

    public HttpResponse doDoDeleteAllDisabledModules() throws IOException, InterruptedException {
        this.checkPermission(DELETE);
        for (MavenModule m : this.getDisabledModules(true)) {
            m.delete();
        }
        return HttpResponses.redirectToDot();
    }

    public FormValidation doCheckFileInWorkspace(@QueryParameter String value) throws IOException, ServletException {
        FilePath ws;
        MavenModuleSetBuild lb = (MavenModuleSetBuild)this.getLastBuild();
        if (lb != null && (ws = lb.getModuleRoot()) != null) {
            return ws.validateRelativePath(value, true, true);
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckFileRelative(@QueryParameter String value) throws IOException, ServletException {
        FilePath ws;
        String v = Util.fixEmpty((String)value);
        if (v == null || v.length() == 0) {
            return FormValidation.ok();
        }
        if (v.startsWith("/") || v.startsWith("\\") || v.matches("^\\w\\:\\\\.*")) {
            return FormValidation.error((String)Messages.MavenModuleSet_AlternateSettingsRelativePath());
        }
        MavenModuleSetBuild lb = (MavenModuleSetBuild)this.getLastBuild();
        if (lb != null && (ws = lb.getWorkspace()) != null) {
            return ws.validateRelativePath(value, true, true);
        }
        return FormValidation.ok();
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends AbstractProject.AbstractProjectDescriptor {
        private String globalMavenOpts;
        private Map<String, Integer> mavenValidationLevels = new LinkedHashMap<String, Integer>();
        private static final Set<Class> NOT_APPLICABLE_TYPES = new HashSet<Class>(Arrays.asList(Fingerprinter.class, JavadocArchiver.class, Mailer.class, JUnitResultArchiver.class));

        public DescriptorImpl() {
            this.load();
            this.mavenValidationLevels.put("DEFAULT", -1);
            this.mavenValidationLevels.put("LEVEL_MINIMAL", 0);
            this.mavenValidationLevels.put("LEVEL_MAVEN_2_0", 20);
            this.mavenValidationLevels.put("LEVEL_MAVEN_3_0", 30);
            this.mavenValidationLevels.put("LEVEL_MAVEN_3_1", 31);
            this.mavenValidationLevels.put("LEVEL_STRICT", 30);
        }

        public String getGlobalMavenOpts() {
            return this.globalMavenOpts;
        }

        public void setGlobalMavenOpts(String globalMavenOpts) {
            this.globalMavenOpts = globalMavenOpts;
            this.save();
        }

        public String getDisplayName() {
            return Messages.MavenModuleSet_DiplayName();
        }

        public MavenModuleSet newInstance(ItemGroup parent, String name) {
            return new MavenModuleSet(parent, name);
        }

        public Maven.DescriptorImpl getMavenDescriptor() {
            return (Maven.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Maven.DescriptorImpl.class);
        }

        public Map<String, Integer> getMavenValidationLevels() {
            return this.mavenValidationLevels;
        }

        public boolean configure(StaplerRequest req, JSONObject o) {
            this.globalMavenOpts = Util.fixEmptyAndTrim((String)o.getString("globalMavenOpts"));
            this.save();
            return true;
        }

        public boolean isApplicable(Descriptor descriptor) {
            return !NOT_APPLICABLE_TYPES.contains(descriptor.clazz);
        }
    }
}

