/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.maven.PluginName;
import hudson.util.InvocationInterceptor;
import hudson.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojoInfo {
    public final MojoExecution mojoExecution;
    public final PluginName pluginName;
    public final Mojo mojo;
    public final PlexusConfiguration configuration;
    public final ExpressionEvaluator expressionEvaluator;
    private final ConverterLookup converterLookup = new DefaultConverterLookup();

    public MojoInfo(MojoExecution mojoExecution, Mojo mojo, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) {
        if (mojo == null) {
            mojo = new Maven3ProvidesNoAccessToMojo();
        }
        this.mojo = mojo;
        this.mojoExecution = mojoExecution;
        this.configuration = configuration;
        this.expressionEvaluator = expressionEvaluator;
        this.pluginName = new PluginName(mojoExecution.getMojoDescriptor().getPluginDescriptor());
    }

    public MojoInfo(ExecutionEvent event) {
        this(event.getMojoExecution(), null, (PlexusConfiguration)new XmlPlexusConfiguration(event.getMojoExecution().getConfiguration()), (ExpressionEvaluator)new PluginParameterExpressionEvaluator(event.getSession(), event.getMojoExecution()));
    }

    public String getGoal() {
        return this.mojoExecution.getMojoDescriptor().getGoal();
    }

    public <T> T getConfigurationValue(String configName, Class<T> type) throws ComponentConfigurationException {
        Object cl;
        PlexusConfiguration child = this.configuration.getChild(configName);
        if (child == null) {
            return null;
        }
        PluginDescriptor pd = this.mojoExecution.getMojoDescriptor().getPluginDescriptor();
        Method method = ReflectionUtils.getPublicMethodNamed(pd.getClass(), (String)"getClassRealm");
        if (ReflectionUtils.invokeMethod((Method)method, (Object)pd) instanceof ClassRealm) {
            ClassRealm cr = (ClassRealm)ReflectionUtils.invokeMethod((Method)method, (Object)pd);
            cl = cr.getClassLoader();
        } else {
            cl = this.mojoExecution.getMojoDescriptor().getPluginDescriptor().getClassRealm();
        }
        ConfigurationConverter converter = this.converterLookup.lookupConverterForType(type);
        return type.cast(converter.fromConfiguration(this.converterLookup, child, type, Object.class, (ClassLoader)cl, this.expressionEvaluator));
    }

    public boolean is(String groupId, String artifactId, String mojoName) {
        return this.pluginName.matches(groupId, artifactId) && this.getGoal().equals(mojoName);
    }

    public <T> T inject(String name, T value) throws NoSuchFieldException {
        for (Class<?> c = this.mojo.getClass(); c != Object.class; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(name);
                f.setAccessible(true);
                Object oldValue = f.get(this.mojo);
                f.set(this.mojo, value);
                return (T)oldValue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                IllegalAccessError x = new IllegalAccessError(e.getMessage());
                x.initCause(e);
                throw x;
            }
        }
        throw new NoSuchFieldException(name);
    }

    public void intercept(String fieldName, final InvocationInterceptor interceptor) throws NoSuchFieldException {
        for (Class<?> c = this.mojo.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field f;
            try {
                f = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            f.setAccessible(true);
            Class<?> type = f.getType();
            if (!type.isInterface()) {
                throw new NoSuchFieldException(fieldName + " is of type " + type + " and it's not an interface");
            }
            try {
                final Object oldObject = f.get(this.mojo);
                Object newObject = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        return interceptor.invoke(proxy, method, args, new InvocationHandler(){

                            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                return method.invoke(oldObject, args);
                            }
                        });
                    }
                });
                f.set(this.mojo, newObject);
                continue;
            }
            catch (IllegalAccessException e) {
                IllegalAccessError x = new IllegalAccessError(e.getMessage());
                x.initCause(e);
                throw x;
            }
        }
    }

    public static class Maven3ProvidesNoAccessToMojo
    extends AbstractMojo {
        public void execute() throws MojoExecutionException, MojoFailureException {
            throw new UnsupportedOperationException();
        }
    }
}

