/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.Extension;
import hudson.Launcher;
import hudson.maven.MavenBuild;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.reporters.Messages;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.MailSender;
import hudson.tasks.Mailer;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class MavenMailer
extends MavenReporter {
    public String recipients;
    public boolean dontNotifyEveryUnstableBuild;
    public boolean sendToIndividuals;
    private static final long serialVersionUID = 1L;

    public boolean end(MavenBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        new MailSender(this.recipients, this.dontNotifyEveryUnstableBuild, this.sendToIndividuals).execute((AbstractBuild)build, listener);
        return true;
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return Messages.MavenMailer_DisplayName();
        }

        public String getHelpFile() {
            return "/help/project-config/mailer.html";
        }

        public String getConfigPage() {
            return this.getViewPage(Mailer.class, "config.jelly");
        }

        public MavenReporter newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            MavenMailer m = new MavenMailer();
            req.bindParameters((Object)m, "mailer_");
            m.dontNotifyEveryUnstableBuild = req.getParameter("mailer_notifyEveryUnstableBuild") == null;
            return m;
        }
    }
}

