/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.settings;

import hudson.ExtensionList;
import hudson.FilePath;
import hudson.maven.settings.GlobalMavenSettingsProvider;
import hudson.maven.settings.MavenSettingsProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsProviderUtils {
    public static Config findConfig(String settingsConfigId, Class<?> ... types) {
        ExtensionList configProviders = ConfigProvider.all();
        if (configProviders != null && configProviders.size() > 0) {
            for (ConfigProvider configProvider : configProviders) {
                for (Class<?> type : types) {
                    if (!type.isAssignableFrom(configProvider.getClass()) || !configProvider.isResponsibleFor(settingsConfigId)) continue;
                    return configProvider.getConfigById(settingsConfigId);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FilePath copyConfigContentToFilePath(Config config, FilePath workspace) throws IOException, InterruptedException {
        FilePath filePath;
        File tmpContentFile = null;
        ByteArrayInputStream bs = null;
        try {
            tmpContentFile = File.createTempFile("config", "tmp");
            FilePath filePath2 = new FilePath(workspace, tmpContentFile.getName());
            bs = new ByteArrayInputStream(config.content.getBytes());
            filePath2.copyFrom((InputStream)bs);
            filePath = filePath2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            FileUtils.deleteQuietly((File)tmpContentFile);
            IOUtils.closeQuietly(bs);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)tmpContentFile);
        IOUtils.closeQuietly((InputStream)bs);
        return filePath;
    }

    public static File copyConfigContentToFile(Config config) throws IOException {
        File tmpContentFile = File.createTempFile("config", "tmp");
        FileUtils.writeStringToFile((File)tmpContentFile, (String)config.content);
        return tmpContentFile;
    }

    public static boolean isGlobalMavenSettingsProvider(ConfigProvider configProvider) {
        if (configProvider instanceof GlobalMavenSettingsProvider) {
            return true;
        }
        return org.jenkinsci.lib.configprovider.maven.GlobalMavenSettingsProvider.class.isAssignableFrom(configProvider.getClass());
    }

    public static boolean isMavenSettingsProvider(ConfigProvider configProvider) {
        if (configProvider instanceof MavenSettingsProvider) {
            return true;
        }
        return org.jenkinsci.lib.configprovider.maven.MavenSettingsProvider.class.isAssignableFrom(configProvider.getClass());
    }
}

