/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.EnvVars;
import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.util.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenBuild<P extends AbstractMavenProject<P, B>, B extends AbstractMavenBuild<P, B>>
extends AbstractBuild<P, B> {
    public static boolean debug = false;
    private static final Logger LOGGER = Logger.getLogger(AbstractMavenBuild.class.getName());

    protected AbstractMavenBuild(P job) throws IOException {
        super(job);
    }

    public AbstractMavenBuild(P job, Calendar timestamp) {
        super(job, timestamp);
    }

    public AbstractMavenBuild(P project, File buildDir) throws IOException {
        super(project, buildDir);
    }

    public EnvVars getEnvironment(TaskListener log) throws IOException, InterruptedException {
        EnvVars envs = super.getEnvironment(log);
        String opts = this.getMavenOpts(log, envs);
        if (opts != null) {
            envs.put("MAVEN_OPTS", opts);
        }
        return envs;
    }

    public abstract String getMavenOpts(TaskListener var1, EnvVars var2);

    protected final String expandTokens(TaskListener listener, String str) {
        if (str == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("org.jenkinsci.plugins.tokenmacro.TokenMacro");
            Method expandMethod = ReflectionUtils.findMethod(clazz, (String)"expand", (Class[])new Class[]{AbstractBuild.class, TaskListener.class, String.class});
            return (String)expandMethod.invoke(null, new Object[]{this, listener, str});
        }
        catch (Exception tokenException) {
            LOGGER.log(Level.FINE, "Ignore problem in expanding tokens", tokenException);
        }
        catch (LinkageError linkageError) {
            LOGGER.log(Level.FINE, "Ignore problem in expanding tokens", linkageError);
        }
        return str;
    }
}

