/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Platform;
import hudson.Proc;
import hudson.Util;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenProcessFactory;
import hudson.maven.ProcessCache;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import hudson.remoting.Which;
import hudson.slaves.Channels;
import hudson.tasks.Maven;
import hudson.tasks._maven.MavenConsoleAnnotator;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.framework.io.IOException2;

public abstract class AbstractMavenProcessFactory {
    private final MavenModuleSet mms;
    private final Launcher launcher;
    private final EnvVars envVars;
    private final FilePath workDir;
    private final String mavenOpts;
    public static boolean mavenRemoteUseInet = Boolean.getBoolean("maven.remote.useinet");
    public static final String MAVEN_REMOTE_USEINET_ENV_VAR_NAME = "MAVEN_REMOTE_USEINET";
    public static boolean yjp = Boolean.getBoolean("hudson.maven.yjp");
    public static int debugPort;

    AbstractMavenProcessFactory(MavenModuleSet mms, Launcher launcher, EnvVars envVars, String mavenOpts, FilePath workDir) {
        this.mms = mms;
        this.launcher = launcher;
        this.envVars = envVars;
        this.workDir = workDir;
        this.mavenOpts = mavenOpts;
    }

    public ProcessCache.NewProcess newProcess(BuildListener listener, OutputStream out) throws IOException, InterruptedException {
        if (MavenProcessFactory.debug) {
            listener.getLogger().println("Using env variables: " + this.envVars);
        }
        try {
            Connection con;
            Charset charset;
            Acceptor acceptor = (Acceptor)this.launcher.getChannel().call((Callable)new SocketHandler());
            try {
                charset = Charset.forName((String)this.launcher.getChannel().call((Callable)new GetCharset()));
            }
            catch (UnsupportedCharsetException e) {
                charset = Charset.forName("iso-8859-1");
            }
            MavenConsoleAnnotator mca = new MavenConsoleAnnotator(out, charset);
            if (mavenRemoteUseInet) {
                this.envVars.put(MAVEN_REMOTE_USEINET_ENV_VAR_NAME, "true");
            }
            ArgumentListBuilder cmdLine = this.buildMavenAgentCmdLine(listener, acceptor.getPort());
            Object[] cmds = cmdLine.toCommandArray();
            Proc proc = this.launcher.launch().cmds((String[])cmds).envs((Map)this.envVars).stdout((OutputStream)mca).pwd(this.workDir).start();
            try {
                con = acceptor.accept();
            }
            catch (SocketTimeoutException e) {
                if (!proc.isAlive()) {
                    throw new AbortException("Failed to launch Maven. Exit code = " + proc.join());
                }
                throw e;
            }
            return new ProcessCache.NewProcess(Channels.forProcess((String)("Channel to Maven " + Arrays.toString(cmds)), (ExecutorService)Computer.threadPoolForRemoting, (InputStream)new BufferedInputStream(con.in), (OutputStream)new BufferedOutputStream(con.out), (OutputStream)listener.getLogger(), (Proc)proc), proc);
        }
        catch (IOException e) {
            JDK jdk;
            if (Util.fixNull((String)e.getMessage()).contains("java: not found") && (jdk = this.mms.getJDK()) == null) {
                throw new IOException2(this.mms.getDisplayName() + " is not configured with a JDK, but your PATH doesn't include Java", (Throwable)e);
            }
            throw e;
        }
    }

    protected ArgumentListBuilder buildMavenAgentCmdLine(BuildListener listener, int tcpPort) throws IOException, InterruptedException {
        Maven.MavenInstallation mvn = this.getMavenInstallation((TaskListener)listener);
        if (mvn == null) {
            listener.error("Maven version is not configured for this project. Can't determine which Maven to run");
            throw new Run.RunnerAbortedException();
        }
        if (mvn.getHome() == null) {
            listener.error("Maven '%s' doesn't have its home set", new Object[]{mvn.getName()});
            throw new Run.RunnerAbortedException();
        }
        boolean isMaster = this.getCurrentNode() == Jenkins.getInstance();
        FilePath slaveRoot = null;
        if (!isMaster) {
            slaveRoot = this.getCurrentNode().getRootPath();
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        JDK jdk = this.getJava((TaskListener)listener);
        if (jdk == null) {
            args.add("java");
        } else {
            args.add(jdk.getHome() + "/bin/java");
        }
        if (debugPort != 0) {
            args.add("-Xrunjdwp:transport=dt_socket,server=y,address=" + debugPort);
        }
        if (yjp) {
            args.add("-agentlib:yjpagent=tracing");
        }
        args.addTokenized(this.getMavenOpts());
        args.add("-cp");
        args.add(this.getMavenAgentClassPath(mvn, isMaster, slaveRoot, listener));
        args.add(this.getMainClassName());
        args.add(mvn.getHome());
        String remotingJar = (String)this.getLauncher().getChannel().call((Callable)new GetRemotingJar());
        if (remotingJar == null) {
            listener.error("Failed to determine the location of slave.jar");
            throw new Run.RunnerAbortedException();
        }
        args.add(remotingJar);
        args.add(this.getMavenInterceptorClassPath(mvn, isMaster, slaveRoot));
        args.add((Object)tcpPort);
        String interceptorOverride = this.getMavenInterceptorOverride(mvn, isMaster, slaveRoot);
        if (interceptorOverride != null) {
            args.add(interceptorOverride);
        }
        return args;
    }

    protected abstract String getMavenAgentClassPath(Maven.MavenInstallation var1, boolean var2, FilePath var3, BuildListener var4) throws IOException, InterruptedException;

    protected abstract String getMavenInterceptorClassPath(Maven.MavenInstallation var1, boolean var2, FilePath var3) throws IOException, InterruptedException;

    protected abstract String getMavenInterceptorOverride(Maven.MavenInstallation var1, boolean var2, FilePath var3) throws IOException, InterruptedException;

    protected abstract String getMainClassName();

    public String getMavenOpts() {
        Node n;
        if (this.mavenOpts != null) {
            return this.addRunHeadLessOption(this.mavenOpts);
        }
        String mavenOpts = this.mms.getMavenOpts();
        if ((mavenOpts == null || mavenOpts.trim().length() == 0) && (n = this.getCurrentNode()) != null) {
            try {
                String localMavenOpts = (String)n.toComputer().getEnvironment().get((Object)"MAVEN_OPTS");
                if (localMavenOpts != null && localMavenOpts.trim().length() > 0) {
                    mavenOpts = localMavenOpts;
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        mavenOpts = this.addRunHeadLessOption(mavenOpts);
        return this.envVars.expand(mavenOpts);
    }

    protected String addRunHeadLessOption(String mavenOpts) {
        if (this.mms.runHeadless()) {
            mavenOpts = mavenOpts == null ? "-Djava.awt.headless=true" : mavenOpts + " -Djava.awt.headless=true";
        } else if (Platform.isDarwin()) {
            // empty if block
        }
        return mavenOpts;
    }

    public Maven.MavenInstallation getMavenInstallation(TaskListener log) throws IOException, InterruptedException {
        Maven.MavenInstallation mi = this.mms.getMaven();
        if (mi != null) {
            mi = mi.forNode(this.getCurrentNode(), log).forEnvironment(this.envVars);
        }
        return mi;
    }

    public JDK getJava(TaskListener log) throws IOException, InterruptedException {
        JDK jdk = this.mms.getJDK();
        if (jdk != null) {
            jdk = jdk.forNode(this.getCurrentNode(), log).forEnvironment(this.envVars);
        }
        return jdk;
    }

    protected Node getCurrentNode() {
        return Executor.currentExecutor().getOwner().getNode();
    }

    protected MavenModuleSet getMavenModuleSet() {
        return this.mms;
    }

    protected Launcher getLauncher() {
        return this.launcher;
    }

    protected EnvVars getEnvVars() {
        return this.envVars;
    }

    static {
        String port = System.getProperty("hudson.maven.debugPort");
        if (port != null) {
            debugPort = Integer.parseInt(port);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class GetRemotingJar
    implements Callable<String, IOException> {
        private static final long serialVersionUID = 6022357183425911351L;

        protected GetRemotingJar() {
        }

        public String call() throws IOException {
            return Which.jarFile(hudson.remoting.Launcher.class).getPath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetCharset
    implements Callable<String, IOException> {
        private static final long serialVersionUID = 3459269768733083577L;

        private GetCharset() {
        }

        public String call() throws IOException {
            return System.getProperty("file.encoding");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SocketHandler
    implements Callable<Acceptor, IOException> {
        private static final long serialVersionUID = 1L;

        private SocketHandler() {
        }

        public Acceptor call() throws IOException {
            return new AcceptorImpl();
        }

        static final class AcceptorImpl
        implements Acceptor,
        Serializable {
            private static final long serialVersionUID = -2226788819948521018L;
            private final transient ServerSocket serverSocket = new ServerSocket();
            private transient Socket socket;

            AcceptorImpl() throws IOException {
                this.serverSocket.bind(null);
                this.serverSocket.setSoTimeout(MavenProcessFactory.socketTimeOut);
            }

            public Connection accept() throws IOException {
                this.socket = this.serverSocket.accept();
                this.serverSocket.close();
                return new Connection((InputStream)new SocketInputStream(this.socket), (OutputStream)new SocketOutputStream(this.socket));
            }

            public int getPort() {
                return this.serverSocket.getLocalPort();
            }

            private Object writeReplace() {
                return Channel.current().export(Acceptor.class, (Object)this);
            }
        }
    }

    static interface Acceptor {
        public Connection accept() throws IOException;

        public int getPort();
    }

    private static final class Connection
    implements Serializable {
        public InputStream in;
        public OutputStream out;
        private static final long serialVersionUID = 1L;

        Connection(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        private Object writeReplace() {
            return new Connection((InputStream)new RemoteInputStream(this.in), (OutputStream)new RemoteOutputStream(this.out));
        }

        private Object readResolve() {
            this.in = new BufferedInputStream(this.in);
            this.out = new BufferedOutputStream(this.out);
            return this;
        }
    }
}

