/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.model.TaskListener;
import java.io.PrintStream;
import java.util.StringTokenizer;
import org.apache.maven.cli.MavenLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public final class EmbedderLoggerImpl
extends MavenLoggerManager {
    private final PrintStream logger;

    public EmbedderLoggerImpl(TaskListener listener, int threshold) {
        super((Logger)new ConsoleLogger(threshold, "hudson-logger"));
        this.logger = listener.getLogger();
    }

    private void print(String message, Throwable throwable, int threshold, String prefix) {
        if (this.getThreshold() <= threshold) {
            StringTokenizer tokens = new StringTokenizer(message, "\n");
            while (tokens.hasMoreTokens()) {
                this.logger.print(prefix);
                this.logger.println(tokens.nextToken());
            }
            if (throwable != null) {
                throwable.printStackTrace(this.logger);
            }
        }
    }

    public void debug(String message, Throwable throwable) {
        this.print(message, throwable, 0, "[DEBUG] ");
    }

    public void info(String message, Throwable throwable) {
        this.print(message, throwable, 1, "[INFO ] ");
    }

    public void warn(String message, Throwable throwable) {
        this.print(message, throwable, 2, "[WARN ] ");
    }

    public void error(String message, Throwable throwable) {
        this.print(message, throwable, 3, "[ERROR] ");
    }

    public void fatalError(String message, Throwable throwable) {
        this.print(message, throwable, 4, "[FATAL] ");
    }
}

