/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.AggregatableAction;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenEmbedderRequest;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenReporter;
import hudson.maven.MavenUtil;
import hudson.maven.Messages;
import hudson.maven.ModuleName;
import hudson.maven.NeedsFullBuildAction;
import hudson.maven.PomInfo;
import hudson.maven.ReactorReader;
import hudson.maven.UnbuiltModuleAction;
import hudson.maven.reporters.MavenAggregatedArtifactRecord;
import hudson.maven.reporters.MavenFingerprinter;
import hudson.maven.reporters.MavenMailer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Fingerprint;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStep;
import hudson.tasks.Builder;
import hudson.tasks.MailSender;
import hudson.tasks.Maven;
import hudson.util.IOUtils;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.SettingsProvider;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.util.PathTool;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenModuleSetBuild
extends AbstractMavenBuild<MavenModuleSet, MavenModuleSetBuild> {
    List<MavenReporter> projectActionReporters;
    private String mavenVersionUsed;
    private transient Object notifyModuleBuildLock = new Object();
    private static final Logger LOGGER = Logger.getLogger(MavenModuleSetBuild.class.getName());
    public static boolean debug = Boolean.getBoolean("hudson.maven.debug");

    public MavenModuleSetBuild(MavenModuleSet job) throws IOException {
        super(job);
    }

    public MavenModuleSetBuild(MavenModuleSet project, File buildDir) throws IOException {
        super(project, buildDir);
    }

    protected void onLoad() {
        super.onLoad();
        this.notifyModuleBuildLock = new Object();
    }

    @Override
    public EnvVars getEnvironment(TaskListener log) throws IOException, InterruptedException {
        Node node;
        EnvVars envs = super.getEnvironment(log);
        Maven.MavenInstallation mvn = ((MavenModuleSet)this.project).getMaven();
        if (mvn == null) {
            throw new AbortException(Messages.MavenModuleSetBuild_NoMavenConfigured());
        }
        mvn = mvn.forEnvironment(envs);
        Computer computer = Computer.currentComputer();
        if (computer != null && (node = computer.getNode()) != null) {
            mvn = mvn.forNode(node, log);
            mvn.buildEnvVars(envs);
        }
        return envs;
    }

    public Result getResult() {
        Result r = super.getResult();
        for (MavenBuild b : this.getModuleLastBuilds().values()) {
            Result br = b.getResult();
            if (r == null) {
                r = br;
                continue;
            }
            if (br == Result.NOT_BUILT || br == null) continue;
            r = r.combine(br);
        }
        return r;
    }

    List<ChangeLogSet.Entry> getChangeSetFor(final MavenModule mod) {
        return new ArrayList<ChangeLogSet.Entry>(){
            private static final long serialVersionUID = 5572368347535713298L;
            {
                List<MavenModule> subsidiaries = null;
                for (ChangeLogSet.Entry e : MavenModuleSetBuild.this.getChangeSet()) {
                    if (!this.isDescendantOf(e, mod)) continue;
                    if (subsidiaries == null) {
                        subsidiaries = mod.getSubsidiaries();
                    }
                    if (!this.notInSubsidiary(subsidiaries, e)) continue;
                    this.add(e);
                }
            }

            private boolean notInSubsidiary(List<MavenModule> subsidiaries, ChangeLogSet.Entry e) {
                for (String path : e.getAffectedPaths()) {
                    if (this.belongsToSubsidiary(subsidiaries, path)) continue;
                    return true;
                }
                return false;
            }

            private boolean belongsToSubsidiary(List<MavenModule> subsidiaries, String path) {
                for (MavenModule sub : subsidiaries) {
                    if (!FilenameUtils.separatorsToUnix((String)path).startsWith(MavenModuleSetBuild.normalizePath(sub.getRelativePath()))) continue;
                    return true;
                }
                return false;
            }

            private boolean isDescendantOf(ChangeLogSet.Entry e, MavenModule mod2) {
                for (String path : e.getAffectedPaths()) {
                    if (!FilenameUtils.separatorsToUnix((String)path).startsWith(MavenModuleSetBuild.normalizePath(mod2.getRelativePath()))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Map<MavenModule, List<MavenBuild>> getModuleBuilds() {
        Collection<MavenModule> mods = this.getParent().getModules();
        MavenModuleSetBuild nb = (MavenModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() : Integer.MAX_VALUE;
        LinkedHashMap<MavenModule, List<MavenBuild>> r = new LinkedHashMap<MavenModule, List<MavenBuild>>(mods.size());
        for (MavenModule m : mods) {
            ArrayList<MavenBuild> builds = new ArrayList<MavenBuild>();
            for (MavenBuild b = (MavenBuild)m.getNearestBuild(this.number); b != null && b.getNumber() < end; b = (MavenBuild)b.getNextBuild()) {
                builds.add(b);
            }
            r.put(m, builds);
        }
        return r;
    }

    public long getEstimatedDuration() {
        if (!((MavenModuleSet)this.project).isIncrementalBuild()) {
            return super.getEstimatedDuration();
        }
        long result = 0L;
        Map<MavenModule, List<MavenBuild>> moduleBuilds = this.getModuleBuilds();
        boolean noModuleBuildsYet = true;
        for (List<MavenBuild> builds : moduleBuilds.values()) {
            if (builds.isEmpty()) continue;
            noModuleBuildsYet = false;
            MavenBuild build = builds.get(0);
            if (build.getResult() == Result.NOT_BUILT || build.getEstimatedDuration() == -1L) continue;
            result += build.getEstimatedDuration();
        }
        if (noModuleBuildsYet) {
            return super.getEstimatedDuration();
        }
        return (result += this.estimateModuleSetBuildDurationOverhead(3)) != 0L ? result : -1L;
    }

    private long estimateModuleSetBuildDurationOverhead(int numberOfBuilds) {
        List moduleSetBuilds = this.getPreviousBuildsOverThreshold(numberOfBuilds, Result.UNSTABLE);
        if (moduleSetBuilds.isEmpty()) {
            return 0L;
        }
        long overhead = 0L;
        for (MavenModuleSetBuild moduleSetBuild : moduleSetBuilds) {
            long sumOfModuleBuilds = 0L;
            for (List<MavenBuild> builds : moduleSetBuild.getModuleBuilds().values()) {
                if (builds.isEmpty()) continue;
                MavenBuild moduleBuild = builds.get(0);
                sumOfModuleBuilds += moduleBuild.getDuration();
            }
            overhead += Math.max(0L, moduleSetBuild.getDuration() - sumOfModuleBuilds);
        }
        return Math.round((double)overhead / (double)moduleSetBuilds.size());
    }

    private static String normalizePath(String relPath) {
        if (StringUtils.isEmpty((String)(relPath = StringUtils.trimToEmpty((String)relPath)))) {
            LOGGER.config("No need to normalize an empty path.");
        } else if (FilenameUtils.indexOfLastSeparator((String)relPath) == -1) {
            LOGGER.config("No need to normalize " + relPath);
        } else {
            String tmp = FilenameUtils.normalize((String)relPath);
            if (tmp == null) {
                LOGGER.config("Path " + relPath + " can not be normalized (parent dir is unknown). Keeping as is.");
            } else {
                LOGGER.config("Normalized path " + relPath + " to " + tmp);
                relPath = tmp;
            }
            relPath = FilenameUtils.separatorsToUnix((String)relPath);
        }
        LOGGER.fine("Returning path " + relPath);
        return relPath;
    }

    @Exported
    public String getMavenVersionUsed() {
        return this.mavenVersionUsed;
    }

    public void setMavenVersionUsed(String mavenVersionUsed) throws IOException {
        this.mavenVersionUsed = Util.intern((String)mavenVersionUsed);
        this.save();
    }

    public synchronized void delete() throws IOException {
        super.delete();
        for (List<MavenBuild> list : this.getModuleBuilds().values()) {
            for (MavenBuild build : list) {
                build.delete();
            }
        }
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        MavenModule m;
        if (token.indexOf(36) > 0 && (m = ((MavenModuleSet)this.getProject()).getModule(token)) != null) {
            return m.getBuildByNumber(this.getNumber());
        }
        return super.getDynamic(token, req, rsp);
    }

    @Exported
    public MavenAggregatedArtifactRecord getMavenArtifacts() {
        return (MavenAggregatedArtifactRecord)this.getAction(MavenAggregatedArtifactRecord.class);
    }

    public Map<MavenModule, MavenBuild> getModuleLastBuilds() {
        Collection<MavenModule> mods = this.getParent().getModules();
        MavenModuleSetBuild nb = (MavenModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() : Integer.MAX_VALUE;
        LinkedHashMap<MavenModule, MavenBuild> r = new LinkedHashMap<MavenModule, MavenBuild>(mods.size());
        for (MavenModule m : mods) {
            MavenBuild b = (MavenBuild)m.getNearestOldBuild(end - 1);
            if (b == null || b.getNumber() < this.getNumber()) continue;
            r.put(m, b);
        }
        return r;
    }

    public void registerAsProjectAction(MavenReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenReporter>();
        }
        this.projectActionReporters.add(reporter);
    }

    public <T extends Action> List<T> findModuleBuildActions(Class<T> action) {
        Collection<MavenModule> mods = this.getParent().getModules();
        ArrayList<Action> r = new ArrayList<Action>(mods.size());
        MavenModuleSetBuild nb = (MavenModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() - 1 : Integer.MAX_VALUE;
        block0: for (MavenModule m : mods) {
            for (MavenBuild b = (MavenBuild)m.getNearestOldBuild(end); b != null && b.getNumber() >= this.number; b = (MavenBuild)b.getPreviousBuild()) {
                Action a = b.getAction(action);
                if (a == null) continue;
                r.add(a);
                continue block0;
            }
        }
        return r;
    }

    public void run() {
        this.execute((Run.RunExecution)new MavenModuleSetBuildExecution());
        ((MavenModuleSet)this.getProject()).updateTransientActions();
    }

    public Fingerprint.RangeSet getDownstreamRelationship(AbstractProject that) {
        Fingerprint.RangeSet rs = super.getDownstreamRelationship(that);
        for (List<MavenBuild> builds : this.getModuleBuilds().values()) {
            for (MavenBuild b : builds) {
                rs.add(b.getDownstreamRelationship(that));
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyModuleBuild(MavenBuild newBuild) {
        try {
            this.getParent().updateNextBuildNumber();
            Map<MavenModule, List<MavenBuild>> moduleBuilds = this.getModuleBuilds();
            Object object = this.notifyModuleBuildLock;
            synchronized (object) {
                MavenAggregatedReport mar;
                boolean modified = false;
                List actions = this.getActions();
                HashSet individuals = new HashSet();
                for (Action a : actions) {
                    if (!(a instanceof MavenAggregatedReport)) continue;
                    mar = (MavenAggregatedReport)a;
                    mar.update(moduleBuilds, newBuild);
                    individuals.add(mar.getIndividualActionType());
                    modified = true;
                }
                for (AggregatableAction aa : newBuild.getActions(AggregatableAction.class)) {
                    if (!individuals.add(aa.getClass())) continue;
                    mar = aa.createAggregatedAction(this, moduleBuilds);
                    mar.update(moduleBuilds, newBuild);
                    this.addAction(mar);
                    modified = true;
                }
                if (modified) {
                    this.save();
                    ((MavenModuleSet)this.getProject()).updateTransientActions();
                }
            }
            String moduleFsName = ((MavenModule)newBuild.getProject()).getModuleName().toFileSystemName();
            Util.createSymlink((File)this.getRootDir(), (String)("../../modules/" + moduleFsName + "/builds/" + newBuild.getId()), (String)moduleFsName, (TaskListener)StreamTaskListener.NULL);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + (Object)((Object)this), e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + (Object)((Object)this), e);
        }
    }

    @Override
    public String getMavenOpts(TaskListener listener, EnvVars envVars) {
        return envVars.expand(this.expandTokens(listener, ((MavenModuleSet)this.project).getMavenOpts()));
    }

    public MavenModuleSet getParent() {
        return (MavenModuleSet)super.getParent();
    }

    static /* synthetic */ Job access$200(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$400(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$500(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$600(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$700(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ List access$800(MavenModuleSetBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ Job access$900(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1000(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1100(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1200(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1300(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1400(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1500(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1600(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1700(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1800(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1900(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2000(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2100(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2200(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2300(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2400(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2500(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2600(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2700(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2800(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ List access$2900(MavenModuleSetBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ List access$3000(MavenModuleSetBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ Job access$3100(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$3200(MavenModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$3300(MavenModuleSetBuild x0) {
        return x0.project;
    }

    public static class SimpleTransferListener
    implements TransferListener {
        private TaskListener taskListener;

        public SimpleTransferListener(TaskListener taskListener) {
            this.taskListener = taskListener;
        }

        public void transferCorrupted(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferFailed(TransferEvent transferEvent) {
            this.taskListener.getLogger().println(Messages.MavenModuleSetBuild_FailedToTransfer(transferEvent.getException().getMessage()));
        }

        public void transferInitiated(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferProgressed(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferStarted(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferSucceeded(TransferEvent transferEvent) {
            this.taskListener.getLogger().println(Messages.MavenModuleSetBuild_DownloadedArtifact(transferEvent.getResource().getRepositoryUrl(), transferEvent.getResource().getResourceName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PomParser
    implements FilePath.FileCallable<List<PomInfo>> {
        private final BuildListener listener;
        private final String rootPOM;
        private final boolean verbose = debug;
        private final Maven.MavenInstallation mavenHome;
        private final String profiles;
        private final Properties properties;
        private final String privateRepository;
        private final String alternateSettings;
        private final String globalSettings;
        private final boolean nonRecursive;
        private final String workspaceProper;
        private final String mavenVersion;
        private final String moduleRootPath;
        private boolean resolveDependencies = false;
        private boolean processPlugins = false;
        private int mavenValidationLevel = -1;
        private boolean updateSnapshots = false;
        String rootPOMRelPrefix;
        private static final long serialVersionUID = 1L;

        public PomParser(BuildListener listener, Maven.MavenInstallation mavenHome, String mavenVersion, EnvVars envVars, MavenModuleSetBuild build) {
            MavenModuleSet project = (MavenModuleSet)build.getProject();
            this.listener = listener;
            this.mavenHome = mavenHome;
            this.rootPOM = project.getRootPOM(envVars);
            this.profiles = project.getProfiles();
            this.properties = project.getMavenProperties();
            this.updateSnapshots = this.isUpdateSnapshots(project.getGoals());
            ParametersDefinitionProperty parametersDefinitionProperty = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
            if (parametersDefinitionProperty != null && parametersDefinitionProperty.getParameterDefinitions() != null) {
                for (ParameterDefinition parameterDefinition : parametersDefinitionProperty.getParameterDefinitions()) {
                    if (!(parameterDefinition instanceof StringParameterDefinition)) continue;
                    this.properties.put("env." + parameterDefinition.getName(), ((StringParameterDefinition)parameterDefinition).getDefaultValue());
                }
            }
            if (envVars != null && !envVars.isEmpty()) {
                for (Map.Entry entry : envVars.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    this.properties.put("env." + (String)entry.getKey(), entry.getValue());
                }
            }
            this.nonRecursive = project.isNonRecursive();
            this.workspaceProper = build.getWorkspace().getRemote();
            LOGGER.fine("Workspace is " + this.workspaceProper);
            FilePath localRepo = project.getLocalRepository().locate(build);
            this.privateRepository = localRepo != null ? localRepo.getRemote() : null;
            this.alternateSettings = SettingsProvider.getSettingsRemotePath((SettingsProvider)project.getSettings(), (AbstractBuild)build, (TaskListener)listener);
            this.globalSettings = GlobalSettingsProvider.getSettingsRemotePath((GlobalSettingsProvider)project.getGlobalSettings(), (AbstractBuild)build, (TaskListener)listener);
            this.mavenVersion = mavenVersion;
            this.resolveDependencies = project.isResolveDependencies();
            this.processPlugins = project.isProcessPlugins();
            this.moduleRootPath = project.getScm().getModuleRoot(build.getWorkspace(), project.getLastBuild()).getRemote();
            this.mavenValidationLevel = project.getMavenValidationLevel();
        }

        private boolean isUpdateSnapshots(String goals) {
            return StringUtils.contains((String)goals, (String)"-U") || StringUtils.contains((String)goals, (String)"--update-snapshots");
        }

        public List<PomInfo> invoke(File ws, VirtualChannel channel) throws IOException {
            File settingsLoc;
            File wsp;
            File pom;
            PrintStream logger = this.listener.getLogger();
            if (IOUtils.isAbsolute((String)this.rootPOM)) {
                pom = new File(this.rootPOM);
            } else {
                pom = new File(ws, this.rootPOM);
                File parentLoc = new File(ws.getParentFile(), this.rootPOM);
                if (!pom.exists() && parentLoc.exists()) {
                    pom = parentLoc;
                }
            }
            if (!pom.exists()) {
                throw new AbortException(Messages.MavenModuleSetBuild_NoSuchPOMFile(pom));
            }
            this.rootPOMRelPrefix = this.rootPOM.startsWith("../") || this.rootPOM.startsWith("..\\") ? (!ws.equals(wsp = new File(this.workspaceProper)) ? ws.getCanonicalPath().substring(wsp.getCanonicalPath().length() + 1) + "/" : wsp.getName() + "/") : "";
            if (this.verbose) {
                logger.println("Parsing " + (this.nonRecursive ? "non-recursively " : "recursively ") + pom);
            }
            if (this.alternateSettings == null) {
                settingsLoc = null;
            } else if (IOUtils.isAbsolute((String)this.alternateSettings)) {
                settingsLoc = new File(this.alternateSettings);
            } else {
                settingsLoc = new File(this.workspaceProper, this.alternateSettings);
                File mrSettingsLoc = new File(this.workspaceProper, this.alternateSettings);
                if (!settingsLoc.exists() && mrSettingsLoc.exists()) {
                    settingsLoc = mrSettingsLoc;
                }
            }
            if (debug) {
                logger.println(Messages.MavenModuleSetBuild_SettinsgXmlAndPrivateRepository(settingsLoc, this.privateRepository));
            }
            if (settingsLoc != null && !settingsLoc.exists()) {
                throw new AbortException(Messages.MavenModuleSetBuild_NoSuchAlternateSettings(settingsLoc.getAbsolutePath()));
            }
            try {
                MavenEmbedderRequest mavenEmbedderRequest = new MavenEmbedderRequest((TaskListener)this.listener, this.mavenHome.getHomeDir(), this.profiles, this.properties, this.privateRepository, settingsLoc);
                mavenEmbedderRequest.setTransferListener(new SimpleTransferListener((TaskListener)this.listener));
                mavenEmbedderRequest.setUpdateSnapshots(this.updateSnapshots);
                mavenEmbedderRequest.setProcessPlugins(this.processPlugins);
                mavenEmbedderRequest.setResolveDependencies(this.resolveDependencies);
                if (this.globalSettings != null) {
                    mavenEmbedderRequest.setGlobalSettings(new File(this.globalSettings));
                }
                ReactorReader reactorReader = null;
                boolean maven3OrLater = MavenUtil.maven3orLater(this.mavenVersion);
                if (maven3OrLater) {
                    mavenEmbedderRequest.setValidationLevel(30);
                } else {
                    reactorReader = new ReactorReader(new HashMap(), new File(this.workspaceProper));
                    mavenEmbedderRequest.setWorkspaceReader((WorkspaceReader)reactorReader);
                }
                if (this.mavenValidationLevel >= 0) {
                    mavenEmbedderRequest.setValidationLevel(this.mavenValidationLevel);
                }
                MavenEmbedder embedder = MavenUtil.createEmbedder(mavenEmbedderRequest);
                MavenProject rootProject = null;
                List<MavenProject> mps = new ArrayList<MavenProject>(0);
                if (maven3OrLater) {
                    mps = embedder.readProjects(pom, !this.nonRecursive);
                } else {
                    MavenProject mavenProject;
                    rootProject = mavenProject = embedder.readProject(pom);
                    mps.add(mavenProject);
                    reactorReader.addProject(mavenProject);
                    if (!this.nonRecursive) {
                        this.readChilds(mavenProject, embedder, mps, reactorReader);
                    }
                }
                HashMap<String, MavenProject> canonicalPaths = new HashMap<String, MavenProject>(mps.size());
                for (MavenProject mavenProject : mps) {
                    canonicalPaths.put(mavenProject.getFile().getCanonicalPath(), mavenProject);
                }
                if (this.verbose) {
                    for (Map.Entry entry : canonicalPaths.entrySet()) {
                        logger.printf("Discovered %s at %s\n", ((MavenProject)entry.getValue()).getId(), entry.getKey());
                    }
                }
                LinkedHashSet<PomInfo> infos = new LinkedHashSet<PomInfo>();
                if (maven3OrLater) {
                    for (MavenProject mp : mps) {
                        if (!mp.isExecutionRoot()) continue;
                        rootProject = mp;
                    }
                }
                if (rootProject == null) {
                    rootProject = mps.get(0);
                }
                this.toPomInfo(rootProject, null, canonicalPaths, infos);
                for (PomInfo pi : infos) {
                    pi.cutCycle();
                }
                return new ArrayList<PomInfo>(infos);
            }
            catch (MavenEmbedderException e) {
                throw new MavenExecutionException((Exception)((Object)e));
            }
            catch (ProjectBuildingException e) {
                throw new MavenExecutionException((Exception)((Object)e));
            }
        }

        private void toPomInfo(MavenProject mp, PomInfo parent, Map<String, MavenProject> abslPath, Set<PomInfo> infos) throws IOException {
            String relPath = PathTool.getRelativeFilePath((String)this.moduleRootPath, (String)mp.getBasedir().getPath());
            relPath = MavenModuleSetBuild.normalizePath(relPath);
            if (parent == null) {
                relPath = this.getRootPath(this.rootPOMRelPrefix);
            }
            relPath = StringUtils.removeStart((String)relPath, (String)"/");
            PomInfo pi = new PomInfo(mp, parent, relPath);
            infos.add(pi);
            if (!this.nonRecursive) {
                for (String modulePath : mp.getModules()) {
                    MavenProject child;
                    if (StringUtils.isBlank((String)modulePath)) continue;
                    File path = new File(mp.getBasedir(), modulePath);
                    if (path.isDirectory()) {
                        path = new File(mp.getBasedir(), modulePath + "/pom.xml");
                    }
                    if ((child = abslPath.get(path.getCanonicalPath())) == null) {
                        this.listener.getLogger().printf(Messages.MavenModuleSetBuild_FoundModuleWithoutProject(modulePath), new Object[0]);
                        continue;
                    }
                    this.toPomInfo(child, pi, abslPath, infos);
                }
            }
        }

        private void readChilds(MavenProject mp, MavenEmbedder mavenEmbedder, List<MavenProject> mavenProjects, ReactorReader reactorReader) throws ProjectBuildingException, MavenEmbedderException {
            if (mp.getModules() == null || mp.getModules().isEmpty()) {
                return;
            }
            for (String module : mp.getModules()) {
                if (Util.fixEmptyAndTrim((String)module) == null) continue;
                File pomFile = new File(mp.getFile().getParent(), module);
                MavenProject mavenProject2 = null;
                mavenProject2 = pomFile.isFile() ? mavenEmbedder.readProject(pomFile) : mavenEmbedder.readProject(new File(mp.getFile().getParent(), module + "/pom.xml"));
                mavenProjects.add(mavenProject2);
                reactorReader.addProject(mavenProject2);
                this.readChilds(mavenProject2, mavenEmbedder, mavenProjects, reactorReader);
            }
        }

        private String getRootPath(String prefix) {
            int idx = Math.max(this.rootPOM.lastIndexOf(47), this.rootPOM.lastIndexOf(92));
            if (idx == -1) {
                return "";
            }
            return prefix + this.rootPOM.substring(0, idx);
        }
    }

    private static final class MavenExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private MavenExecutionException(Exception cause) {
            super(cause);
        }

        public Exception getCause() {
            return (Exception)super.getCause();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MavenModuleSetBuildExecution
    extends AbstractBuild.AbstractBuildExecution {
        private Map<ModuleName, MavenBuild.ProxyImpl2> proxies;

        private MavenModuleSetBuildExecution() {
            super((AbstractBuild)MavenModuleSetBuild.this);
        }

        /*
         * Exception decompiling
         */
        protected Result doRun(BuildListener listener) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean build(BuildListener listener, Collection<Builder> steps) throws IOException, InterruptedException {
            for (Builder bs : steps) {
                if (this.perform((BuildStep)bs, listener)) continue;
                LOGGER.fine(MessageFormat.format("{1} failed", bs));
                return false;
            }
            return true;
        }

        private Collection<ModuleName> getUnbuildModulesSinceLastSuccessfulBuild() {
            ArrayList<ModuleName> unbuiltModules = new ArrayList<ModuleName>();
            MavenModuleSetBuild previousSuccessfulBuild = (MavenModuleSetBuild)MavenModuleSetBuild.this.getPreviousSuccessfulBuild();
            if (previousSuccessfulBuild == null) {
                previousSuccessfulBuild = (MavenModuleSetBuild)MavenModuleSetBuild.this.getParent().getFirstBuild();
            }
            if (previousSuccessfulBuild != null) {
                MavenModuleSetBuild previousBuild = previousSuccessfulBuild;
                do {
                    UnbuiltModuleAction unbuiltModuleAction;
                    if ((unbuiltModuleAction = (UnbuiltModuleAction)previousBuild.getAction(UnbuiltModuleAction.class)) == null) continue;
                    for (ModuleName name : unbuiltModuleAction.getUnbuildModules()) {
                        unbuiltModules.add(name);
                    }
                } while ((previousBuild = (MavenModuleSetBuild)previousBuild.getNextBuild()) != null && previousBuild != MavenModuleSetBuild.this);
            }
            return unbuiltModules;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parsePoms(BuildListener listener, PrintStream logger, EnvVars envVars, Maven.MavenInstallation mvn, String mavenVersion) throws IOException, InterruptedException {
            Map<ModuleName, MavenModule> modules;
            List poms;
            logger.println("Parsing POMs");
            try {
                poms = (List)MavenModuleSetBuild.this.getModuleRoot().act((FilePath.FileCallable)new PomParser(listener, mvn, mavenVersion, envVars, MavenModuleSetBuild.this));
            }
            catch (IOException e) {
                if (((MavenModuleSet)MavenModuleSetBuild.this.project).isIncrementalBuild()) {
                    MavenModuleSetBuild.this.getActions().add(new NeedsFullBuildAction());
                }
                if (e.getCause() instanceof AbortException) {
                    throw (AbortException)e.getCause();
                }
                throw e;
            }
            catch (MavenExecutionException e) {
                e.getCause().printStackTrace(listener.error(Messages.MavenModuleSetBuild_FailedToParsePom()));
                if (((MavenModuleSet)MavenModuleSetBuild.this.project).isIncrementalBuild()) {
                    MavenModuleSetBuild.this.getActions().add(new NeedsFullBuildAction());
                }
                throw new AbortException();
            }
            boolean needsDependencyGraphRecalculation = false;
            Map<ModuleName, MavenModule> map = modules = ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).modules;
            synchronized (map) {
                HashMap<ModuleName, MavenModule> old = new HashMap<ModuleName, MavenModule>(modules);
                ArrayList<MavenModule> sortedModules = new ArrayList<MavenModule>();
                modules.clear();
                if (debug) {
                    logger.println("Root POM is " + ((PomInfo)poms.get((int)0)).name);
                }
                ((MavenModuleSet)MavenModuleSetBuild.this.project).reconfigure((PomInfo)poms.get(0));
                for (PomInfo pom : poms) {
                    MavenModule mm = (MavenModule)((Object)old.get(pom.name));
                    if (mm != null) {
                        if (debug) {
                            logger.println("Reconfiguring " + (Object)((Object)mm));
                        }
                        if (!mm.isSameModule(pom)) {
                            needsDependencyGraphRecalculation = true;
                        }
                        mm.reconfigure(pom);
                        modules.put(pom.name, mm);
                    } else {
                        logger.println(Messages.MavenModuleSetBuild_DiscoveredModule(pom.name, pom.displayName));
                        mm = new MavenModule((MavenModuleSet)MavenModuleSetBuild.this.project, pom, MavenModuleSetBuild.this.getNumber());
                        mm.onCreatedFromScratch();
                        modules.put(mm.getModuleName(), mm);
                        needsDependencyGraphRecalculation = true;
                    }
                    sortedModules.add(mm);
                    mm.save();
                }
                ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).sortedActiveModules = sortedModules;
                old.keySet().removeAll(modules.keySet());
                for (MavenModule om : old.values()) {
                    if (debug) {
                        logger.println("Disabling " + (Object)((Object)om));
                    }
                    om.makeDisabled(true);
                    needsDependencyGraphRecalculation = true;
                }
                modules.putAll(old);
            }
            if (needsDependencyGraphRecalculation) {
                logger.println("Modules changed, recalculating dependency graph");
                Jenkins.getInstance().rebuildDependencyGraph();
            }
            for (MavenModule m : modules.values()) {
                m.updateNextBuildNumber(MavenModuleSetBuild.this.getNumber());
            }
        }

        protected void post2(BuildListener listener) throws Exception {
            for (MavenBuild b : MavenModuleSetBuild.this.getModuleLastBuilds().values()) {
                b.save();
            }
            if (!this.performAllBuildSteps(listener, (Iterable)((MavenModuleSet)MavenModuleSetBuild.this.project).getPublishers(), true)) {
                MavenModuleSetBuild.this.setResult(Result.FAILURE);
            }
            if (!this.performAllBuildSteps(listener, ((MavenModuleSet)MavenModuleSetBuild.this.project).getProperties(), true)) {
                MavenModuleSetBuild.this.setResult(Result.FAILURE);
            }
            MavenFingerprinter.aggregate(MavenModuleSetBuild.this);
        }

        public void cleanUp(BuildListener listener) throws Exception {
            MavenMailer mailer = (MavenMailer)((MavenModuleSet)MavenModuleSetBuild.this.project).getReporters().get(MavenMailer.class);
            if (mailer != null) {
                new MailSender(mailer.recipients, mailer.dontNotifyEveryUnstableBuild, mailer.sendToIndividuals).execute((AbstractBuild)MavenModuleSetBuild.this, listener);
            }
            this.performAllBuildSteps(listener, (Iterable)((MavenModuleSet)MavenModuleSetBuild.this.project).getPublishers(), false);
            this.performAllBuildSteps(listener, ((MavenModuleSet)MavenModuleSetBuild.this.project).getProperties(), false);
            super.cleanUp(listener);
        }
    }
}

