/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.util;

import hudson.tasks._maven.Maven3MojoNote;
import java.io.IOException;
import java.util.Date;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;

public class ExecutionEventLogger
extends AbstractExecutionListener {
    private final Logger logger;
    private static final int LINE_LENGTH = 72;

    public ExecutionEventLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger missing");
        }
        this.logger = logger;
    }

    private static String chars(char c, int count) {
        StringBuilder buffer = new StringBuilder(count);
        for (int i = count; i > 0; --i) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String getFormattedTime(long time) {
        long h = time / 3600000L;
        long m = (time - h * 60L * 60L * 1000L) / 60000L;
        long s = (time - h * 60L * 60L * 1000L - m * 60L * 1000L) / 1000L;
        long ms = time % 1000L;
        String format = h > 0L ? "%1$d:%2$02d:%3$02d.%4$03ds" : (m > 0L ? "%2$d:%3$02d.%4$03ds" : "%3$d.%4$03ds");
        return String.format(format, h, m, s, ms);
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Scanning for projects...");
        }
    }

    public void sessionStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getSession().getProjects().size() > 1) {
            this.logger.info(ExecutionEventLogger.chars('-', 72));
            this.logger.info("Reactor Build Order:");
            this.logger.info("");
            for (MavenProject project : event.getSession().getProjects()) {
                this.logger.info(project.getName());
            }
        }
    }

    public void sessionEnded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            if (event.getSession().getProjects().size() > 1) {
                this.logReactorSummary(event.getSession());
            }
            this.logResult(event.getSession());
            this.logStats(event.getSession());
            this.logger.info(ExecutionEventLogger.chars('-', 72));
        }
    }

    private void logReactorSummary(MavenSession session) {
        this.logger.info(ExecutionEventLogger.chars('-', 72));
        this.logger.info("Reactor Summary:");
        this.logger.info("");
        MavenExecutionResult result = session.getResult();
        for (MavenProject project : session.getProjects()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(project.getName());
            buffer.append(' ');
            while (buffer.length() < 51) {
                buffer.append('.');
            }
            buffer.append(' ');
            BuildSummary buildSummary = result.getBuildSummary(project);
            if (buildSummary == null) {
                buffer.append("SKIPPED");
            } else if (buildSummary instanceof BuildSuccess) {
                buffer.append("SUCCESS [");
                buffer.append(ExecutionEventLogger.getFormattedTime(buildSummary.getTime()));
                buffer.append("]");
            } else if (buildSummary instanceof BuildFailure) {
                buffer.append("FAILURE [");
                buffer.append(ExecutionEventLogger.getFormattedTime(buildSummary.getTime()));
                buffer.append("]");
            }
            this.logger.info(buffer.toString());
        }
    }

    private void logResult(MavenSession session) {
        this.logger.info(ExecutionEventLogger.chars('-', 72));
        if (session.getResult().hasExceptions()) {
            this.logger.info("BUILD FAILURE");
        } else {
            this.logger.info("BUILD SUCCESS");
        }
    }

    private void logStats(MavenSession session) {
        this.logger.info(ExecutionEventLogger.chars('-', 72));
        Date finish = new Date();
        long time = finish.getTime() - session.getRequest().getStartTime().getTime();
        String wallClock = session.getRequest().isThreadConfigurationPresent() ? " (Wall Clock)" : "";
        this.logger.info("Total time: " + ExecutionEventLogger.getFormattedTime(time) + wallClock);
        this.logger.info("Finished at: " + finish);
        System.gc();
        Runtime r = Runtime.getRuntime();
        long MB = 0x100000L;
        this.logger.info("Final Memory: " + (r.totalMemory() - r.freeMemory()) / MB + "M/" + r.totalMemory() / MB + "M");
    }

    public void projectSkipped(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(ExecutionEventLogger.chars(' ', 72));
            this.logger.info(ExecutionEventLogger.chars('-', 72));
            this.logger.info("Skipping " + event.getProject().getName());
            this.logger.info("This project has been banned from the build due to previous failures.");
            this.logger.info(ExecutionEventLogger.chars('-', 72));
        }
    }

    public void projectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(ExecutionEventLogger.chars(' ', 72));
            this.logger.info(ExecutionEventLogger.chars('-', 72));
            this.logger.info("Building " + event.getProject().getName() + " " + event.getProject().getVersion());
            this.logger.info(ExecutionEventLogger.chars('-', 72));
        }
    }

    public void mojoSkipped(ExecutionEvent event) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Goal " + event.getMojoExecution().getGoal() + " requires online mode for execution but Maven is currently offline, skipping");
        }
    }

    public void mojoStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            Maven3MojoNote note = new Maven3MojoNote();
            StringBuilder buffer = new StringBuilder(128);
            try {
                buffer.append(note.encode());
            }
            catch (IOException e) {
                throw new RuntimeException("Could not encode note?", e);
            }
            buffer.append("--- ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.append(" ---");
            this.logger.info("");
            this.logger.info(buffer.toString());
        }
    }

    public void forkStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(">>> ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.append(" >>>");
            this.logger.info("");
            this.logger.info(buffer.toString());
        }
    }

    public void forkSucceeded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append("<<< ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.append(" <<<");
            this.logger.info("");
            this.logger.info(buffer.toString());
        }
    }

    private void append(StringBuilder buffer, MojoExecution me) {
        buffer.append(me.getArtifactId()).append(':').append(me.getVersion());
        buffer.append(':').append(me.getGoal());
        if (me.getExecutionId() != null) {
            buffer.append(" (").append(me.getExecutionId()).append(')');
        }
    }

    private void append(StringBuilder buffer, MavenProject project) {
        buffer.append(" @ ").append(project.getArtifactId());
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getMojoExecution().getForkedExecutions().size() > 1) {
            this.logger.info(ExecutionEventLogger.chars(' ', 72));
            this.logger.info(ExecutionEventLogger.chars('>', 72));
            this.logger.info("Forking " + event.getProject().getName() + " " + event.getProject().getVersion());
            this.logger.info(ExecutionEventLogger.chars('>', 72));
        }
    }
}

