/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Extension;
import hudson.Launcher;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.SurefireReport;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResultAction;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;

public class MavenTestDataPublisher
extends Recorder {
    private final DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers;

    public MavenTestDataPublisher(DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers) {
        this.testDataPublishers = testDataPublishers;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        MavenModuleSetBuild msb = (MavenModuleSetBuild)build;
        Map<MavenModule, MavenBuild> moduleLastBuilds = msb.getModuleLastBuilds();
        for (MavenBuild moduleBuild : moduleLastBuilds.values()) {
            SurefireReport report = (SurefireReport)moduleBuild.getAction(SurefireReport.class);
            if (report == null) continue;
            ArrayList<TestResultAction.Data> data = new ArrayList<TestResultAction.Data>();
            if (this.getTestDataPublishers() != null) {
                for (TestDataPublisher tdp : this.getTestDataPublishers()) {
                    TestResultAction.Data d = tdp.getTestData((AbstractBuild)moduleBuild, launcher, listener, report.getResult());
                    if (d == null) continue;
                    data.add(d);
                }
            }
            if (data.isEmpty()) continue;
            report.setData(data);
            moduleBuild.save();
        }
        return true;
    }

    public DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> getTestDataPublishers() {
        return this.testDataPublishers;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Additional test report features";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return MavenModuleSet.class.isAssignableFrom(jobType) && !TestDataPublisher.all().isEmpty();
        }

        public Publisher newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            DescribableList testDataPublishers = new DescribableList(Saveable.NOOP);
            try {
                testDataPublishers.rebuild(req, formData, (List)TestDataPublisher.all());
            }
            catch (IOException e) {
                throw new Descriptor.FormException((Throwable)e, null);
            }
            return new MavenTestDataPublisher((DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>>)testDataPublishers);
        }
    }
}

