// CHECKSTYLE:OFF

package hudson.maven.reporters;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code MavenArtifact.DeployingAttachedArtifact}: {@code Deploying
     * the attached artifact {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deploying the attached artifact {0}}
     */
    public static String MavenArtifact_DeployingAttachedArtifact(Object arg0) {
        return holder.format("MavenArtifact.DeployingAttachedArtifact", arg0);
    }

    /**
     * Key {@code MavenArtifact.DeployingAttachedArtifact}: {@code Deploying
     * the attached artifact {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deploying the attached artifact {0}}
     */
    public static Localizable _MavenArtifact_DeployingAttachedArtifact(Object arg0) {
        return new Localizable(holder, "MavenArtifact.DeployingAttachedArtifact", arg0);
    }

    /**
     * Key {@code ReportCollector.OutsideSite}: {@code Maven report output
     * goes to {0}, which is outside project reporting path{1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Maven report output goes to {0}, which is outside project
     *     reporting path{1}}
     */
    public static String ReportCollector_OutsideSite(Object arg0, Object arg1) {
        return holder.format("ReportCollector.OutsideSite", arg0, arg1);
    }

    /**
     * Key {@code ReportCollector.OutsideSite}: {@code Maven report output
     * goes to {0}, which is outside project reporting path{1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Maven report output goes to {0}, which is outside project
     *     reporting path{1}}
     */
    public static Localizable _ReportCollector_OutsideSite(Object arg0, Object arg1) {
        return new Localizable(holder, "ReportCollector.OutsideSite", arg0, arg1);
    }

    /**
     * Key {@code SurefireArchiver.NoReportsDir}: {@code Unable to obtain the
     * reportsDirectory from surefire:test mojo}.
     * 
     * @return
     *     {@code Unable to obtain the reportsDirectory from surefire:test mojo}
     */
    public static String SurefireArchiver_NoReportsDir() {
        return holder.format("SurefireArchiver.NoReportsDir");
    }

    /**
     * Key {@code SurefireArchiver.NoReportsDir}: {@code Unable to obtain the
     * reportsDirectory from surefire:test mojo}.
     * 
     * @return
     *     {@code Unable to obtain the reportsDirectory from surefire:test mojo}
     */
    public static Localizable _SurefireArchiver_NoReportsDir() {
        return new Localizable(holder, "SurefireArchiver.NoReportsDir");
    }

    /**
     * Key {@code ReportAction.DisplayName}: {@code Maven reports}.
     * 
     * @return
     *     {@code Maven reports}
     */
    public static String ReportAction_DisplayName() {
        return holder.format("ReportAction.DisplayName");
    }

    /**
     * Key {@code ReportAction.DisplayName}: {@code Maven reports}.
     * 
     * @return
     *     {@code Maven reports}
     */
    public static Localizable _ReportAction_DisplayName() {
        return new Localizable(holder, "ReportAction.DisplayName");
    }

    /**
     * Key {@code MavenFingerprinter.DisplayName}: {@code Record
     * fingerprints}.
     * 
     * @return
     *     {@code Record fingerprints}
     */
    public static String MavenFingerprinter_DisplayName() {
        return holder.format("MavenFingerprinter.DisplayName");
    }

    /**
     * Key {@code MavenFingerprinter.DisplayName}: {@code Record
     * fingerprints}.
     * 
     * @return
     *     {@code Record fingerprints}
     */
    public static Localizable _MavenFingerprinter_DisplayName() {
        return new Localizable(holder, "MavenFingerprinter.DisplayName");
    }

    /**
     * Key {@code MavenJavadocArchiver.FailedToCopy}: {@code Unable to copy
     * Javadoc from {0} to {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to copy Javadoc from {0} to {1}}
     */
    public static String MavenJavadocArchiver_FailedToCopy(Object arg0, Object arg1) {
        return holder.format("MavenJavadocArchiver.FailedToCopy", arg0, arg1);
    }

    /**
     * Key {@code MavenJavadocArchiver.FailedToCopy}: {@code Unable to copy
     * Javadoc from {0} to {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to copy Javadoc from {0} to {1}}
     */
    public static Localizable _MavenJavadocArchiver_FailedToCopy(Object arg0, Object arg1) {
        return new Localizable(holder, "MavenJavadocArchiver.FailedToCopy", arg0, arg1);
    }

    /**
     * Key {@code MavenAbstractArtifactRecord.Displayname}: {@code Redeploy
     * Artifacts}.
     * 
     * @return
     *     {@code Redeploy Artifacts}
     */
    public static String MavenAbstractArtifactRecord_Displayname() {
        return holder.format("MavenAbstractArtifactRecord.Displayname");
    }

    /**
     * Key {@code MavenAbstractArtifactRecord.Displayname}: {@code Redeploy
     * Artifacts}.
     * 
     * @return
     *     {@code Redeploy Artifacts}
     */
    public static Localizable _MavenAbstractArtifactRecord_Displayname() {
        return new Localizable(holder, "MavenAbstractArtifactRecord.Displayname");
    }

    /**
     * Key {@code MavenArtifactArchiver.DisplayName}: {@code Archive the
     * artifacts}.
     * 
     * @return
     *     {@code Archive the artifacts}
     */
    public static String MavenArtifactArchiver_DisplayName() {
        return holder.format("MavenArtifactArchiver.DisplayName");
    }

    /**
     * Key {@code MavenArtifactArchiver.DisplayName}: {@code Archive the
     * artifacts}.
     * 
     * @return
     *     {@code Archive the artifacts}
     */
    public static Localizable _MavenArtifactArchiver_DisplayName() {
        return new Localizable(holder, "MavenArtifactArchiver.DisplayName");
    }

    /**
     * Key {@code MavenSiteArchiver.DisplayName}: {@code Maven-generated
     * site}.
     * 
     * @return
     *     {@code Maven-generated site}
     */
    public static String MavenSiteArchiver_DisplayName() {
        return holder.format("MavenSiteArchiver.DisplayName");
    }

    /**
     * Key {@code MavenSiteArchiver.DisplayName}: {@code Maven-generated
     * site}.
     * 
     * @return
     *     {@code Maven-generated site}
     */
    public static Localizable _MavenSiteArchiver_DisplayName() {
        return new Localizable(holder, "MavenSiteArchiver.DisplayName");
    }

    /**
     * Key {@code SurefireArchiver.Recording}: {@code [JENKINS] Recording
     * test results}.
     * 
     * @return
     *     {@code [JENKINS] Recording test results}
     */
    public static String SurefireArchiver_Recording() {
        return holder.format("SurefireArchiver.Recording");
    }

    /**
     * Key {@code SurefireArchiver.Recording}: {@code [JENKINS] Recording
     * test results}.
     * 
     * @return
     *     {@code [JENKINS] Recording test results}
     */
    public static Localizable _SurefireArchiver_Recording() {
        return new Localizable(holder, "SurefireArchiver.Recording");
    }

    /**
     * Key {@code BuildInfoRecorder.DisplayName}: {@code Record build
     * information}.
     * 
     * @return
     *     {@code Record build information}
     */
    public static String BuildInfoRecorder_DisplayName() {
        return holder.format("BuildInfoRecorder.DisplayName");
    }

    /**
     * Key {@code BuildInfoRecorder.DisplayName}: {@code Record build
     * information}.
     * 
     * @return
     *     {@code Record build information}
     */
    public static Localizable _BuildInfoRecorder_DisplayName() {
        return new Localizable(holder, "BuildInfoRecorder.DisplayName");
    }

    /**
     * Key {@code MavenJavadocArchiver.DisplayName}: {@code Publish javadoc}.
     * 
     * @return
     *     {@code Publish javadoc}
     */
    public static String MavenJavadocArchiver_DisplayName() {
        return holder.format("MavenJavadocArchiver.DisplayName");
    }

    /**
     * Key {@code MavenJavadocArchiver.DisplayName}: {@code Publish javadoc}.
     * 
     * @return
     *     {@code Publish javadoc}
     */
    public static Localizable _MavenJavadocArchiver_DisplayName() {
        return new Localizable(holder, "MavenJavadocArchiver.DisplayName");
    }

    /**
     * Key {@code MavenMailer.DisplayName}: {@code E-mail Notification}.
     * 
     * @return
     *     {@code E-mail Notification}
     */
    public static String MavenMailer_DisplayName() {
        return holder.format("MavenMailer.DisplayName");
    }

    /**
     * Key {@code MavenMailer.DisplayName}: {@code E-mail Notification}.
     * 
     * @return
     *     {@code E-mail Notification}
     */
    public static Localizable _MavenMailer_DisplayName() {
        return new Localizable(holder, "MavenMailer.DisplayName");
    }

    /**
     * Key {@code MavenArtifact.DeployingMainArtifact}: {@code Deploying the
     * main artifact {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deploying the main artifact {0}}
     */
    public static String MavenArtifact_DeployingMainArtifact(Object arg0) {
        return holder.format("MavenArtifact.DeployingMainArtifact", arg0);
    }

    /**
     * Key {@code MavenArtifact.DeployingMainArtifact}: {@code Deploying the
     * main artifact {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deploying the main artifact {0}}
     */
    public static Localizable _MavenArtifact_DeployingMainArtifact(Object arg0) {
        return new Localizable(holder, "MavenArtifact.DeployingMainArtifact", arg0);
    }

    /**
     * Key {@code MavenJavadocArchiver.NoDestDir}: {@code Unable to obtain
     * the destDir from javadoc mojo}.
     * 
     * @return
     *     {@code Unable to obtain the destDir from javadoc mojo}
     */
    public static String MavenJavadocArchiver_NoDestDir() {
        return holder.format("MavenJavadocArchiver.NoDestDir");
    }

    /**
     * Key {@code MavenJavadocArchiver.NoDestDir}: {@code Unable to obtain
     * the destDir from javadoc mojo}.
     * 
     * @return
     *     {@code Unable to obtain the destDir from javadoc mojo}
     */
    public static Localizable _MavenJavadocArchiver_NoDestDir() {
        return new Localizable(holder, "MavenJavadocArchiver.NoDestDir");
    }

    /**
     * Key {@code MavenTestJavadocArchiver.DisplayName}: {@code Publish Test
     * javadoc}.
     * 
     * @return
     *     {@code Publish Test javadoc}
     */
    public static String MavenTestJavadocArchiver_DisplayName() {
        return holder.format("MavenTestJavadocArchiver.DisplayName");
    }

    /**
     * Key {@code MavenTestJavadocArchiver.DisplayName}: {@code Publish Test
     * javadoc}.
     * 
     * @return
     *     {@code Publish Test javadoc}
     */
    public static Localizable _MavenTestJavadocArchiver_DisplayName() {
        return new Localizable(holder, "MavenTestJavadocArchiver.DisplayName");
    }

    /**
     * Key {@code SurefireArchiver.DisplayName}: {@code Publish surefire
     * reports}.
     * 
     * @return
     *     {@code Publish surefire reports}
     */
    public static String SurefireArchiver_DisplayName() {
        return holder.format("SurefireArchiver.DisplayName");
    }

    /**
     * Key {@code SurefireArchiver.DisplayName}: {@code Publish surefire
     * reports}.
     * 
     * @return
     *     {@code Publish surefire reports}
     */
    public static Localizable _SurefireArchiver_DisplayName() {
        return new Localizable(holder, "SurefireArchiver.DisplayName");
    }

    /**
     * Key {@code ReportCollector.DisplayName}: {@code Record Maven reports}.
     * 
     * @return
     *     {@code Record Maven reports}
     */
    public static String ReportCollector_DisplayName() {
        return holder.format("ReportCollector.DisplayName");
    }

    /**
     * Key {@code ReportCollector.DisplayName}: {@code Record Maven reports}.
     * 
     * @return
     *     {@code Record Maven reports}
     */
    public static Localizable _ReportCollector_DisplayName() {
        return new Localizable(holder, "ReportCollector.DisplayName");
    }

    /**
     * Key {@code HistoryWidgetImpl.Displayname}: {@code Deployment History}.
     * 
     * @return
     *     {@code Deployment History}
     */
    public static String HistoryWidgetImpl_Displayname() {
        return holder.format("HistoryWidgetImpl.Displayname");
    }

    /**
     * Key {@code HistoryWidgetImpl.Displayname}: {@code Deployment History}.
     * 
     * @return
     *     {@code Deployment History}
     */
    public static Localizable _HistoryWidgetImpl_Displayname() {
        return new Localizable(holder, "HistoryWidgetImpl.Displayname");
    }

    /**
     * Key {@code MavenArtifactArchiver.FailedToInstallToMaster}: {@code
     * Failed to install artifact to the master}.
     * 
     * @return
     *     {@code Failed to install artifact to the master}
     */
    public static String MavenArtifactArchiver_FailedToInstallToMaster() {
        return holder.format("MavenArtifactArchiver.FailedToInstallToMaster");
    }

    /**
     * Key {@code MavenArtifactArchiver.FailedToInstallToMaster}: {@code
     * Failed to install artifact to the master}.
     * 
     * @return
     *     {@code Failed to install artifact to the master}
     */
    public static Localizable _MavenArtifactArchiver_FailedToInstallToMaster() {
        return new Localizable(holder, "MavenArtifactArchiver.FailedToInstallToMaster");
    }

}
