/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.Command;
import hudson.remoting.PipeWindow;
import hudson.remoting.Request;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProxyOutputStream
extends OutputStream {
    private Channel channel;
    private int oid;
    private PipeWindow window;
    private ByteArrayOutputStream tmp;
    private boolean closed;
    private static final Logger LOGGER = Logger.getLogger(ProxyOutputStream.class.getName());

    public ProxyOutputStream() {
    }

    public ProxyOutputStream(Channel channel, int oid) throws IOException {
        this.connect(channel, oid);
    }

    synchronized void connect(Channel channel, int oid) throws IOException {
        if (this.channel != null) {
            throw new IllegalStateException("Cannot connect twice");
        }
        if (oid == 0) {
            throw new IllegalArgumentException("oid=0");
        }
        this.channel = channel;
        this.oid = oid;
        this.window = channel.getPipeWindow(oid);
        if (this.tmp != null) {
            byte[] b = this.tmp.toByteArray();
            this.tmp = null;
            this._write(b, 0, b.length);
        }
        if (this.closed) {
            this.doClose();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("stream is already closed");
        }
        this._write(b, off, len);
    }

    private synchronized void _write(byte[] b, int off, int len) throws IOException {
        if (this.channel == null) {
            if (this.tmp == null) {
                this.tmp = new ByteArrayOutputStream();
            }
            this.tmp.write(b, off, len);
        } else {
            int max = this.window.max();
            while (len > 0) {
                int sendable;
                try {
                    sendable = Math.min(this.window.get(Math.min(max / 10, len)), len);
                    sendable = Math.min(sendable, max / 2);
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
                this.channel.send(new Chunk(this.channel.newIoId(), this.oid, b, off, sendable));
                this.window.decrease(sendable);
                off += sendable;
                len -= sendable;
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.channel != null) {
            this.channel.send(new Flush(this.channel.newIoId(), this.oid));
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        if (this.channel != null) {
            this.doClose();
        }
    }

    private void doClose() throws IOException {
        this.channel.send(new EOF(this.channel.newIoId(), this.oid));
        this.channel = null;
        this.oid = -1;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.channel != null) {
            this.channel.send(new Unexport(this.channel.newIoId(), this.oid));
            this.channel = null;
            this.oid = -1;
        }
    }

    private static void markForIoSync(Channel channel, int requestId, Future<?> ioOp) {
        Request<?, ?> call = channel.pendingCalls.get(requestId);
        if (call != null) {
            call.lastIo = ioOp;
        }
    }

    private static final class NotifyDeadWriter
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        private NotifyDeadWriter(Channel channel, Throwable cause, int oid) {
            super(channel, cause);
            this.oid = oid;
        }

        protected void execute(Channel channel) {
            PipeWindow w = channel.getPipeWindow(this.oid);
            w.dead(this.createdAt.getCause());
        }

        public String toString() {
            return "Pipe.Dead(" + this.oid + ")";
        }
    }

    private static class Ack
    extends Command {
        private final int oid;
        private final int size;
        private static final long serialVersionUID = 1L;

        private Ack(int oid, int size) {
            super(false);
            this.oid = oid;
            this.size = size;
        }

        protected void execute(Channel channel) {
            PipeWindow w = channel.getPipeWindow(this.oid);
            w.increase(this.size);
        }

        public String toString() {
            return "Pipe.Ack(" + this.oid + ',' + this.size + ")";
        }
    }

    private static final class EOF
    extends Command {
        private final int oid;
        private final int requestId = Request.getCurrentRequestId();
        private final int ioId;
        private static final long serialVersionUID = 1L;

        public EOF(int ioId, int oid) {
            this.ioId = ioId;
            this.oid = oid;
        }

        protected void execute(final Channel channel) {
            final OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            ProxyOutputStream.markForIoSync(channel, this.requestId, channel.pipeWriter.submit(this.ioId, new Runnable(){

                public void run() {
                    channel.unexport(EOF.this.oid);
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }));
        }

        public String toString() {
            return "Pipe.EOF(" + this.oid + ")";
        }
    }

    private static class Unexport
    extends Command {
        private final int oid;
        private final int ioId;
        private static final long serialVersionUID = 1L;

        public Unexport(int ioId, int oid) {
            this.ioId = ioId;
            this.oid = oid;
        }

        protected void execute(final Channel channel) {
            channel.pipeWriter.submit(this.ioId, new Runnable(){

                public void run() {
                    channel.unexport(Unexport.this.oid);
                }
            });
        }

        public String toString() {
            return "Pipe.Unexport(" + this.oid + ")";
        }
    }

    private static final class Flush
    extends Command {
        private final int oid;
        private final int requestId = Request.getCurrentRequestId();
        private final int ioId;
        private static final long serialVersionUID = 1L;

        public Flush(int ioId, int oid) {
            super(false);
            this.ioId = ioId;
            this.oid = oid;
        }

        protected void execute(Channel channel) {
            final OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            ProxyOutputStream.markForIoSync(channel, this.requestId, channel.pipeWriter.submit(this.ioId, new Runnable(){

                public void run() {
                    try {
                        os.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }));
        }

        public String toString() {
            return "Pipe.Flush(" + this.oid + ")";
        }
    }

    private static final class Chunk
    extends Command {
        private final int oid;
        private final int ioId;
        private final int requestId = Request.getCurrentRequestId();
        private final byte[] buf;
        private static final long serialVersionUID = 1L;

        public Chunk(int ioId, int oid, byte[] buf, int start, int len) {
            super(false);
            this.ioId = ioId;
            this.oid = oid;
            if (start == 0 && len == buf.length) {
                this.buf = buf;
            } else {
                this.buf = new byte[len];
                System.arraycopy(buf, start, this.buf, 0, len);
            }
        }

        protected void execute(final Channel channel) {
            final OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            ProxyOutputStream.markForIoSync(channel, this.requestId, channel.pipeWriter.submit(this.ioId, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        os.write(Chunk.this.buf);
                    }
                    catch (IOException e) {
                        try {
                            channel.send(new NotifyDeadWriter(channel, e, Chunk.this.oid));
                        }
                        catch (ChannelClosedException x) {
                        }
                        catch (IOException x) {
                            LOGGER.log(Level.WARNING, "Failed to notify the sender that the write end is dead", x);
                            LOGGER.log(Level.WARNING, "... the failed write was:", e);
                        }
                    }
                    finally {
                        if (channel.remoteCapability.supportsPipeThrottling()) {
                            try {
                                channel.send(new Ack(Chunk.this.oid, Chunk.this.buf.length));
                            }
                            catch (ChannelClosedException x) {
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, "Failed to ack the stream", e);
                            }
                        }
                    }
                }
            }));
        }

        public String toString() {
            return "Pipe.Chunk(" + this.oid + "," + this.buf.length + ")";
        }
    }
}

