/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Capability;
import hudson.remoting.Channel;
import hudson.remoting.ChunkedCommandTransport;
import hudson.remoting.ClassicCommandTransport;
import hudson.remoting.CommandTransport;
import hudson.remoting.FlightRecorderInputStream;
import hudson.remoting.JarCache;
import hudson.remoting.ObjectInputStreamEx;
import hudson.remoting.SocketChannelStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;

public class ChannelBuilder {
    private final String name;
    private final ExecutorService executors;
    private ClassLoader base = this.getClass().getClassLoader();
    private Channel.Mode mode = Channel.Mode.NEGOTIATE;
    private Capability capability = new Capability();
    private OutputStream header;
    private boolean restricted;
    private JarCache jarCache;

    public ChannelBuilder(String name, ExecutorService executors) {
        this.name = name;
        this.executors = executors;
    }

    public String getName() {
        return this.name;
    }

    public ExecutorService getExecutors() {
        return this.executors;
    }

    public ChannelBuilder withBaseLoader(ClassLoader base) {
        if (base == null) {
            base = this.getClass().getClassLoader();
        }
        this.base = base;
        return this;
    }

    public ClassLoader getBaseLoader() {
        return this.base;
    }

    public ChannelBuilder withMode(Channel.Mode mode) {
        this.mode = mode;
        return this;
    }

    public Channel.Mode getMode() {
        return this.mode;
    }

    public ChannelBuilder withCapability(Capability capability) {
        this.capability = capability;
        return this;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public ChannelBuilder withHeaderStream(OutputStream header) {
        this.header = header;
        return this;
    }

    public OutputStream getHeaderStream() {
        return this.header;
    }

    public ChannelBuilder withRestricted(boolean restricted) {
        this.restricted = restricted;
        return this;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public ChannelBuilder withJarCache(JarCache jarCache) {
        this.jarCache = jarCache;
        return this;
    }

    public JarCache getJarCache() {
        return this.jarCache;
    }

    public Channel build(InputStream is, OutputStream os) throws IOException {
        return new Channel(this, this.negotiate(is, os));
    }

    public Channel build(Socket s) throws IOException {
        return this.build(new BufferedInputStream(SocketChannelStream.in(s)), new BufferedOutputStream(SocketChannelStream.out(s)));
    }

    public Channel build(SocketChannel s) throws IOException {
        return this.build(SocketChannelStream.in(s), SocketChannelStream.out(s));
    }

    public Channel build(CommandTransport transport) throws IOException {
        return new Channel(this, transport);
    }

    protected CommandTransport negotiate(InputStream is, OutputStream os) throws IOException {
        this.capability.writePreamble(os);
        Channel.Mode mode = this.getMode();
        if (mode != Channel.Mode.NEGOTIATE) {
            os.write(mode.preamble);
            os.flush();
        }
        Channel.Mode[] modes = new Channel.Mode[]{Channel.Mode.BINARY, Channel.Mode.TEXT};
        byte[][] preambles = new byte[][]{Channel.Mode.BINARY.preamble, Channel.Mode.TEXT.preamble, Capability.PREAMBLE};
        int[] ptr = new int[3];
        Capability cap = new Capability(0L);
        while (true) {
            int ch;
            if ((ch = is.read()) == -1) {
                throw new EOFException("unexpected stream termination");
            }
            for (int i = 0; i < preambles.length; ++i) {
                byte[] preamble = preambles[i];
                if (preamble[ptr[i]] == ch) {
                    int n = i;
                    ptr[n] = ptr[n] + 1;
                    if (ptr[n] != preamble.length) continue;
                    switch (i) {
                        case 0: 
                        case 1: {
                            if (mode == Channel.Mode.NEGOTIATE) {
                                mode = modes[i];
                                os.write(mode.preamble);
                                os.flush();
                            } else if (modes[i] != mode) {
                                throw new IOException("Protocol negotiation failure");
                            }
                            return this.makeTransport(is, os, mode, cap);
                        }
                        case 2: {
                            cap = Capability.read(is);
                        }
                    }
                    ptr[i] = 0;
                    continue;
                }
                ptr[i] = 0;
            }
            if (this.header == null) continue;
            this.header.write(ch);
        }
    }

    protected CommandTransport makeTransport(InputStream is, OutputStream os, Channel.Mode mode, Capability cap) throws IOException {
        FlightRecorderInputStream fis = new FlightRecorderInputStream(is);
        if (cap.supportsChunking()) {
            return new ChunkedCommandTransport(cap, mode.wrap(fis), mode.wrap(os));
        }
        ObjectOutputStream oos = new ObjectOutputStream(mode.wrap(os));
        oos.flush();
        return new ClassicCommandTransport(new ObjectInputStreamEx(mode.wrap(fis), this.getBaseLoader()), oos, fis, os, cap);
    }
}

