/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Capability;
import hudson.remoting.Command;
import hudson.remoting.FlightRecorderInputStream;
import hudson.remoting.SynchronousCommandTransport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import javax.annotation.Nullable;

final class ClassicCommandTransport
extends SynchronousCommandTransport {
    private final ObjectInputStream ois;
    private final ObjectOutputStream oos;
    private final Capability remoteCapability;
    @Nullable
    private final FlightRecorderInputStream rawIn;
    private final OutputStream rawOut;

    ClassicCommandTransport(ObjectInputStream ois, ObjectOutputStream oos, FlightRecorderInputStream rawIn, OutputStream rawOut, Capability remoteCapability) {
        this.ois = ois;
        this.oos = oos;
        this.rawIn = rawIn;
        this.rawOut = rawOut;
        this.remoteCapability = remoteCapability;
    }

    public Capability getRemoteCapability() throws IOException {
        return this.remoteCapability;
    }

    public final void write(Command cmd, boolean last) throws IOException {
        cmd.writeTo(this.channel, this.oos);
        this.oos.flush();
        if (!last) {
            this.oos.reset();
        }
    }

    public void closeWrite() throws IOException {
        this.oos.close();
    }

    public final Command read() throws IOException, ClassNotFoundException {
        try {
            Command cmd = Command.readFrom(this.channel, this.ois);
            if (this.rawIn != null) {
                this.rawIn.clear();
            }
            return cmd;
        }
        catch (RuntimeException e) {
            throw this.diagnoseStreamCorruption(e);
        }
        catch (StreamCorruptedException e) {
            throw this.diagnoseStreamCorruption(e);
        }
    }

    private StreamCorruptedException diagnoseStreamCorruption(Exception e) throws StreamCorruptedException {
        if (this.rawIn == null) {
            if (e instanceof StreamCorruptedException) {
                return (StreamCorruptedException)e;
            }
            return (StreamCorruptedException)new StreamCorruptedException().initCause(e);
        }
        return this.rawIn.analyzeCrash(e, (this.channel != null ? this.channel : this).toString());
    }

    public void closeRead() throws IOException {
        this.ois.close();
    }

    OutputStream getUnderlyingStream() {
        return this.rawOut;
    }
}

