/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.DiagnosedStreamCorruptionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

class FlightRecorderInputStream
extends InputStream {
    static final int BUFFER_SIZE = Integer.getInteger("hudson.remoting.FlightRecorderInputStream.BUFFER_SIZE", 0x100000);
    private final InputStream source;
    private ByteArrayRingBuffer recorder = new ByteArrayRingBuffer(BUFFER_SIZE);

    FlightRecorderInputStream(InputStream source) {
        this.source = source;
    }

    public void clear() {
        this.recorder = new ByteArrayRingBuffer(BUFFER_SIZE);
    }

    public byte[] getRecord() {
        return this.recorder.toByteArray();
    }

    public DiagnosedStreamCorruptionException analyzeCrash(Exception problem, String diagnosisName) {
        final ByteArrayOutputStream readAhead = new ByteArrayOutputStream();
        final IOException[] error = new IOException[1];
        Thread diagnosisThread = new Thread(diagnosisName + " stream corruption diagnosis thread"){

            public void run() {
                try {
                    int b;
                    while (!Thread.interrupted() && (b = FlightRecorderInputStream.this.source.read()) != -1) {
                        readAhead.write(b);
                    }
                }
                catch (IOException e) {
                    error[0] = e;
                }
            }
        };
        diagnosisThread.start();
        try {
            diagnosisThread.join(1000L);
        }
        catch (InterruptedException _) {
            Thread.currentThread().interrupt();
        }
        IOException diagnosisProblem = error[0];
        if (diagnosisThread.isAlive()) {
            diagnosisThread.interrupt();
        }
        return new DiagnosedStreamCorruptionException(problem, diagnosisProblem, this.getRecord(), readAhead.toByteArray());
    }

    public int read() throws IOException {
        int i = this.source.read();
        if (i >= 0) {
            this.recorder.write(i);
        }
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if ((len = this.source.read(b, off, len)) > 0) {
            this.recorder.write(b, off, len);
        }
        return len;
    }

    public long skip(long n) throws IOException {
        byte[] buf = new byte[(int)Math.min(n, 65536L)];
        return this.read(buf, 0, buf.length);
    }

    public int available() throws IOException {
        return this.source.available();
    }

    public void close() throws IOException {
        this.source.close();
    }

    public boolean markSupported() {
        return false;
    }

    private static class ByteArrayRingBuffer
    extends OutputStream {
        byte[] data;
        int capacity;
        int pos = 0;
        boolean filled = false;

        public ByteArrayRingBuffer(int capacity) {
            this.data = new byte[capacity];
            this.capacity = capacity;
        }

        public synchronized void write(int b) {
            if (this.pos == this.capacity) {
                this.filled = true;
                this.pos = 0;
            }
            this.data[this.pos++] = (byte)b;
        }

        public byte[] toByteArray() {
            if (!this.filled) {
                return Arrays.copyOf(this.data, this.pos);
            }
            byte[] ret = new byte[this.capacity];
            System.arraycopy(this.data, this.pos, ret, 0, this.capacity - this.pos);
            System.arraycopy(this.data, 0, ret, this.capacity - this.pos, this.pos);
            return ret;
        }
    }
}

