/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Checksum;
import hudson.remoting.JarLoader;
import hudson.remoting.Util;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class JarLoaderImpl
implements JarLoader {
    private final ConcurrentMap<Checksum, URL> knownJars = new ConcurrentHashMap<Checksum, URL>();
    private final ConcurrentMap<URL, Checksum> checksums = new ConcurrentHashMap<URL, Checksum>();
    private final Set<Checksum> presentOnRemote = Collections.synchronizedSet(new HashSet());
    public static final String DIGEST_ALGORITHM = System.getProperty(JarLoaderImpl.class.getName() + ".algorithm", "SHA-256");

    JarLoaderImpl() {
    }

    public void writeJarTo(long sum1, long sum2, OutputStream sink) throws IOException, InterruptedException {
        Checksum k = new Checksum(sum1, sum2);
        URL url = (URL)this.knownJars.get(k);
        if (url == null) {
            throw new IOException("Unadvertised jar file " + k);
        }
        Util.copy(url.openStream(), sink);
        this.presentOnRemote.add(k);
    }

    public Checksum calcChecksum(File jar) throws IOException {
        return this.calcChecksum(jar.toURI().toURL());
    }

    public boolean isPresentOnRemote(Checksum sum) {
        return this.presentOnRemote.contains(sum);
    }

    public void notifyJarPresence(long sum1, long sum2) {
        this.presentOnRemote.add(new Checksum(sum1, sum2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyJarPresence(long[] sums) {
        Set<Checksum> set = this.presentOnRemote;
        synchronized (set) {
            for (int i = 0; i < sums.length; i += 2) {
                this.presentOnRemote.add(new Checksum(sums[i * 2], sums[i * 2 + 1]));
            }
        }
    }

    public Checksum calcChecksum(URL jar) throws IOException {
        Checksum v = (Checksum)this.checksums.get(jar);
        if (v != null) {
            return v;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            Util.copy(jar.openStream(), new DigestOutputStream(new NullOutputStream(), md));
            v = new Checksum(md.digest(), md.getDigestLength() / 8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        this.knownJars.put(v, jar);
        this.checksums.put(jar, v);
        return v;
    }

    class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int b) {
        }

        public void write(byte[] b) {
        }

        public void write(byte[] b, int off, int len) {
        }
    }
}

