/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Checksum;
import hudson.remoting.Future;
import hudson.remoting.JarCache;
import hudson.remoting.ResourceImageDirect;
import hudson.remoting.ResourceImageInJar;
import hudson.remoting.URLish;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceImageBoth
extends ResourceImageDirect {
    final long sum1;
    final long sum2;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ResourceImageBoth.class.getName());

    public ResourceImageBoth(URL resource, Checksum sum) throws IOException {
        super(resource);
        this.sum1 = sum.sum1;
        this.sum2 = sum.sum2;
    }

    @Override
    Future<byte[]> resolve(Channel channel, String resourcePath) throws IOException, InterruptedException {
        this.initiateJarRetrieval(channel);
        return super.resolve(channel, resourcePath);
    }

    @Override
    Future<URLish> resolveURL(Channel channel, String resourcePath) throws IOException, InterruptedException {
        Future<URL> f = this.initiateJarRetrieval(channel);
        if (f.isDone()) {
            return new ResourceImageInJar(this.sum1, this.sum2, null).resolveURL(channel, resourcePath);
        }
        return super.resolveURL(channel, resourcePath);
    }

    private Future<URL> initiateJarRetrieval(Channel channel) {
        JarCache c = channel.getJarCache();
        assert (c != null) : "we don't advertise jar caching to the other side unless we have a cache with us";
        try {
            return c.resolve(channel, this.sum1, this.sum2);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to initiate retrieval", e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to initiate retrieval", e);
            Thread.currentThread().interrupt();
        }
        return null;
    }
}

