/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.AsyncFutureImpl;
import hudson.remoting.Channel;
import hudson.remoting.Future;
import hudson.remoting.ResourceImageRef;
import hudson.remoting.URLish;
import hudson.remoting.Util;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceImageDirect
extends ResourceImageRef {
    private final byte[] payload;
    private static final Logger LOGGER = Logger.getLogger(ResourceImageDirect.class.getName());
    private static final long serialVersionUID = 1L;

    ResourceImageDirect(byte[] payload) {
        this.payload = payload;
    }

    ResourceImageDirect(URL resource) throws IOException {
        this(Util.readFully(resource.openStream()));
    }

    @Override
    Future<byte[]> resolve(Channel channel, String resourcePath) throws IOException, InterruptedException {
        LOGGER.log(Level.FINE, resourcePath + " image is direct");
        return new AsyncFutureImpl<byte[]>(this.payload);
    }

    @Override
    Future<URLish> resolveURL(Channel channel, String resourcePath) throws IOException, InterruptedException {
        return new AsyncFutureImpl<URLish>(URLish.from(Util.makeResource(resourcePath, this.payload)));
    }
}

