/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;

class Closeables {
    Closeables() {
    }

    public static Closeable input(SelectableChannel ch) {
        if (ch instanceof SocketChannel) {
            final SocketChannel s = (SocketChannel)ch;
            return new Closeable(){

                public void close() throws IOException {
                    s.socket().shutdownInput();
                    Closeables.maybeClose(s);
                }
            };
        }
        return ch;
    }

    public static Closeable output(SelectableChannel ch) {
        if (ch instanceof SocketChannel) {
            final SocketChannel s = (SocketChannel)ch;
            return new Closeable(){

                public void close() throws IOException {
                    s.socket().shutdownOutput();
                    Closeables.maybeClose(s);
                }
            };
        }
        return ch;
    }

    private static void maybeClose(SocketChannel sc) throws IOException {
        Socket s = sc.socket();
        if (s.isInputShutdown() && s.isOutputShutdown()) {
            s.close();
            sc.close();
        }
    }
}

