/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.nio;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class FifoBuffer
implements Closeable {
    private final Object lock;
    private int sz;
    private int limit;
    private final int pageSize;
    private Pointer r;
    private Pointer w;
    private boolean closed;

    public FifoBuffer(int pageSize, int limit) {
        this(null, pageSize, limit);
    }

    public FifoBuffer(int limit) {
        this(Math.max(limit / 256, 1024), limit);
    }

    public FifoBuffer(Object lock, int pageSize, int limit) {
        this.lock = lock == null ? this : lock;
        this.limit = limit;
        this.pageSize = pageSize;
        Page p = this.newPage();
        this.r = new Pointer(p, 0);
        this.w = new Pointer(p, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimit(int newLimit) {
        Object object = this.lock;
        synchronized (object) {
            this.limit = newLimit;
        }
    }

    private Page newPage() {
        return new Page(this.pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.sz > 0) {
                return this.sz;
            }
            if (this.closed) {
                return -1;
            }
            return 0;
        }
    }

    public int writable() {
        return Math.max(0, this.limit - this.readable());
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(WritableByteChannel ch) throws IOException {
        int read = 0;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                int chunk = this.readable();
                if (chunk <= 0) {
                    if (read > 0) {
                        return read;
                    }
                    if (this.closed) {
                        this.releaseRing();
                        return -1;
                    }
                    return 0;
                }
                int sent = this.r.send(ch, chunk);
                read += sent;
                this.sz -= sent;
                this.lock.notifyAll();
                if (sent == 0) {
                    return read;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeNonBlock(ByteBuffer buf) {
        Object object = this.lock;
        synchronized (object) {
            int chunk = Math.min(buf.remaining(), this.writable());
            if (chunk == 0) {
                return 0;
            }
            this.w.write(buf, chunk);
            this.sz += chunk;
            this.lock.notifyAll();
            return chunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receive(ReadableByteChannel ch) throws IOException {
        if (this.closed) {
            throw new IOException("already closed");
        }
        int written = 0;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                int chunk = this.writable();
                if (chunk == 0) {
                    return written;
                }
                int received = this.w.receive(ch, chunk);
                if (received == 0) {
                    return written;
                }
                if (received == -1) {
                    if (written == 0) {
                        return -1;
                    }
                    return written;
                }
                this.sz += received;
                written += received;
                this.lock.notifyAll();
            }
        }
    }

    public void write(byte[] buf) throws InterruptedException, IOException {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int start, int len) throws InterruptedException, IOException {
        if (this.closed) {
            throw new IOException("already closed");
        }
        while (len > 0) {
            Object object = this.lock;
            synchronized (object) {
                int chunk;
                while ((chunk = Math.min(len, this.writable())) == 0) {
                    this.lock.wait();
                }
                this.w.write(buf, start, chunk);
                start += chunk;
                len -= chunk;
                this.sz += chunk;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                this.releaseRing();
                this.lock.notifyAll();
            }
        }
    }

    private void releaseRing() {
        if (this.readable() < 0) {
            this.w = null;
            this.r = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int peek(int offset, byte[] data, int start, int len) {
        Object object = this.lock;
        synchronized (object) {
            len = Math.min(len, this.readable() - offset);
            if (len <= 0) {
                return 0;
            }
            Pointer v = this.r.copy();
            v.forward(offset);
            v.read(data, start, len);
            return len;
        }
    }

    public int peek(int offset, byte[] data) {
        return this.peek(offset, data, 0, data.length);
    }

    public int read(byte[] buf) throws InterruptedException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int start, int len) throws InterruptedException {
        if (len == 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                int r;
                if ((r = this.readNonBlocking(buf, start, len)) != 0) {
                    return r;
                }
                this.lock.wait();
            }
        }
    }

    public int readNonBlocking(byte[] buf) {
        return this.readNonBlocking(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readNonBlocking(byte[] buf, int start, int len) {
        if (len == 0) {
            return 0;
        }
        int read = 0;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                int chunk = Math.min(len, this.readable());
                if (chunk <= 0) {
                    if (read > 0) {
                        return read;
                    }
                    if (this.closed) {
                        this.releaseRing();
                        return -1;
                    }
                    return 0;
                }
                this.r.read(buf, start, chunk);
                start += chunk;
                len -= chunk;
                read += chunk;
                this.sz -= chunk;
                this.lock.notifyAll();
            }
        }
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            public void write(int b) throws IOException {
                try {
                    byte[] buf = new byte[]{(byte)b};
                    FifoBuffer.this.write(buf);
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
            }

            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    FifoBuffer.this.write(b, off, len);
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
            }

            public void close() throws IOException {
                FifoBuffer.this.close();
            }
        };
    }

    public InputStream getInputStream() {
        return new InputStream(){

            public int read() throws IOException {
                try {
                    byte[] b = new byte[1];
                    int n = FifoBuffer.this.read(b);
                    if (n < 0) {
                        return -1;
                    }
                    if (n == 0) {
                        throw new AssertionError();
                    }
                    return b[0] & 0xFF;
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
            }

            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    return FifoBuffer.this.read(b, off, len);
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
            }
        };
    }

    class Pointer {
        Page p;
        int off;

        Pointer(Page p, int off) {
            this.p = p;
            this.off = off;
        }

        Pointer copy() {
            return new Pointer(this.p, this.off);
        }

        void forward(int offset) {
            while (offset > 0) {
                int ch = Math.min(offset, this.chunk());
                assert (0 < ch && ch <= offset);
                offset -= ch;
                this.off += ch;
            }
        }

        private int chunk() {
            int sz = FifoBuffer.this.pageSize - this.off;
            assert (sz >= 0);
            if (sz > 0) {
                return sz;
            }
            Page q = this.p.next;
            if (q == null) {
                q = this.p.next = FifoBuffer.this.newPage();
            }
            this.p = q;
            this.off = 0;
            return FifoBuffer.this.pageSize;
        }

        public void write(ByteBuffer buf, int len) {
            while (len > 0) {
                int chunk = Math.min(len, this.chunk());
                buf.get(this.p.buf, this.off, chunk);
                this.off += chunk;
                len -= chunk;
            }
        }

        public void write(byte[] buf, int start, int len) {
            while (len > 0) {
                int chunk = Math.min(len, this.chunk());
                System.arraycopy(buf, start, this.p.buf, this.off, chunk);
                this.off += chunk;
                len -= chunk;
                start += chunk;
            }
        }

        public void read(byte[] buf, int start, int len) {
            while (len > 0) {
                int chunk = Math.min(len, this.chunk());
                assert (this.off + chunk <= this.p.buf.length);
                assert (start + chunk <= buf.length);
                assert (this.off >= 0);
                assert (start >= 0);
                assert (chunk >= 0);
                System.arraycopy(this.p.buf, this.off, buf, start, chunk);
                this.off += chunk;
                len -= chunk;
                start += chunk;
            }
        }

        private ByteBuffer asBuffer(int max) {
            int ch = this.chunk();
            return ByteBuffer.wrap(this.p.buf, this.off, Math.min(ch, max));
        }

        public int send(WritableByteChannel ch, int max) throws IOException {
            int n = ch.write(this.asBuffer(max));
            this.off += n;
            return n;
        }

        public int receive(ReadableByteChannel ch, int max) throws IOException {
            int n = ch.read(this.asBuffer(max));
            if (n >= 0) {
                this.off += n;
            }
            return n;
        }
    }

    static final class Page {
        final byte[] buf;
        Page next;

        Page(int sz) {
            this.buf = new byte[sz];
        }
    }
}

