/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.AbstractSynchronousByteArrayCommandTransport;
import hudson.remoting.Capability;
import hudson.remoting.Channel;
import hudson.remoting.ChunkedInputStream;
import hudson.remoting.ChunkedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ChunkedCommandTransport
extends AbstractSynchronousByteArrayCommandTransport {
    private final Capability remoteCapability;
    private final ChunkedInputStream in;
    private final ChunkedOutputStream out;

    ChunkedCommandTransport(Capability remoteCapability, InputStream in, OutputStream out) {
        this.remoteCapability = remoteCapability;
        this.in = new ChunkedInputStream(in);
        this.out = new ChunkedOutputStream(8192, out);
    }

    public Capability getRemoteCapability() throws IOException {
        return this.remoteCapability;
    }

    public byte[] readBlock(Channel channel) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.in.readUntilBreak(baos);
        return baos.toByteArray();
    }

    public void writeBlock(Channel channel, byte[] payload) throws IOException {
        this.out.write(payload);
        this.out.sendBreak();
    }

    public void closeWrite() throws IOException {
        this.out.close();
    }

    public void closeRead() throws IOException {
        this.in.close();
    }
}

