/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.ChunkHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ChunkedInputStream
extends InputStream {
    private final InputStream base;
    private int remaining;
    private boolean isLast;

    public ChunkedInputStream(InputStream base) {
        this.base = base;
    }

    public int read() throws IOException {
        if (this.nextPayload()) {
            return -1;
        }
        int x = this.base.read();
        --this.remaining;
        return x;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.nextPayload()) {
            return -1;
        }
        int x = this.base.read(b, off, len = Math.min(this.remaining, len));
        if (x < 0) {
            return x;
        }
        this.remaining -= x;
        return x;
    }

    private boolean nextPayload() throws IOException {
        while (this.remaining == 0) {
            if (!this.readHeader()) continue;
            return true;
        }
        return false;
    }

    private boolean readHeader() throws IOException {
        if (this.remaining > 0) {
            return false;
        }
        int b1 = this.base.read();
        int b2 = this.base.read();
        if (b1 < 0 || b2 < 0) {
            return true;
        }
        int header = ChunkHeader.parse(b1, b2);
        this.isLast = ChunkHeader.isLast(header);
        if (this.isLast) {
            this.onBreak();
        }
        this.remaining = ChunkHeader.length(header);
        return false;
    }

    protected void onBreak() {
    }

    public void readUntilBreak(OutputStream sink) throws IOException {
        byte[] buf = new byte[4096];
        do {
            if (this.remaining > 0) {
                int read = this.read(buf, 0, Math.min(this.remaining, buf.length));
                if (read == -1) {
                    throw new IOException("Unexpected EOF");
                }
                sink.write(buf, 0, read);
                continue;
            }
            this.readHeader();
        } while (!this.isLast || this.remaining != 0);
    }

    public void close() throws IOException {
        this.base.close();
    }
}

