/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Base64;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.EngineListener;
import hudson.remoting.EngineListenerSplitter;
import hudson.remoting.FileSystemJarCache;
import hudson.remoting.JarCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine
extends Thread {
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        public Thread newThread(final Runnable r) {
            Thread t = this.defaultFactory.newThread(new Runnable(){

                public void run() {
                    CURRENT.set(Engine.this);
                    r.run();
                }
            });
            t.setDaemon(true);
            return t;
        }
    });
    public final EngineListener listener;
    private final EngineListenerSplitter events = new EngineListenerSplitter();
    private List<URL> candidateUrls;
    private URL hudsonUrl;
    private final String secretKey;
    public final String slaveName;
    private String credentials;
    private String proxyCredentials = System.getProperty("proxyCredentials");
    private String tunnel;
    private boolean noReconnect;
    private String cookie;
    private JarCache jarCache = new FileSystemJarCache(new File(System.getProperty("user.home"), ".jenkins/cache/jars"), true);
    private static final ThreadLocal<Engine> CURRENT = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Engine.class.getName());
    public static final String GREETING_SUCCESS = "Welcome";

    public Engine(EngineListener listener, List<URL> hudsonUrls, String secretKey, String slaveName) {
        this.listener = listener;
        this.events.add(listener);
        this.candidateUrls = hudsonUrls;
        this.secretKey = secretKey;
        this.slaveName = slaveName;
        if (this.candidateUrls.isEmpty()) {
            throw new IllegalArgumentException("No URLs given");
        }
    }

    public void setJarCache(JarCache jarCache) {
        this.jarCache = jarCache;
    }

    public URL getHudsonUrl() {
        return this.hudsonUrl;
    }

    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    public void setCredentials(String creds) {
        this.credentials = creds;
    }

    public void setProxyCredentials(String proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
    }

    public void setNoReconnect(boolean noReconnect) {
        this.noReconnect = noReconnect;
    }

    public void addListener(EngineListener el) {
        this.events.add(el);
    }

    public void removeListener(EngineListener el) {
        this.events.remove(el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean first = true;
            while (true) {
                if (first) {
                    first = false;
                } else if (this.noReconnect) {
                    return;
                }
                this.events.status("Locating server among " + this.candidateUrls);
                Throwable firstError = null;
                String port = null;
                for (URL url : this.candidateUrls) {
                    Object var11_14;
                    HttpURLConnection con;
                    block26: {
                        block27: {
                            URL salURL;
                            String s = url.toExternalForm();
                            if (!s.endsWith("/")) {
                                s = s + '/';
                            }
                            if ((con = (HttpURLConnection)(salURL = new URL(s + "tcpSlaveAgentListener/")).openConnection()) instanceof HttpURLConnection) {
                                String encoding;
                                if (this.credentials != null) {
                                    encoding = Base64.encode(this.credentials.getBytes("UTF-8"));
                                    con.setRequestProperty("Authorization", "Basic " + encoding);
                                }
                                if (this.proxyCredentials != null) {
                                    encoding = Base64.encode(this.proxyCredentials.getBytes("UTF-8"));
                                    con.setRequestProperty("Proxy-Authorization", "Basic " + encoding);
                                }
                            }
                            try {
                                try {
                                    con.setConnectTimeout(30000);
                                    con.setReadTimeout(60000);
                                    con.connect();
                                }
                                catch (IOException x) {
                                    if (firstError == null) {
                                        firstError = new IOException("Failed to connect to " + salURL + ": " + x.getMessage()).initCause(x);
                                    }
                                    var11_14 = null;
                                    con.disconnect();
                                    continue;
                                }
                                port = con.getHeaderField("X-Hudson-JNLP-Port");
                                if (con.getResponseCode() != 200) {
                                    if (firstError == null) {
                                        firstError = new Exception(salURL + " is invalid: " + con.getResponseCode() + " " + con.getResponseMessage());
                                    }
                                    var11_14 = null;
                                    con.disconnect();
                                    continue;
                                }
                                if (port != null) break block26;
                                if (firstError != null) break block27;
                                firstError = new Exception(url + " is not Jenkins");
                            }
                            catch (Throwable throwable) {
                                var11_14 = null;
                                con.disconnect();
                                throw throwable;
                            }
                        }
                        var11_14 = null;
                        con.disconnect();
                        {
                            continue;
                        }
                    }
                    var11_14 = null;
                    con.disconnect();
                    this.hudsonUrl = url;
                    firstError = null;
                    this.candidateUrls = Collections.singletonList(this.hudsonUrl);
                    break;
                }
                if (firstError != null) {
                    this.events.error(firstError);
                    return;
                }
                Socket s = this.connect(port);
                this.events.status("Handshaking");
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                BufferedInputStream in = new BufferedInputStream(s.getInputStream());
                dos.writeUTF("Protocol:JNLP2-connect");
                Properties props = new Properties();
                props.put("Secret-Key", this.secretKey);
                props.put("Node-Name", this.slaveName);
                if (this.cookie != null) {
                    props.put("Cookie", this.cookie);
                }
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                props.store(o, null);
                dos.writeUTF(o.toString("UTF-8"));
                String greeting = Engine.readLine(in);
                if (greeting.startsWith("Unknown protocol")) {
                    LOGGER.info("The server didn't understand the v2 handshake. Falling back to v1 handshake");
                    s.close();
                    s = this.connect(port);
                    in = new BufferedInputStream(s.getInputStream());
                    dos = new DataOutputStream(s.getOutputStream());
                    dos.writeUTF("Protocol:JNLP-connect");
                    dos.writeUTF(this.secretKey);
                    dos.writeUTF(this.slaveName);
                    greeting = Engine.readLine(in);
                    if (!greeting.equals(GREETING_SUCCESS)) {
                        this.onConnectionRejected(greeting);
                        continue;
                    }
                } else if (greeting.equals(GREETING_SUCCESS)) {
                    Properties responses = this.readResponseHeaders(in);
                    this.cookie = responses.getProperty("Cookie");
                } else {
                    this.onConnectionRejected(greeting);
                    continue;
                }
                Channel channel = new ChannelBuilder("channel", this.executor).withJarCache(this.jarCache).withMode(Channel.Mode.BINARY).build(in, new BufferedOutputStream(s.getOutputStream()));
                this.events.status("Connected");
                channel.join();
                this.events.status("Terminated");
                if (this.noReconnect) {
                    return;
                }
                this.events.onDisconnect();
                this.waitForServerToBack();
            }
        }
        catch (Throwable e) {
            this.events.error(e);
            return;
        }
    }

    private void onConnectionRejected(String greeting) throws InterruptedException {
        this.events.error(new Exception("The server rejected the connection: " + greeting));
        Thread.sleep(10000L);
    }

    private Properties readResponseHeaders(BufferedInputStream in) throws IOException {
        Properties response = new Properties();
        String line;
        while ((line = Engine.readLine(in)).length() != 0) {
            int idx = line.indexOf(58);
            response.put(line.substring(0, idx).trim(), line.substring(idx + 1).trim());
        }
        return response;
    }

    private static String readLine(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int ch;
        while ((ch = in.read()) >= 0 && ch != 10) {
            baos.write(ch);
        }
        return baos.toString("UTF-8").trim();
    }

    private Socket connect(String port) throws IOException, InterruptedException {
        String host = this.hudsonUrl.getHost();
        if (this.tunnel != null) {
            String[] tokens = this.tunnel.split(":", 3);
            if (tokens.length != 2) {
                throw new IOException("Illegal tunneling parameter: " + this.tunnel);
            }
            if (tokens[0].length() > 0) {
                host = tokens[0];
            }
            if (tokens[1].length() > 0) {
                port = tokens[1];
            }
        }
        String msg = "Connecting to " + host + ':' + port;
        this.events.status(msg);
        int retry = 1;
        while (true) {
            try {
                Socket s = new Socket(host, Integer.parseInt(port));
                s.setTcpNoDelay(true);
                s.setSoTimeout(1800000);
                return s;
            }
            catch (IOException e) {
                if (retry++ > 10) {
                    throw (IOException)new IOException("Failed to connect to " + host + ':' + port).initCause(e);
                }
                Thread.sleep(10000L);
                this.events.status(msg + " (retrying:" + retry + ")", e);
                continue;
            }
            break;
        }
    }

    private void waitForServerToBack() throws InterruptedException {
        Thread t = Thread.currentThread();
        String oldName = t.getName();
        try {
            int retries = 0;
            while (true) {
                HttpURLConnection con;
                block6: {
                    Thread.sleep(10000L);
                    URL url = new URL(this.hudsonUrl, "tcpSlaveAgentListener/");
                    t.setName(oldName + ": trying " + url + " for " + ++retries + " times");
                    con = (HttpURLConnection)url.openConnection();
                    con.setConnectTimeout(5000);
                    con.setReadTimeout(5000);
                    con.connect();
                    if (con.getResponseCode() != 200) break block6;
                    Object var7_7 = null;
                    t.setName(oldName);
                    return;
                }
                try {
                    LOGGER.info("Master isn't ready to talk to us. Will retry again: response code=" + con.getResponseCode());
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Failed to connect to the master. Will retry again", e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            t.setName(oldName);
            throw throwable;
        }
    }

    public static Engine current() {
        return CURRENT.get();
    }
}

