/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.ReferenceCountRecorder;
import hudson.remoting.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExportTable<T> {
    private final Map<Integer, Entry> table = new HashMap<Integer, Entry>();
    private final Map<T, Entry> reverse = new HashMap<T, Entry>();
    private final ThreadLocal<ExportList> lists = new ThreadLocal();
    private final List<Entry> unexportLog = new LinkedList<Entry>();
    private int iota = 1;
    public static int UNEXPORT_LOG_SIZE = Integer.getInteger(ExportTable.class.getName() + ".unexportLogSize", 1024);
    private static final Logger LOGGER = Logger.getLogger(ExportTable.class.getName());

    ExportTable() {
    }

    public ExportList startRecording() {
        ExportList el = new ExportList();
        this.lists.set(el);
        return el;
    }

    public boolean isRecording() {
        return this.lists.get() != null;
    }

    public synchronized int export(T t) {
        return this.export(t, true);
    }

    public synchronized int export(T t, boolean notifyListener) {
        ExportList l;
        if (t == null) {
            return 0;
        }
        Entry e = this.reverse.get(t);
        if (e == null) {
            e = new Entry(t);
        }
        e.addRef();
        if (notifyListener && (l = this.lists.get()) != null) {
            l.add(e);
        }
        return e.id;
    }

    synchronized void pin(T t) {
        Entry e = this.reverse.get(t);
        if (e == null) {
            e = new Entry(t);
        }
        e.pin();
    }

    @Nonnull
    public synchronized T get(int id) {
        Entry e = this.table.get(id);
        if (e != null) {
            return (T)e.object;
        }
        throw this.diagnoseInvalidId(id);
    }

    private synchronized IllegalStateException diagnoseInvalidId(int id) {
        Exception cause = null;
        if (!this.unexportLog.isEmpty()) {
            for (Entry e : this.unexportLog) {
                if (e.id != id) continue;
                cause = new Exception("Object was recently deallocated\n" + Util.indent(e.dump()), e.releaseTrace);
            }
            if (cause == null) {
                cause = new Exception("Object appears to be deallocated at lease before " + new Date(this.unexportLog.get((int)0).releaseTrace.timestamp));
            }
        }
        return new IllegalStateException("Invalid object ID " + id + " iota=" + this.iota, cause);
    }

    synchronized void unexport(T t, Throwable callSite) {
        if (t == null) {
            return;
        }
        Entry e = this.reverse.get(t);
        if (e == null) {
            LOGGER.log(Level.SEVERE, "Trying to unexport an object that's not exported: " + t);
            return;
        }
        e.release(callSite);
    }

    public synchronized void unexportByOid(Integer oid, Throwable callSite) {
        if (oid == null) {
            return;
        }
        Entry e = this.table.get(oid);
        if (e == null) {
            LOGGER.log(Level.SEVERE, "Trying to unexport an object that's already unexported", this.diagnoseInvalidId(oid));
            if (callSite != null) {
                LOGGER.log(Level.SEVERE, "2nd unexport attempt is here", callSite);
            }
            return;
        }
        e.release(callSite);
    }

    public synchronized void dump(PrintWriter w) throws IOException {
        for (Entry e : this.table.values()) {
            e.dump(w);
        }
    }

    synchronized boolean isExported(T o) {
        return this.reverse.containsKey(o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ExportList
    extends ArrayList<Entry> {
        private final ExportList old;

        private ExportList() {
            this.old = (ExportList)ExportTable.this.lists.get();
            ExportTable.this.lists.set(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(Throwable callSite) {
            ExportTable exportTable = ExportTable.this;
            synchronized (exportTable) {
                for (Entry e : this) {
                    e.release(callSite);
                }
            }
        }

        void stopRecording() {
            ExportTable.this.lists.set(this.old);
        }
    }

    static class ReleasedAt
    extends Source {
        ReleasedAt(Throwable callSite) {
            super(callSite);
        }

        public String toString() {
            return "  Released at " + new Date(this.timestamp);
        }
    }

    static class CreatedAt
    extends Source {
        CreatedAt() {
            super((Throwable)null);
        }

        public String toString() {
            return "  Created at " + new Date(this.timestamp);
        }
    }

    static class Source
    extends Exception {
        protected final long timestamp = System.currentTimeMillis();

        Source(Throwable callSite) {
            super(callSite);
            this.getStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Entry {
        final int id;
        private T object;
        final CreatedAt allocationTrace;
        ReleasedAt releaseTrace;
        private int referenceCount;
        private ReferenceCountRecorder recorder;

        Entry(T object) {
            this.id = ExportTable.this.iota++;
            this.object = object;
            this.allocationTrace = new CreatedAt();
            ExportTable.this.table.put(this.id, this);
            ExportTable.this.reverse.put(object, this);
        }

        void addRef() {
            ++this.referenceCount;
            if (this.recorder != null) {
                this.recorder.onAddRef(null);
            }
        }

        void pin() {
            if (this.referenceCount < 0x3FFFFFFF) {
                this.referenceCount += 0x3FFFFFFF;
            }
        }

        void release(Throwable callSite) {
            if (this.recorder != null) {
                this.recorder.onRelease(callSite);
            }
            if (--this.referenceCount == 0) {
                ExportTable.this.table.remove(this.id);
                ExportTable.this.reverse.remove(this.object);
                this.object = this.object.getClass().getName();
                this.releaseTrace = new ReleasedAt(callSite);
                ExportTable.this.unexportLog.add(this);
                while (ExportTable.this.unexportLog.size() > UNEXPORT_LOG_SIZE) {
                    ExportTable.this.unexportLog.remove(0);
                }
            }
        }

        void dump(PrintWriter w) throws IOException {
            w.printf("#%d (ref.%d) : %s\n", this.id, this.referenceCount, this.object);
            this.allocationTrace.printStackTrace(w);
            if (this.releaseTrace != null) {
                this.releaseTrace.printStackTrace(w);
            }
            if (this.recorder != null) {
                this.recorder.dump(w);
            }
        }

        String dump() {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                this.dump(pw);
                pw.close();
                return sw.toString();
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }
}

