/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

public class HexDump {
    private static final String CODE = "0123456789abcdef";

    public static String toHex(byte[] buf) {
        return HexDump.toHex(buf, 0, buf.length);
    }

    public static String toHex(byte[] buf, int start, int len) {
        StringBuilder r = new StringBuilder(len * 2);
        boolean inText = false;
        for (int i = 0; i < len; ++i) {
            byte b = buf[start + i];
            if (b >= 32 && b <= 126) {
                if (!inText) {
                    inText = true;
                    r.append('\'');
                }
                r.append((char)b);
                continue;
            }
            if (inText) {
                r.append("' ");
                inText = false;
            }
            r.append("0x");
            r.append(CODE.charAt(b >> 4 & 0xF));
            r.append(CODE.charAt(b & 0xF));
            if (i >= len - 1) continue;
            if (b == 10) {
                r.append('\n');
                continue;
            }
            r.append(' ');
        }
        if (inText) {
            r.append('\'');
        }
        return r.toString();
    }
}

