/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.Request;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

final class ProxyInputStream
extends InputStream {
    private Channel channel;
    private int oid;

    public ProxyInputStream(Channel channel, int oid) throws IOException {
        this.channel = channel;
        this.oid = oid;
    }

    public int read() throws IOException {
        try {
            Buffer buf = this._read(1);
            if (buf.len == 1) {
                return buf.buf[0] & 0xFF;
            }
            return -1;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.close();
            return -1;
        }
    }

    private synchronized Buffer _read(int len) throws IOException, InterruptedException {
        return (Buffer)new Chunk(this.oid, len).call(this.channel);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            Buffer buf = this._read(len);
            if (buf.len == -1) {
                return -1;
            }
            System.arraycopy(buf.buf, 0, b, off, buf.len);
            return buf.len;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.close();
            return -1;
        }
    }

    public synchronized void close() throws IOException {
        if (this.channel != null) {
            this.channel.send(new EOF(this.oid));
            this.channel = null;
            this.oid = -1;
        }
    }

    private static final class EOF
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        public EOF(int oid) {
            this.oid = oid;
        }

        protected void execute(Channel channel) {
            InputStream in = (InputStream)channel.getExportedObject(this.oid);
            channel.unexport(this.oid, this.createdAt);
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return "EOF(" + this.oid + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Chunk
    extends Request<Buffer, IOException> {
        private final int oid;
        private final int len;
        private static final long serialVersionUID = 1L;

        public Chunk(int oid, int len) {
            this.oid = oid;
            this.len = len;
        }

        @Override
        protected Buffer perform(Channel channel) throws IOException {
            InputStream in = (InputStream)channel.getExportedObject(this.oid);
            Buffer buf = new Buffer(this.len);
            buf.read(in);
            return buf;
        }
    }

    private static final class Buffer
    implements Serializable {
        byte[] buf;
        int len;
        private static final long serialVersionUID = 1L;

        public Buffer(int len) {
            this.buf = new byte[len];
        }

        public void read(InputStream in) throws IOException {
            this.len = in.read(this.buf, 0, this.buf.length);
        }
    }
}

