/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.DaemonThreadFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AtmostOneThreadExecutor
extends AbstractExecutorService {
    private Thread worker;
    private final LinkedList<Runnable> q = new LinkedList();
    private boolean shutdown;
    private final ThreadFactory factory;

    public AtmostOneThreadExecutor(ThreadFactory factory) {
        this.factory = factory;
    }

    public AtmostOneThreadExecutor() {
        this(new DaemonThreadFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.shutdown = true;
        LinkedList<Runnable> linkedList = this.q;
        synchronized (linkedList) {
            if (this.isAlive()) {
                this.worker.interrupt();
            }
        }
    }

    private boolean isAlive() {
        return this.worker != null && this.worker.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        LinkedList<Runnable> linkedList = this.q;
        synchronized (linkedList) {
            ArrayList<Runnable> r = new ArrayList<Runnable>(this.q);
            this.q.clear();
            return r;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown && !this.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        LinkedList<Runnable> linkedList = this.q;
        synchronized (linkedList) {
            long start = System.currentTimeMillis();
            long end = start + unit.toMillis(timeout);
            while (this.isAlive() && System.currentTimeMillis() < end) {
                this.q.wait(end - System.currentTimeMillis());
            }
        }
        return this.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        LinkedList<Runnable> linkedList = this.q;
        synchronized (linkedList) {
            this.q.add(command);
            if (!this.isAlive()) {
                this.worker = this.factory.newThread(new Worker());
                this.worker.start();
            }
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable task;
                LinkedList linkedList = AtmostOneThreadExecutor.this.q;
                synchronized (linkedList) {
                    if (AtmostOneThreadExecutor.this.q.isEmpty()) {
                        AtmostOneThreadExecutor.this.worker = null;
                        return;
                    }
                    task = (Runnable)AtmostOneThreadExecutor.this.q.remove();
                }
                task.run();
            }
        }
    }
}

