/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Util {
    Util() {
    }

    static String getBaseName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Util.copy(in, baos);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
        }
    }

    static File makeResource(String name, byte[] image) throws IOException {
        File tmpFile = Util.createTempDir();
        File resource = new File(tmpFile, name);
        resource.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(resource);
        fos.write(image);
        fos.close();
        Util.deleteDirectoryOnExit(tmpFile);
        return resource;
    }

    static File createTempDir() throws IOException {
        int nRetry = 0;
        while (true) {
            try {
                File tmpFile = File.createTempFile("jenkins-remoting", "");
                tmpFile.delete();
                tmpFile.mkdir();
                return tmpFile;
            }
            catch (IOException e) {
                if (nRetry++ < 100) continue;
                IOException nioe = new IOException("failed to create temp directory at default location, most probably at: " + System.getProperty("java.io.tmpdir"));
                nioe.initCause(e);
                throw nioe;
            }
            break;
        }
    }

    static void deleteDirectoryOnExit(File dir) {
        File[] childFiles;
        dir.deleteOnExit();
        if (dir.isDirectory() && (childFiles = dir.listFiles()) != null) {
            for (File f : childFiles) {
                Util.deleteDirectoryOnExit(f);
            }
        }
    }

    static String indent(String s) {
        return "    " + s.trim().replace("\n", "\n    ");
    }
}

