/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.nio;

import hudson.remoting.AbstractByteArrayCommandTransport;
import hudson.remoting.Callable;
import hudson.remoting.Capability;
import hudson.remoting.Channel;
import hudson.remoting.ChunkHeader;
import hudson.remoting.CommandTransport;
import hudson.remoting.SingleLaneExecutorService;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.nio.Closeables;
import org.jenkinsci.remoting.nio.FifoBuffer;
import org.jenkinsci.remoting.nio.NioChannelBuilder;
import org.jenkinsci.remoting.nio.SelectableFileChannelFactory;

public class NioChannelHub
implements Runnable,
Closeable {
    private final Selector selector;
    private int transportFrameSize = 8192;
    private final SelectableFileChannelFactory factory = new SelectableFileChannelFactory();
    private final Queue<Callable<Void, IOException>> selectorTasks = new ConcurrentLinkedQueue<Callable<Void, IOException>>();
    private ExecutorService commandProcessor;
    private long gen;
    private volatile Thread selectorThread;
    private volatile Throwable whatKilledSelectorThread;
    private boolean started = false;
    private final Object startedLock = new Object();
    private static final Logger LOGGER = Logger.getLogger(NioChannelHub.class.getName());

    public NioChannelHub(ExecutorService commandProcessor) throws IOException {
        this.selector = Selector.open();
        this.commandProcessor = commandProcessor;
    }

    public void setFrameSize(int sz) {
        assert (0 < sz && sz <= Short.MAX_VALUE);
        this.transportFrameSize = sz;
    }

    public NioChannelBuilder newChannelBuilder(String name, ExecutorService es) {
        return new NioChannelBuilder(name, es){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected CommandTransport makeTransport(InputStream is, OutputStream os, Channel.Mode mode, Capability cap) throws IOException {
                if (this.r == null) {
                    this.r = NioChannelHub.this.factory.create(is);
                }
                if (this.w == null) {
                    this.w = NioChannelHub.this.factory.create(os);
                }
                if (this.r != null && this.w != null && mode == Channel.Mode.BINARY && cap.supportsChunking()) {
                    try {
                        Object object = NioChannelHub.this.startedLock;
                        synchronized (object) {
                            while (!NioChannelHub.this.started) {
                                NioChannelHub.this.startedLock.wait();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                    if (NioChannelHub.this.selectorThread == null) {
                        throw new IOException("NioChannelHub is not currently running", NioChannelHub.this.whatKilledSelectorThread);
                    }
                    NioTransport t = this.r == this.w ? new MonoNioTransport(this.getName(), this.r, cap) : new DualNioTransport(this.getName(), this.r, this.w, cap);
                    t.scheduleReregister();
                    return t;
                }
                return super.makeTransport(is, os, mode, cap);
            }
        };
    }

    private void scheduleSelectorTask(Callable<Void, IOException> task) {
        this.selectorTasks.add(task);
        this.selector.wakeup();
    }

    @Override
    public void close() throws IOException {
        this.selector.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block32: {
            var1_1 = this.startedLock;
            synchronized (var1_1) {
                this.started = true;
                this.startedLock.notifyAll();
            }
            this.selectorThread = Thread.currentThread();
            oldName = this.selectorThread.getName();
            try {
                block18: while (true) {
                    block31: {
                        try {
                            while (true) lbl-1000:
                            // 3 sources

                            {
                                if ((t = this.selectorTasks.poll()) == null) {
                                    this.selectorThread.setName("NioChannelHub keys=" + this.selector.keys().size() + " gen=" + this.gen++ + ": " + oldName);
                                    this.selector.select();
                                    break block31;
                                }
                                try {
                                    t.call();
                                }
                                catch (IOException e) {
                                    NioChannelHub.LOGGER.log(Level.WARNING, "Failed to process selectorTasks", e);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException e) {
                            NioChannelHub.LOGGER.log(Level.WARNING, "Failed to select", e);
                            this.abortAll(e);
                            this.selectorThread.setName(oldName);
                            this.selectorThread = null;
                            return;
                        }
                        ** GOTO lbl-1000
                    }
                    itr = this.selector.selectedKeys().iterator();
                    while (true) {
                        block33: {
                            if (!itr.hasNext()) continue block18;
                            key = itr.next();
                            itr.remove();
                            a = key.attachment();
                            if (!(a instanceof NioTransport)) break block33;
                            t = (NioTransport)a;
                            try {
                                if (!key.isReadable()) ** GOTO lbl69
                                if (t.rb.receive(t.rr()) == -1) {
                                    t.closeR();
                                }
                                buf = new byte[2];
                                pos = 0;
                                packetSize = 0;
lbl47:
                                // 2 sources

                                while (true) {
                                    block35: {
                                        block36: {
                                            block34: {
                                                if (t.rb.peek(pos, buf) >= buf.length) break block34;
                                                if (t.rb.writable() != 0) break block35;
                                                break block36;
                                            }
                                            header = ChunkHeader.parse(buf);
                                            chunk = ChunkHeader.length(header);
                                            packetSize += chunk;
                                            last = ChunkHeader.isLast(header);
                                            if (!last || (pos += buf.length + chunk) > t.rb.readable()) continue;
                                            packet = new byte[packetSize];
                                            r_ptr = 0;
                                            break block32;
                                        }
                                        if (t.rb.readable() > 0) {
                                            msg = "Command buffer overflow. Read " + t.rb.readable() + " bytes but still too small for a single command";
                                            NioChannelHub.LOGGER.log(Level.WARNING, msg);
                                            t.abort(new IOException(msg));
                                        }
                                    }
                                    if (t.rb.isClosed()) {
                                        NioTransport.access$1100(t).submit(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (!t.getChannel().isInClosed()) {
                                                    t.getChannel().terminate(new EOFException());
                                                }
                                            }
                                        });
                                    }
lbl69:
                                    // 4 sources

                                    if (key.isValid() && key.isWritable()) {
                                        t.wb.send(t.ww());
                                        if (t.wb.readable() < 0) {
                                            t.closeW();
                                        }
                                    }
                                    t.reregister();
                                    break;
                                }
                            }
                            catch (IOException e) {
                                NioChannelHub.LOGGER.log(Level.WARNING, "Communication problem", e);
                                t.abort(e);
                            }
                            catch (CancelledKeyException e) {
                                NioChannelHub.LOGGER.log(Level.SEVERE, "Unexpected key cancellation for " + t, e);
                                t.abort(e);
                            }
                            continue;
                        }
                        this.onSelected(key);
                    }
                    break;
                }
            }
            catch (ClosedSelectorException e) {
                this.whatKilledSelectorThread = e;
                return;
            }
            catch (RuntimeException e) {
                this.abortAll(e);
                NioChannelHub.LOGGER.log(Level.WARNING, "Unexpected shutdown of the selector thread", e);
                this.whatKilledSelectorThread = e;
                throw e;
            }
            catch (Error e) {
                this.abortAll(e);
                NioChannelHub.LOGGER.log(Level.WARNING, "Unexpected shutdown of the selector thread", e);
                this.whatKilledSelectorThread = e;
                throw e;
            }
            finally {
                this.selectorThread.setName(oldName);
                this.selectorThread = null;
            }
        }
        do {
            r = t.rb.readNonBlocking(buf);
            if (!NioChannelHub.$assertionsDisabled && r != buf.length) {
                throw new AssertionError();
            }
            header = ChunkHeader.parse(buf);
            chunk = ChunkHeader.length(header);
            last = ChunkHeader.isLast(header);
            t.rb.readNonBlocking(packet, r_ptr, chunk);
            packetSize -= chunk;
            r_ptr += chunk;
        } while (!last);
        if (!NioChannelHub.$assertionsDisabled && packetSize != 0) {
            throw new AssertionError();
        }
        NioTransport.access$1100(t).submit(new Runnable(){

            @Override
            public void run() {
                t.receiver.handle(packet);
            }
        });
        pos = 0;
        ** while (true)
    }

    protected void onSelected(SelectionKey key) {
    }

    private void abortAll(Throwable e) {
        HashSet<NioTransport> pairs = new HashSet<NioTransport>();
        for (SelectionKey k : this.selector.keys()) {
            pairs.add((NioTransport)k.attachment());
        }
        for (NioTransport p : pairs) {
            p.abort(e);
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void ensureValid() throws IOException {
        if (this.selectorThread == null) {
            throw new IOException("NIO selector thread is not running", this.whatKilledSelectorThread);
        }
    }

    static /* synthetic */ ExecutorService access$000(NioChannelHub x0) {
        return x0.commandProcessor;
    }

    class DualNioTransport
    extends NioTransport {
        private final SelectableChannel r;
        private final SelectableChannel w;

        DualNioTransport(String name, SelectableChannel r, SelectableChannel w, Capability remoteCapability) {
            super(name, remoteCapability);
            assert (r instanceof ReadableByteChannel && w instanceof WritableByteChannel);
            this.r = r;
            this.w = w;
        }

        @Override
        ReadableByteChannel rr() {
            return (ReadableByteChannel)((Object)this.r);
        }

        @Override
        WritableByteChannel ww() {
            return (WritableByteChannel)((Object)this.w);
        }

        @Override
        boolean isWopen() {
            return this.w.isOpen();
        }

        @Override
        boolean isRopen() {
            return this.r.isOpen();
        }

        @Override
        void closeR() throws IOException {
            this.r.close();
            this.rb.close();
            this.cancelKey(this.r);
        }

        @Override
        void closeW() throws IOException {
            this.w.close();
            this.wb.close();
            this.cancelKey(this.w);
        }

        @Override
        public void reregister() throws IOException {
            if (this.isRopen()) {
                this.r.configureBlocking(false);
                this.r.register(NioChannelHub.this.selector, this.wantsToRead() ? 1 : 0).attach(this);
            }
            if (this.isWopen()) {
                this.w.configureBlocking(false);
                this.w.register(NioChannelHub.this.selector, this.wantsToWrite() ? 4 : 0).attach(this);
            }
        }

        private void cancelKey(SelectableChannel c) {
            assert (c == this.r || c == this.w);
            this.cancelKey(c.keyFor(NioChannelHub.this.selector));
        }
    }

    class MonoNioTransport
    extends NioTransport {
        private final SelectableChannel ch;
        Closeable rc;
        Closeable wc;

        MonoNioTransport(String name, SelectableChannel ch, Capability remoteCapability) {
            super(name, remoteCapability);
            this.ch = ch;
            this.rc = Closeables.input(ch);
            this.wc = Closeables.output(ch);
        }

        @Override
        ReadableByteChannel rr() {
            return (ReadableByteChannel)((Object)this.ch);
        }

        @Override
        WritableByteChannel ww() {
            return (WritableByteChannel)((Object)this.ch);
        }

        @Override
        boolean isWopen() {
            return this.wc != null;
        }

        @Override
        boolean isRopen() {
            return this.rc != null;
        }

        @Override
        void closeR() throws IOException {
            if (this.rc != null) {
                this.rc.close();
                this.rc = null;
                this.rb.close();
                this.maybeCancelKey();
            }
        }

        @Override
        void closeW() throws IOException {
            if (this.wc != null) {
                this.wc.close();
                this.wc = null;
                this.wb.close();
                this.maybeCancelKey();
            }
        }

        @Override
        public void reregister() throws IOException {
            int flag = (this.wantsToWrite() && this.isWopen() ? 4 : 0) + (this.wantsToRead() && this.isRopen() ? 1 : 0);
            if (this.ch.isOpen()) {
                this.ch.configureBlocking(false);
                this.ch.register(NioChannelHub.this.selector, flag).attach(this);
            }
        }

        private void maybeCancelKey() throws IOException {
            SelectionKey key = this.ch.keyFor(NioChannelHub.this.selector);
            if (this.rc == null && this.wc == null) {
                this.cancelKey(key);
            } else {
                this.reregister();
            }
        }
    }

    abstract class NioTransport
    extends AbstractByteArrayCommandTransport {
        private final Capability remoteCapability;
        final FifoBuffer rb = new FifoBuffer(16384, Integer.MAX_VALUE);
        final FifoBuffer wb = new FifoBuffer(16384, 262144);
        private AbstractByteArrayCommandTransport.ByteArrayReceiver receiver;
        private final SingleLaneExecutorService swimLane = new SingleLaneExecutorService(NioChannelHub.access$000(NioChannelHub.this));
        private final String name;

        NioTransport(String name, Capability remoteCapability) {
            this.name = name;
            this.remoteCapability = remoteCapability;
        }

        abstract ReadableByteChannel rr();

        abstract WritableByteChannel ww();

        public abstract void reregister() throws IOException;

        boolean wantsToRead() {
            return this.receiver != null && this.rb.writable() != 0;
        }

        boolean wantsToWrite() {
            return this.wb.readable() != 0;
        }

        abstract boolean isWopen();

        abstract boolean isRopen();

        abstract void closeR() throws IOException;

        abstract void closeW() throws IOException;

        protected final void cancelKey(SelectionKey key) {
            if (key != null) {
                key.cancel();
            }
        }

        protected Channel getChannel() {
            return this.channel;
        }

        public void abort(Throwable e) {
            try {
                this.closeR();
            }
            catch (IOException _) {
                // empty catch block
            }
            try {
                this.closeW();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receiver.terminate((IOException)new IOException("Connection aborted: " + this).initCause(e));
        }

        @Override
        public void writeBlock(Channel channel, byte[] bytes) throws IOException {
            try {
                boolean hasMore;
                int pos = 0;
                do {
                    int frame;
                    hasMore = (frame = Math.min(NioChannelHub.this.transportFrameSize, bytes.length - pos)) + pos < bytes.length;
                    this.wb.write(ChunkHeader.pack(frame, hasMore));
                    this.wb.write(bytes, pos, frame);
                    this.scheduleReregister();
                    pos += frame;
                } while (hasMore);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }

        @Override
        public void setup(AbstractByteArrayCommandTransport.ByteArrayReceiver receiver) {
            this.receiver = receiver;
            this.scheduleReregister();
        }

        @Override
        public Capability getRemoteCapability() throws IOException {
            return this.remoteCapability;
        }

        @Override
        public void closeWrite() throws IOException {
            this.wb.close();
        }

        @Override
        public void closeRead() throws IOException {
            NioChannelHub.this.scheduleSelectorTask(new Callable<Void, IOException>(){

                @Override
                public Void call() throws IOException {
                    NioTransport.this.closeR();
                    return null;
                }

                @Override
                public void checkRoles(RoleChecker checker) throws SecurityException {
                    throw new AssertionError();
                }
            });
        }

        private void scheduleReregister() {
            NioChannelHub.this.scheduleSelectorTask(new Callable<Void, IOException>(){

                @Override
                public Void call() throws IOException {
                    NioTransport.this.reregister();
                    return null;
                }

                @Override
                public void checkRoles(RoleChecker checker) throws SecurityException {
                    throw new AssertionError();
                }
            });
        }

        public String toString() {
            return super.toString() + "[name=" + this.name + "]";
        }

        static /* synthetic */ SingleLaneExecutorService access$1100(NioTransport x0) {
            return x0.swimLane;
        }
    }
}

