/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.Checksum;
import hudson.remoting.DumbClassLoaderBridge;
import hudson.remoting.Future;
import hudson.remoting.RemoteInvocationHandler;
import hudson.remoting.RemotingSystemException;
import hudson.remoting.ResourceImageBoth;
import hudson.remoting.ResourceImageDirect;
import hudson.remoting.ResourceImageInJar;
import hudson.remoting.ResourceImageRef;
import hudson.remoting.URLish;
import hudson.remoting.Util;
import hudson.remoting.Which;
import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.ConstantPoolScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

@SuppressFBWarnings(value={"DMI_COLLECTION_OF_URLS", "DMI_BLOCKING_METHODS_ON_URL", "SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Since this is based on the URLClassLoader, it is difficult to switch to URIs. We have no indication this causes noticeable resource issues. The implementations here and in URL reduce the impact.")
final class RemoteClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = Logger.getLogger(RemoteClassLoader.class.getName());
    static Interruptible TESTING_CLASS_LOAD;
    static Interruptible TESTING_CLASS_REFERENCE_LOAD;
    static Interruptible TESTING_RESOURCE_LOAD;
    static int RETRY_SLEEP_DURATION_MILLISECONDS;
    static int MAX_RETRIES;
    private final IClassLoader proxy;
    private final Object underlyingProxy;
    private Channel.Ref channel;
    private final Map<String, URLish> resourceMap = new HashMap<String, URLish>();
    private final Map<String, Vector<URLish>> resourcesMap = new HashMap<String, Vector<URLish>>();
    private final Set<URL> prefetchedJars = new HashSet<URL>();
    private final Map<String, ClassReference> prefetchedClasses = Collections.synchronizedMap(new HashMap());
    public static boolean USE_BOOTSTRAP_CLASSLOADER;
    private static final Enumeration<URL> EMPTY_ENUMERATION;

    @NonNull
    public static ClassLoader create(@CheckForNull ClassLoader parent, @NonNull IClassLoader proxy) {
        if (proxy instanceof ClassLoaderProxy) {
            return ((ClassLoaderProxy)proxy).cl;
        }
        return new RemoteClassLoader(parent, proxy);
    }

    private RemoteClassLoader(@CheckForNull ClassLoader parent, @NonNull IClassLoader proxy) {
        super(new URL[0], parent);
        Channel channel = RemoteInvocationHandler.unwrap(proxy);
        this.channel = channel == null ? null : channel.ref();
        this.underlyingProxy = proxy;
        if (channel == null || !channel.remoteCapability.supportsPrefetch() || channel.getJarCache() == null) {
            proxy = new DumbClassLoaderBridge(proxy);
        }
        this.proxy = proxy;
    }

    @CheckForNull
    private Channel channel() {
        return this.channel == null ? null : this.channel.channel();
    }

    int getOid(Channel channel) {
        return RemoteInvocationHandler.unwrap(this.underlyingProxy, channel);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            Channel channel = this.channel();
            if (channel == null || !channel.isRemoteClassLoadingAllowed()) {
                throw e;
            }
            if (channel.remoteCapability.supportsMultiClassLoaderRPC()) {
                return this.loadWithMultiClassLoader(name, channel);
            }
            return this.fetchFromProxy(name, channel);
        }
    }

    private Class<?> fetchFromProxy(String name, Channel channel) throws ClassNotFoundException {
        long startTime = System.nanoTime();
        byte[] bytes = this.proxy.fetch(name);
        channel.classLoadingTime.addAndGet(System.nanoTime() - startTime);
        channel.classLoadingCount.incrementAndGet();
        return this.loadClassFile(name, bytes);
    }

    private Class<?> loadWithMultiClassLoader(String name, Channel channel) throws ClassNotFoundException {
        ClassReference cr;
        long startTime = System.nanoTime();
        if (channel.remoteCapability.supportsPrefetch()) {
            cr = this.prefetchClassReference(name, channel);
        } else {
            LOGGER.log(Level.FINER, "fetch2 on {0}", name);
            cr = new ClassReference(channel, this.proxy.fetch2(name));
        }
        channel.classLoadingTime.addAndGet(System.nanoTime() - startTime);
        channel.classLoadingCount.incrementAndGet();
        ClassLoader cl = cr.classLoader;
        if (cl instanceof RemoteClassLoader) {
            RemoteClassLoader rcl = (RemoteClassLoader)cl;
            return this.loadRemoteClass(name, channel, cr, rcl);
        }
        return cl.loadClass(name);
    }

    private Class<?> loadRemoteClass(String name, Channel channel, ClassReference cr, RemoteClassLoader rcl) throws ClassNotFoundException {
        Object object = rcl.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = rcl.findLoadedClass(name);
            int tries = 0;
            while (true) {
                try {
                    this.invokeClassLoadTestingHookIfNeeded();
                    if (c != null) {
                        return c;
                    }
                    Future<byte[]> img = cr.classImage.resolve(channel, name.replace('.', '/') + ".class");
                    if (img.isDone()) {
                        try {
                            return rcl.loadClassFile(name, (byte[])img.get());
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                    }
                    return rcl.loadClassFile(name, this.proxy.fetch(name));
                }
                catch (IOException x) {
                    throw new ClassNotFoundException(name, x);
                }
                catch (RemotingSystemException | InterruptedException x) {
                    if (this.shouldRetry(x, ++tries)) {
                        this.sleepForRetry();
                        LOGGER.finer("Handling interrupt while loading remote class. Current retry count = " + tries + ", maximum = " + MAX_RETRIES);
                        continue;
                    }
                    throw new ClassNotFoundException("Could not load class " + name + " after " + tries + " tries.");
                }
                break;
            }
        }
    }

    private void invokeClassLoadTestingHookIfNeeded() throws InterruptedException {
        if (TESTING_CLASS_LOAD != null) {
            TESTING_CLASS_LOAD.run();
        }
    }

    private boolean shouldRetry(Throwable e, int tries) {
        return this.isRetryException(e) && this.hasMoreRetries(tries);
    }

    private boolean hasMoreRetries(int tries) {
        return MAX_RETRIES <= 0 || tries <= MAX_RETRIES;
    }

    private boolean isRetryException(Throwable e) {
        return e instanceof InterruptedException || e instanceof RemotingSystemException && (e.getCause() instanceof InterruptedException || e.getCause() instanceof InterruptedIOException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassReference prefetchClassReference(String name, final Channel channel) throws ClassNotFoundException {
        ClassReference cr = this.prefetchedClasses.remove(name);
        if (cr == null) {
            LOGGER.log(Level.FINER, "fetch3({0})", name);
            int tries = 0;
            while (true) {
                try {
                    this.invokeClassReferenceLoadTestingHookIfNeeded();
                    Map<String, ClassFile2> all = this.proxy.fetch3(name);
                    Map<String, ClassReference> map = this.prefetchedClasses;
                    synchronized (map) {
                        class ClassReferenceBuilder {
                            private final Map<Integer, ClassLoader> classLoaders = new HashMap<Integer, ClassLoader>();

                            ClassReferenceBuilder() {
                            }

                            ClassReference toRef(ClassFile2 cf) {
                                int n = cf.classLoader;
                                ClassLoader cl = this.classLoaders.get(n);
                                if (cl == null) {
                                    cl = channel.importedClassLoaders.get(n);
                                    this.classLoaders.put(n, cl);
                                }
                                return new ClassReference(cl, cf.image);
                            }
                        }
                        ClassReferenceBuilder crf = new ClassReferenceBuilder();
                        for (Map.Entry<String, ClassFile2> entry : all.entrySet()) {
                            String cn = entry.getKey();
                            ClassFile2 cf = entry.getValue();
                            ClassReference ref = crf.toRef(cf);
                            if (cn.equals(name)) {
                                cr = ref;
                            } else {
                                if (cf.referer != null) {
                                    ref.rememberIn(cn, crf.toRef((ClassFile2)cf.referer).classLoader);
                                } else {
                                    ref.rememberIn(cn, this);
                                }
                                LOGGER.log(Level.FINER, "prefetch {0} -> {1}", new Object[]{name, cn});
                            }
                            ref.rememberIn(cn, ref.classLoader);
                        }
                    }
                }
                catch (RemotingSystemException | InterruptedException x) {
                    if (this.shouldRetry(x, ++tries)) {
                        this.sleepForRetry();
                        LOGGER.finer("Handling interrupt while fetching class reference. Current retry count = " + tries + ", maximum = " + MAX_RETRIES);
                        continue;
                    }
                    throw this.determineRemotingSystemException(x);
                }
                break;
            }
            assert (cr != null);
        } else {
            LOGGER.log(Level.FINER, "findClass({0}) -> prefetch hit", name);
            channel.classLoadingPrefetchCacheCount.incrementAndGet();
        }
        return cr;
    }

    private void invokeClassReferenceLoadTestingHookIfNeeded() throws InterruptedException {
        if (TESTING_CLASS_REFERENCE_LOAD != null) {
            TESTING_CLASS_REFERENCE_LOAD.run();
        }
    }

    private Class<?> loadClassFile(String name, byte[] bytes) throws LinkageError {
        if (bytes.length < 8) {
            throw new ClassFormatError(name + " is <8 bytes long");
        }
        short bytecodeLevel = (short)((bytes[6] << 8) + (bytes[7] & 0xFF) - 44);
        Channel channel = this.channel();
        if (channel != null && bytecodeLevel > channel.maximumBytecodeLevel) {
            throw new UnsupportedClassVersionError("this channel is restricted to JDK 1." + channel.maximumBytecodeLevel + " compatibility but " + name + " was compiled for 1." + bytecodeLevel);
        }
        this.prefetchedClasses.remove(name);
        this.definePackage(name);
        try {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (UnsupportedClassVersionError e) {
            throw (UnsupportedClassVersionError)new UnsupportedClassVersionError("Failed to load " + name).initCause(e);
        }
        catch (ClassFormatError e) {
            throw (ClassFormatError)new ClassFormatError("Failed to load " + name).initCause(e);
        }
        catch (LinkageError e) {
            throw new LinkageError("Failed to load " + name, e);
        }
    }

    private void definePackage(String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return;
        }
        String packageName = name.substring(0, idx);
        if (this.getPackage(packageName) != null) {
            return;
        }
        this.definePackage(packageName, null, null, null, null, null, null, null);
    }

    @Override
    @CheckForNull
    public URL findResource(String name) {
        URL url = super.findResource(name);
        Channel channel = this.channel();
        if (url != null || channel == null || !channel.isRemoteClassLoadingAllowed()) {
            return url;
        }
        int tries = 0;
        while (true) {
            try {
                if (this.resourceMap.containsKey(name)) {
                    URLish f = this.resourceMap.get(name);
                    if (f == null) {
                        return null;
                    }
                    URL u = f.toURL();
                    if (u != null) {
                        return u;
                    }
                }
                this.invokeResourceLoadTestingHookIfNeeded();
                long startTime = System.nanoTime();
                ResourceFile r = this.proxy.getResource2(name);
                ResourceImageRef image = null;
                if (r != null) {
                    image = r.image;
                }
                channel.resourceLoadingTime.addAndGet(System.nanoTime() - startTime);
                channel.resourceLoadingCount.incrementAndGet();
                if (image == null) {
                    this.resourceMap.put(name, null);
                    return null;
                }
                URLish res = (URLish)image.resolveURL(channel, name).get();
                this.resourceMap.put(name, res);
                return res.toURL();
            }
            catch (IOException | ExecutionException e) {
                throw new Error("Unable to load resource " + name, e);
            }
            catch (RemotingSystemException | InterruptedException x) {
                if (this.shouldRetry(x, ++tries)) {
                    this.sleepForRetry();
                    LOGGER.finer("Handling interrupt while finding resource. Current retry count = " + tries + ", maximum = " + MAX_RETRIES);
                    continue;
                }
                throw this.determineRemotingSystemException(x);
            }
            break;
        }
    }

    private RemotingSystemException determineRemotingSystemException(Exception x) {
        return x instanceof RemotingSystemException ? (RemotingSystemException)x : new RemotingSystemException(x);
    }

    private void invokeResourceLoadTestingHookIfNeeded() throws InterruptedException {
        if (TESTING_RESOURCE_LOAD != null) {
            TESTING_RESOURCE_LOAD.run();
        }
    }

    @CheckForNull
    private static Vector<URL> toURLs(Vector<URLish> src) throws MalformedURLException {
        Vector<URL> r = new Vector<URL>(src.size());
        for (URLish s : src) {
            URL u = s.toURL();
            if (u == null) {
                return null;
            }
            r.add(u);
        }
        return r;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Channel channel = this.channel();
        if (channel == null || !channel.isRemoteClassLoadingAllowed()) {
            return EMPTY_ENUMERATION;
        }
        int tries = 0;
        while (true) {
            try {
                Vector<URL> urls;
                Vector<URLish> v = this.resourcesMap.get(name);
                if (v != null && (urls = RemoteClassLoader.toURLs(v)) != null) {
                    return urls.elements();
                }
                this.invokeResourceLoadTestingHookIfNeeded();
                long startTime = System.nanoTime();
                ResourceFile[] images = this.proxy.getResources2(name);
                channel.resourceLoadingTime.addAndGet(System.nanoTime() - startTime);
                channel.resourceLoadingCount.incrementAndGet();
                v = new Vector();
                for (ResourceFile image : images) {
                    try {
                        v.add((URLish)image.image.resolveURL(channel, name).get());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new Error("Failed to load resources " + name, e);
                    }
                    catch (ExecutionException e) {
                        throw new Error("Failed to load resources " + name, e);
                    }
                }
                this.resourcesMap.put(name, v);
                Vector<URL> resURLs = RemoteClassLoader.toURLs(v);
                if (resURLs == null) {
                    throw new IOException("One of the URLish objects cannot be converted to URL");
                }
                return resURLs.elements();
            }
            catch (RemotingSystemException | InterruptedException x) {
                if (this.shouldRetry(x, ++tries)) {
                    this.sleepForRetry();
                    LOGGER.finer("Handling interrupt while finding resource. Current retry count = " + tries + ", maximum = " + MAX_RETRIES);
                    continue;
                }
                throw this.determineRemotingSystemException(x);
            }
            break;
        }
    }

    private void sleepForRetry() {
        try {
            if (RETRY_SLEEP_DURATION_MILLISECONDS > 0) {
                Thread.sleep(RETRY_SLEEP_DURATION_MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void deleteDirectoryOnExit(File dir) {
        Util.deleteDirectoryOnExit(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean prefetch(URL jar) throws IOException {
        Set<URL> set = this.prefetchedJars;
        synchronized (set) {
            if (this.prefetchedJars.contains(jar)) {
                return false;
            }
            String p = jar.getPath().replace('\\', '/');
            p = Util.getBaseName(p);
            File localJar = Util.makeResource(p, this.proxy.fetchJar(jar));
            this.addURL(localJar.toURI().toURL());
            this.prefetchedJars.add(jar);
            return true;
        }
    }

    public static IClassLoader export(@NonNull ClassLoader cl, @NonNull Channel local) {
        if (cl instanceof RemoteClassLoader) {
            RemoteClassLoader rcl = (RemoteClassLoader)cl;
            int oid = RemoteInvocationHandler.unwrap(rcl.underlyingProxy, local);
            if (oid != -1) {
                return new RemoteIClassLoader(oid, rcl.proxy);
            }
        }
        return local.export(IClassLoader.class, new ClassLoaderProxy(cl, local), false, false, false);
    }

    public static void pin(ClassLoader cl, Channel local) {
        if (cl instanceof RemoteClassLoader) {
            RemoteClassLoader rcl = (RemoteClassLoader)cl;
            int oid = RemoteInvocationHandler.unwrap(rcl.proxy, local);
            if (oid != -1) {
                return;
            }
        }
        local.pin(new ClassLoaderProxy(cl, local));
    }

    static int exportId(ClassLoader cl, Channel local) {
        return local.internalExport(IClassLoader.class, new ClassLoaderProxy(cl, local), false);
    }

    private static Iterable<String> analyze(InputStream bytecode) {
        try {
            return ConstantPoolScanner.dependencies(bytecode);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "could not parse bytecode", x);
            return Collections.emptySet();
        }
    }

    static {
        RETRY_SLEEP_DURATION_MILLISECONDS = Integer.getInteger(RemoteClassLoader.class.getName() + "retrySleepDurationMilliseconds", 100);
        MAX_RETRIES = Integer.getInteger(RemoteClassLoader.class.getName() + "maxRetries", 6000);
        USE_BOOTSTRAP_CLASSLOADER = Boolean.getBoolean(RemoteClassLoader.class.getName() + ".useBootstrapClassLoader");
        EMPTY_ENUMERATION = new Vector().elements();
    }

    private static class RemoteIClassLoader
    implements IClassLoader,
    SerializableOnlyOverRemoting {
        private final transient IClassLoader proxy;
        private final int oid;
        private static final long serialVersionUID = 1L;

        private RemoteIClassLoader(int oid, IClassLoader proxy) {
            this.proxy = proxy;
            this.oid = oid;
        }

        @Override
        public byte[] fetchJar(URL url) throws IOException {
            return this.proxy.fetchJar(url);
        }

        @Override
        public byte[] fetch(String className) throws ClassNotFoundException {
            return this.proxy.fetch(className);
        }

        @Override
        public ClassFile fetch2(String className) throws ClassNotFoundException {
            return this.proxy.fetch2(className);
        }

        @Override
        public Map<String, ClassFile2> fetch3(String className) throws ClassNotFoundException {
            return this.proxy.fetch3(className);
        }

        @Override
        public byte[] getResource(String name) throws IOException {
            return this.proxy.getResource(name);
        }

        @Override
        @NonNull
        public byte[][] getResources(String name) throws IOException {
            return this.proxy.getResources(name);
        }

        @Override
        public ResourceFile getResource2(String name) throws IOException {
            return this.proxy.getResource2(name);
        }

        @Override
        @NonNull
        public ResourceFile[] getResources2(String name) throws IOException {
            return this.proxy.getResources2(name);
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                return this.getChannelForSerialization().getExportedObject(this.oid);
            }
            catch (ExecutionException ex) {
                throw new IllegalStateException("Cannot resolve remoting classloader", ex);
            }
        }
    }

    static final class ClassLoaderProxy
    implements IClassLoader {
        final ClassLoader cl;
        final Channel channel;
        private final Set<String> prefetched = new HashSet<String>();
        private static final ClassLoader PSEUDO_BOOTSTRAP = new URLClassLoader(new URL[0], null){

            public String toString() {
                return "PSEUDO_BOOTSTRAP";
            }
        };

        public ClassLoaderProxy(@NonNull ClassLoader cl, Channel channel) {
            this.cl = cl;
            this.channel = channel;
        }

        @Override
        @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="This is only used for managing the jar cache as files.")
        public byte[] fetchJar(URL url) throws IOException {
            return Util.readFully(url.openStream());
        }

        @Override
        public byte[] fetch(String className) throws ClassNotFoundException {
            if (!USE_BOOTSTRAP_CLASSLOADER && this.cl == PSEUDO_BOOTSTRAP) {
                throw new ClassNotFoundException("Classloading from bootstrap classloader disabled");
            }
            InputStream in = this.cl.getResourceAsStream(className.replace('.', '/') + ".class");
            if (in == null) {
                throw new ClassNotFoundException(className);
            }
            try {
                return Util.readFully(in);
            }
            catch (IOException e) {
                throw new ClassNotFoundException();
            }
        }

        @Override
        public ClassFile fetch2(String className) throws ClassNotFoundException {
            ClassLoader ecl = this.cl.loadClass(className).getClassLoader();
            if (ecl == null) {
                if (USE_BOOTSTRAP_CLASSLOADER) {
                    ecl = PSEUDO_BOOTSTRAP;
                } else {
                    throw new ClassNotFoundException("Classloading from system classloader disabled");
                }
            }
            try {
                InputStream in = ecl.getResourceAsStream(className.replace('.', '/') + ".class");
                if (in == null) {
                    throw new ClassNotFoundException(className + " (" + ecl + " did not find class file)");
                }
                return new ClassFile(RemoteClassLoader.exportId(ecl, this.channel), Util.readFully(in));
            }
            catch (IOException e) {
                throw new ClassNotFoundException();
            }
        }

        public ClassFile2 fetch4(String className, @CheckForNull ClassFile2 referer) throws ClassNotFoundException {
            Class<?> c;
            Class<?> referrerClass = referer == null ? null : referer.clazz;
            try {
                c = (referer == null ? this.cl : referer.clazz.getClassLoader()).loadClass(className);
            }
            catch (LinkageError e) {
                throw new LinkageError("Failed to load " + className + " via " + referrerClass, e);
            }
            ClassLoader ecl = c.getClassLoader();
            if (ecl == null) {
                if (USE_BOOTSTRAP_CLASSLOADER) {
                    ecl = PSEUDO_BOOTSTRAP;
                } else {
                    throw new ClassNotFoundException("Bootstrap pseudo-classloader disabled: " + className + " via " + referrerClass);
                }
            }
            try {
                URL urlOfClassFile = Which.classFileUrl(c);
                try {
                    File jar = Which.jarFile(c);
                    if (jar.isFile()) {
                        Checksum sum = this.channel.jarLoader.calcChecksum(jar);
                        ResourceImageRef imageRef = referer == null && !this.channel.jarLoader.isPresentOnRemote(sum) ? new ResourceImageBoth(urlOfClassFile, sum) : new ResourceImageInJar(sum, null);
                        return new ClassFile2(RemoteClassLoader.exportId(ecl, this.channel), imageRef, referer, c, urlOfClassFile);
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.FINE, c + " isn't in a jar file: " + urlOfClassFile, e);
                }
                return this.fetch2(className).upconvert(referer, c, urlOfClassFile);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Failed to load " + className + " via " + referrerClass, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="This is only used for managing the jar cache as files.")
        public Map<String, ClassFile2> fetch3(String className) throws ClassNotFoundException {
            ClassFile2 cf = this.fetch4(className, null);
            HashMap<String, ClassFile2> all = new HashMap<String, ClassFile2>();
            all.put(className, cf);
            Set<String> set = this.prefetched;
            synchronized (set) {
                this.prefetched.add(className);
            }
            try {
                for (String other : RemoteClassLoader.analyze(cf.local.openStream())) {
                    Set<String> set2 = this.prefetched;
                    synchronized (set2) {
                        if (!this.prefetched.add(other)) {
                            continue;
                        }
                    }
                    try {
                        all.put(other, this.fetch4(other, cf));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (LinkageError linkageError) {}
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to analyze the class file: " + cf.local, e);
            }
            return all;
        }

        @CheckForNull
        private URL getResourceURL(String name) {
            URL systemResource;
            URL resource = this.cl.getResource(name);
            if (resource == null) {
                return null;
            }
            if (!USE_BOOTSTRAP_CLASSLOADER && resource.equals(systemResource = PSEUDO_BOOTSTRAP.getResource(name))) {
                return null;
            }
            return resource;
        }

        @Override
        @CheckForNull
        public ResourceFile getResource2(String name) throws IOException {
            URL resource = this.getResourceURL(name);
            if (resource == null) {
                return null;
            }
            return this.makeResource(name, resource);
        }

        private ResourceFile makeResource(String name, URL resource) throws IOException {
            try {
                File jar = Which.jarFile(resource, name);
                if (jar.isFile()) {
                    Checksum sum = this.channel.jarLoader.calcChecksum(jar);
                    ResourceImageRef ir = !this.channel.jarLoader.isPresentOnRemote(sum) ? new ResourceImageBoth(resource, sum) : new ResourceImageInJar(sum, null);
                    return new ResourceFile(ir, resource);
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.FINE, name + " isn't in a jar file: " + resource, e);
            }
            return new ResourceFile(resource);
        }

        @Override
        @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Null return value is a part of the public interface")
        @CheckForNull
        public byte[] getResource(String name) throws IOException {
            URL resource = this.getResourceURL(name);
            if (resource == null) {
                return null;
            }
            return Util.readFully(resource.openStream());
        }

        public List<URL> getResourcesURL(String name) throws IOException {
            Enumeration<URL> e;
            ArrayList<URL> images = new ArrayList<URL>();
            HashSet<URL> systemResources = null;
            if (!USE_BOOTSTRAP_CLASSLOADER) {
                systemResources = new HashSet<URL>();
                e = PSEUDO_BOOTSTRAP.getResources(name);
                while (e.hasMoreElements()) {
                    systemResources.add(e.nextElement());
                }
            }
            e = this.cl.getResources(name);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if (systemResources != null && systemResources.contains(url)) continue;
                images.add(url);
            }
            return images;
        }

        @Override
        @NonNull
        public byte[][] getResources(String name) throws IOException {
            List<URL> x = this.getResourcesURL(name);
            byte[][] r = new byte[x.size()][];
            for (int i = 0; i < r.length; ++i) {
                r[i] = Util.readFully(x.get(i).openStream());
            }
            return r;
        }

        @Override
        @NonNull
        public ResourceFile[] getResources2(String name) throws IOException {
            List<URL> x = this.getResourcesURL(name);
            ResourceFile[] r = new ResourceFile[x.size()];
            for (int i = 0; i < r.length; ++i) {
                r[i] = this.makeResource(name, x.get(i));
            }
            return r;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            return this.cl.equals(((ClassLoaderProxy)that).cl);
        }

        public int hashCode() {
            return this.cl.hashCode();
        }

        public String toString() {
            return super.toString() + "[" + this.cl + "]";
        }
    }

    public static interface IClassLoader {
        public byte[] fetchJar(URL var1) throws IOException;

        public byte[] fetch(String var1) throws ClassNotFoundException;

        public ClassFile fetch2(String var1) throws ClassNotFoundException;

        @CheckForNull
        public byte[] getResource(String var1) throws IOException;

        @NonNull
        public byte[][] getResources(String var1) throws IOException;

        public Map<String, ClassFile2> fetch3(String var1) throws ClassNotFoundException;

        @CheckForNull
        public ResourceFile getResource2(String var1) throws IOException;

        @NonNull
        public ResourceFile[] getResources2(String var1) throws IOException;
    }

    public static class ClassFile2
    extends ResourceFile {
        final int classLoader;
        final ClassFile2 referer;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="We're fine with the default null on the recipient side")
        final transient Class<?> clazz;
        private static final long serialVersionUID = 1L;

        ClassFile2(int classLoader, ResourceImageRef image, ClassFile2 referer, Class<?> clazz, URL local) {
            super(image, local);
            this.classLoader = classLoader;
            this.clazz = clazz;
            this.referer = referer;
        }
    }

    public static class ResourceFile
    implements Serializable {
        final ResourceImageRef image;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="We're fine with the default null on the recipient side")
        final transient URL local;
        private static final long serialVersionUID = 1L;

        ResourceFile(URL local) throws IOException {
            this(new ResourceImageDirect(local), local);
        }

        ResourceFile(ResourceImageRef image, URL local) {
            this.image = image;
            this.local = local;
        }
    }

    public static class ClassFile
    implements Serializable {
        final int classLoader;
        final byte[] classImage;
        private static final long serialVersionUID = 1L;

        ClassFile(int classLoader, byte[] classImage) {
            this.classLoader = classLoader;
            this.classImage = classImage;
        }

        public ClassFile2 upconvert(ClassFile2 referer, Class<?> clazz, URL local) {
            return new ClassFile2(this.classLoader, new ResourceImageDirect(this.classImage), referer, clazz, local);
        }
    }

    static class ClassReference {
        final ClassLoader classLoader;
        final ResourceImageRef classImage;

        ClassReference(Channel channel, ClassFile wireFormat) {
            this.classLoader = channel.importedClassLoaders.get(wireFormat.classLoader);
            this.classImage = new ResourceImageDirect(wireFormat.classImage);
        }

        ClassReference(ClassLoader classLoader, ResourceImageRef classImage) {
            this.classLoader = classLoader;
            this.classImage = classImage;
        }

        void rememberIn(String className, ClassLoader cl) {
            if (cl instanceof RemoteClassLoader) {
                RemoteClassLoader rcl = (RemoteClassLoader)cl;
                rcl.prefetchedClasses.put(className, this);
            }
        }
    }

    static interface Interruptible {
        public void run() throws InterruptedException;
    }
}

