/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Launcher;
import hudson.remoting.NoProxyEvaluator;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.jenkinsci.remoting.engine.HostPort;
import org.jenkinsci.remoting.engine.JnlpAgentEndpoint;
import org.jenkinsci.remoting.engine.JnlpEndpointResolver;
import org.jenkinsci.remoting.util.ThrowableUtils;
import org.jenkinsci.remoting.util.VersionNumber;
import org.jenkinsci.remoting.util.https.NoCheckHostnameVerifier;
import org.jenkinsci.remoting.util.https.NoCheckTrustManager;

public class JnlpAgentEndpointResolver
extends JnlpEndpointResolver {
    private static final Logger LOGGER = Logger.getLogger(JnlpAgentEndpointResolver.class.getName());
    @NonNull
    private final List<String> jenkinsUrls;
    private SSLSocketFactory sslSocketFactory;
    private String credentials;
    private String proxyCredentials;
    private String tunnel;
    private boolean disableHttpsCertValidation;
    private static String PROTOCOL_NAMES_TO_TRY = System.getProperty(JnlpAgentEndpointResolver.class.getName() + ".protocolNamesToTry");

    public JnlpAgentEndpointResolver(String ... jenkinsUrls) {
        this.jenkinsUrls = new ArrayList<String>(Arrays.asList(jenkinsUrls));
    }

    public JnlpAgentEndpointResolver(@NonNull List<String> jenkinsUrls) {
        this(jenkinsUrls, null, null, null, null, false);
    }

    public JnlpAgentEndpointResolver(List<String> jenkinsUrls, String credentials, String proxyCredentials, String tunnel, SSLSocketFactory sslSocketFactory, boolean disableHttpsCertValidation) {
        this.jenkinsUrls = new ArrayList<String>(jenkinsUrls);
        this.credentials = credentials;
        this.proxyCredentials = proxyCredentials;
        this.tunnel = tunnel;
        this.sslSocketFactory = sslSocketFactory;
        this.disableHttpsCertValidation = disableHttpsCertValidation;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void setCredentials(String user, String pass) {
        this.credentials = user + ":" + pass;
    }

    public String getProxyCredentials() {
        return this.proxyCredentials;
    }

    public void setProxyCredentials(String proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
    }

    public void setProxyCredentials(String user, String pass) {
        this.proxyCredentials = user + ":" + pass;
    }

    @CheckForNull
    public String getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(@CheckForNull String tunnel) {
        this.tunnel = tunnel;
    }

    public boolean isDisableHttpsCertValidation() {
        return this.disableHttpsCertValidation;
    }

    public void setDisableHttpsCertValidation(boolean disableHttpsCertValidation) {
        this.disableHttpsCertValidation = disableHttpsCertValidation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @CheckForNull
    public JnlpAgentEndpoint resolve() throws IOException {
        IOException firstError = null;
        Iterator<String> iterator = this.jenkinsUrls.iterator();
        while (true) {
            int port;
            RSAPublicKey identity;
            String host;
            String portStr;
            HashSet<String> agentProtocolNames;
            HttpURLConnection con;
            URL selectedJenkinsURL;
            String jenkinsUrl;
            block38: {
                block37: {
                    URL salURL;
                    block36: {
                        block35: {
                            VersionNumber minimumSupportedVersion;
                            VersionNumber currentVersion;
                            if (!iterator.hasNext()) {
                                if (firstError == null) return null;
                                throw firstError;
                            }
                            jenkinsUrl = iterator.next();
                            if (jenkinsUrl == null) continue;
                            try {
                                selectedJenkinsURL = new URL(jenkinsUrl);
                                salURL = this.toAgentListenerURL(jenkinsUrl);
                            }
                            catch (MalformedURLException ex) {
                                LOGGER.log(Level.WARNING, String.format("Cannot parse agent endpoint URL %s. Skipping it", jenkinsUrl), ex);
                                continue;
                            }
                            con = (HttpURLConnection)JnlpAgentEndpointResolver.openURLConnection(salURL, this.credentials, this.proxyCredentials, this.sslSocketFactory, this.disableHttpsCertValidation);
                            try {
                                con.setConnectTimeout(30000);
                                con.setReadTimeout(60000);
                                con.connect();
                            }
                            catch (IOException x) {
                                firstError = (IOException)ThrowableUtils.chain(firstError, new IOException("Failed to connect to " + salURL + ": " + x.getMessage(), x));
                                con.disconnect();
                            }
                            if (con.getResponseCode() != 200) {
                                firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(salURL + " is invalid: " + con.getResponseCode() + " " + con.getResponseMessage()));
                                con.disconnect();
                            }
                            String minimumSupportedVersionHeader = JnlpAgentEndpointResolver.first(JnlpAgentEndpointResolver.header(con, "X-Remoting-Minimum-Version"));
                            if (minimumSupportedVersionHeader == null || !(currentVersion = new VersionNumber(Launcher.VERSION)).isOlderThan(minimumSupportedVersion = new VersionNumber(minimumSupportedVersionHeader))) break block35;
                            firstError = (IOException)ThrowableUtils.chain(firstError, new IOException("Agent version " + minimumSupportedVersion + " or newer is required."));
                            con.disconnect();
                        }
                        agentProtocolNames = null;
                        portStr = JnlpAgentEndpointResolver.first(JnlpAgentEndpointResolver.header(con, "X-Jenkins-JNLP-Port", "X-Hudson-JNLP-Port"));
                        host = JnlpAgentEndpointResolver.defaultString(JnlpAgentEndpointResolver.first(JnlpAgentEndpointResolver.header(con, "X-Jenkins-JNLP-Host")), salURL.getHost());
                        List<String> protocols = JnlpAgentEndpointResolver.header(con, "X-Jenkins-Agent-Protocols");
                        if (protocols != null) {
                            agentProtocolNames = new HashSet<String>();
                            for (String names : protocols) {
                                for (String name : names.split(",")) {
                                    if ((name = name.trim()).isEmpty()) continue;
                                    agentProtocolNames.add(name);
                                }
                            }
                            if (agentProtocolNames.isEmpty()) {
                                LOGGER.log(Level.WARNING, "Received the empty list of supported protocols from the server. All protocols are disabled on the controller side OR the 'X-Jenkins-Agent-Protocols' header is corrupted (JENKINS-41730). In the case of the header corruption as a workaround you can use the 'org.jenkinsci.remoting.engine.JnlpAgentEndpointResolver.protocolNamesToTry' system property to define the supported protocols.");
                            } else {
                                LOGGER.log(Level.INFO, "Remoting server accepts the following protocols: {0}", agentProtocolNames);
                            }
                        }
                        if (PROTOCOL_NAMES_TO_TRY != null) {
                            agentProtocolNames = new HashSet();
                            LOGGER.log(Level.INFO, "Ignoring the list of supported remoting protocols provided by the server, because the 'org.jenkinsci.remoting.engine.JnlpAgentEndpointResolver.protocolNamesToTry' property is defined. Will try {0}", PROTOCOL_NAMES_TO_TRY);
                            for (String name : PROTOCOL_NAMES_TO_TRY.split(",")) {
                                if ((name = name.trim()).isEmpty()) continue;
                                agentProtocolNames.add(name);
                            }
                        }
                        String idHeader = JnlpAgentEndpointResolver.first(JnlpAgentEndpointResolver.header(con, "X-Instance-Identity"));
                        identity = this.getIdentity(idHeader);
                        if (identity != null) break block36;
                        firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(salURL + " appears to be publishing an invalid X-Instance-Identity."));
                        con.disconnect();
                    }
                    break block37;
                    catch (InvalidKeySpecException e) {
                        firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(salURL + " appears to be publishing an invalid X-Instance-Identity."));
                        con.disconnect();
                    }
                }
                if (portStr != null) break block38;
                firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(jenkinsUrl + " is not Jenkins"));
                con.disconnect();
            }
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(jenkinsUrl + " is publishing an invalid port", e));
                con.disconnect();
            }
            try {
                if (port <= 0 || 65536 <= port) {
                    firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(jenkinsUrl + " is publishing an invalid port"));
                    continue;
                }
                if (this.tunnel == null) {
                    if (!this.isPortVisible(host, port)) {
                        firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(jenkinsUrl + " provided port:" + port + " is not reachable on host " + host));
                        continue;
                    }
                    LOGGER.log(Level.FINE, "TCP Agent Listener Port availability check passed");
                } else {
                    LOGGER.log(Level.INFO, "Remoting TCP connection tunneling is enabled. Skipping the TCP Agent Listener Port availability check");
                }
                String winningJenkinsUrl = jenkinsUrl;
                this.jenkinsUrls.sort((o1, o2) -> {
                    if (winningJenkinsUrl.equals(o1)) {
                        return -1;
                    }
                    if (winningJenkinsUrl.equals(o2)) {
                        return 1;
                    }
                    return 0;
                });
                if (this.tunnel != null) {
                    HostPort hostPort = new HostPort(this.tunnel, host, port);
                    host = hostPort.getHost();
                    port = hostPort.getPort();
                }
                JnlpAgentEndpoint jnlpAgentEndpoint = new JnlpAgentEndpoint(host, port, identity, agentProtocolNames, selectedJenkinsURL);
                return jnlpAgentEndpoint;
            }
            finally {
                con.disconnect();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="This just verifies connection to the port. No data is transmitted.")
    private boolean isPortVisible(String hostname, int port) {
        boolean exitStatus = false;
        Socket s = null;
        try {
            s = new Socket();
            s.setReuseAddress(true);
            InetSocketAddress sa = new InetSocketAddress(hostname, port);
            s.connect(sa, 5000);
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
        }
        finally {
            if (s != null) {
                if (s.isConnected()) {
                    exitStatus = true;
                }
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOGGER.warning(e.getMessage());
                }
            }
        }
        return exitStatus;
    }

    @NonNull
    private URL toAgentListenerURL(@NonNull String jenkinsUrl) throws MalformedURLException {
        return new URL(jenkinsUrl + "tcpSlaveAgentListener/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForReady() throws InterruptedException {
        Thread t = Thread.currentThread();
        String oldName = t.getName();
        try {
            int retries = 0;
            while (true) {
                String firstUrl;
                block10: {
                    Thread.sleep(10000L);
                    firstUrl = JnlpAgentEndpointResolver.first(this.jenkinsUrls);
                    if (firstUrl != null) break block10;
                    t.setName(oldName);
                    return;
                }
                URL url = this.toAgentListenerURL(firstUrl);
                t.setName(oldName + ": trying " + url + " for " + ++retries + " times");
                HttpURLConnection con = (HttpURLConnection)JnlpAgentEndpointResolver.openURLConnection(url, this.credentials, this.proxyCredentials, this.sslSocketFactory, this.disableHttpsCertValidation);
                con.setConnectTimeout(5000);
                con.setReadTimeout(5000);
                con.connect();
                if (con.getResponseCode() == 200) {
                    t.setName(oldName);
                    return;
                }
                try {
                    LOGGER.log(Level.INFO, "Controller isn''t ready to talk to us on {0}. Will try again: response code={1}", new Object[]{url, con.getResponseCode()});
                }
                catch (ConnectException | NoRouteToHostException | SocketTimeoutException e) {
                    LOGGER.log(Level.INFO, "Failed to connect to the controller. Will try again: {0} {1}", new String[]{e.getClass().getName(), e.getMessage()});
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Failed to connect to the controller. Will try again", e);
                }
                continue;
                break;
            }
        }
        catch (Throwable throwable) {
            t.setName(oldName);
            throw throwable;
        }
    }

    @CheckForNull
    static InetSocketAddress getResolvedHttpProxyAddress(@NonNull String host, int port) throws IOException {
        String httpProxy;
        InetSocketAddress targetAddress = null;
        Iterator<Proxy> proxies = ProxySelector.getDefault().select(URI.create(String.format("http://%s:%d", host, port))).iterator();
        while (targetAddress == null && proxies.hasNext()) {
            String nonProxyHosts;
            Proxy proxy = proxies.next();
            if (proxy.type() == Proxy.Type.DIRECT && (nonProxyHosts = System.getProperty("http.nonProxyHosts")) != null && nonProxyHosts.length() != 0) {
                StringJoiner sj = new StringJoiner("|");
                nonProxyHosts = nonProxyHosts.toLowerCase(Locale.ENGLISH);
                for (String entry : nonProxyHosts.split("\\|")) {
                    if (entry.isEmpty()) continue;
                    if (entry.startsWith("*")) {
                        sj.add(".*" + Pattern.quote(entry.substring(1)));
                    } else if (entry.endsWith("*")) {
                        sj.add(Pattern.quote(entry.substring(0, entry.length() - 1)) + ".*");
                    } else {
                        sj.add(Pattern.quote(entry));
                    }
                    if (entry.split("\\*").length <= 2) continue;
                    LOGGER.log(Level.WARNING, "Using more than one wildcard is not supported in nonProxyHosts entries: {0}", entry);
                }
                Pattern nonProxyRegexps = Pattern.compile(sj.toString());
                if (!nonProxyRegexps.matcher(host.toLowerCase(Locale.ENGLISH)).matches()) break;
                return null;
            }
            if (proxy.type() != Proxy.Type.HTTP) continue;
            SocketAddress address = proxy.address();
            if (!(address instanceof InetSocketAddress)) {
                LOGGER.log(Level.WARNING, "Unsupported proxy address type {0}", address != null ? address.getClass() : "null");
                continue;
            }
            InetSocketAddress proxyAddress = (InetSocketAddress)address;
            if (proxyAddress.isUnresolved()) {
                proxyAddress = new InetSocketAddress(proxyAddress.getHostName(), proxyAddress.getPort());
            }
            targetAddress = proxyAddress;
        }
        if (targetAddress == null && (httpProxy = System.getenv("http_proxy")) != null && !JnlpAgentEndpointResolver.inNoProxyEnvVar(host)) {
            try {
                URL url = new URL(httpProxy);
                targetAddress = new InetSocketAddress(url.getHost(), url.getPort());
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "Not using http_proxy environment variable which is invalid.", e);
            }
        }
        return targetAddress;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Used by the agent for retrieving connection info from the server.")
    static URLConnection openURLConnection(URL url, String credentials, String proxyCredentials, SSLSocketFactory sslSocketFactory, boolean disableHttpsCertValidation) throws IOException {
        String encoding;
        URLConnection con;
        String httpProxy = null;
        if (System.getProperty("http.proxyHost") == null) {
            httpProxy = System.getenv("http_proxy");
        }
        if (httpProxy != null && "http".equals(url.getProtocol()) && !JnlpAgentEndpointResolver.inNoProxyEnvVar(url.getHost())) {
            try {
                URL proxyUrl = new URL(httpProxy);
                InetSocketAddress addr = new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                con = url.openConnection(proxy);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "Not using http_proxy environment variable which is invalid.", e);
                con = url.openConnection();
            }
        } else {
            con = url.openConnection();
        }
        if (credentials != null) {
            encoding = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            con.setRequestProperty("Authorization", "Basic " + encoding);
        }
        if (proxyCredentials != null) {
            encoding = Base64.getEncoder().encodeToString(proxyCredentials.getBytes(StandardCharsets.UTF_8));
            con.setRequestProperty("Proxy-Authorization", "Basic " + encoding);
        }
        if (con instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)con;
            if (disableHttpsCertValidation) {
                LOGGER.log(Level.WARNING, "HTTPs certificate check is disabled for the endpoint.");
                try {
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    ctx.init(null, new TrustManager[]{new NoCheckTrustManager()}, new SecureRandom());
                    sslSocketFactory = ctx.getSocketFactory();
                    httpsConnection.setHostnameVerifier(new NoCheckHostnameVerifier());
                    httpsConnection.setSSLSocketFactory(sslSocketFactory);
                }
                catch (KeyManagementException | NoSuchAlgorithmException ex) {
                    throw new IOException("Cannot initialize the insecure HTTPs mode", ex);
                }
            } else if (sslSocketFactory != null) {
                httpsConnection.setSSLSocketFactory(sslSocketFactory);
                httpsConnection.setHostnameVerifier(new NoCheckHostnameVerifier());
            }
        }
        return con;
    }

    static boolean inNoProxyEnvVar(String host) {
        return !NoProxyEvaluator.shouldProxy(host);
    }

    @CheckForNull
    private static List<String> header(@NonNull HttpURLConnection connection, String ... headerNames) {
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        for (String headerName : headerNames) {
            for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
                String headerField = entry.getKey();
                if (!JnlpAgentEndpointResolver.isMatchingHeader(headerName, headerField)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @SuppressFBWarnings(value={"IMPROPER_UNICODE"}, justification="Header fields are provided by controller and header names are hardcoded.")
    private static boolean isMatchingHeader(String headerName, String headerField) {
        return headerField != null && headerField.equalsIgnoreCase(headerName);
    }

    @CheckForNull
    private static String first(@CheckForNull List<String> values) {
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    @NonNull
    private static String defaultString(@CheckForNull String value, @NonNull String defaultValue) {
        return value == null ? defaultValue : value;
    }
}

