/*
 * Decompiled with CFR 0.152.
 */
package jenkins.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.websocket.Provider;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Jetty10Provider
implements Provider {
    private static final String ATTR_LISTENER = Jetty10Provider.class.getName() + ".listener";
    private static final Map<Provider.Listener, Session> sessions = new WeakHashMap<Provider.Listener, Session>();

    public Jetty10Provider() {
        JettyWebSocketServerContainer.class.hashCode();
    }

    public Provider.Handler handle(HttpServletRequest req, HttpServletResponse rsp, final Provider.Listener listener) throws Exception {
        req.setAttribute(ATTR_LISTENER, (Object)listener);
        if (!"websocket".equalsIgnoreCase(req.getHeader("Upgrade"))) {
            rsp.sendError(400, "only WS connections accepted here");
            return null;
        }
        if (!JettyWebSocketServerContainer.getContainer((ServletContext)req.getServletContext()).upgrade(Jetty10Provider::createWebSocket, req, rsp)) {
            rsp.sendError(400, "did not manage to upgrade");
            return null;
        }
        return new Provider.Handler(){

            public Future<Void> sendBinary(ByteBuffer data) throws IOException {
                CompletableFuture<Void> f = new CompletableFuture<Void>();
                this.session().getRemote().sendBytes(data, (WriteCallback)new WriteCallbackImpl(f));
                return f;
            }

            public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
                this.session().getRemote().sendPartialBytes(partialByte, isLast);
            }

            public Future<Void> sendText(String text) throws IOException {
                CompletableFuture<Void> f = new CompletableFuture<Void>();
                this.session().getRemote().sendString(text, (WriteCallback)new WriteCallbackImpl(f));
                return f;
            }

            public void sendPing(ByteBuffer applicationData) throws IOException {
                this.session().getRemote().sendPing(applicationData);
            }

            public void close() throws IOException {
                this.session().close();
            }

            private Session session() {
                Session session = sessions.get(listener);
                if (session == null) {
                    throw new IllegalStateException("missing session");
                }
                return session;
            }
        };
    }

    private static Object createWebSocket(JettyServerUpgradeRequest req, JettyServerUpgradeResponse resp) {
        final Provider.Listener listener = (Provider.Listener)req.getHttpServletRequest().getAttribute(ATTR_LISTENER);
        if (listener == null) {
            throw new IllegalStateException("missing listener attribute");
        }
        return new WebSocketListener(){

            public void onWebSocketBinary(byte[] payload, int offset, int length) {
                listener.onWebSocketBinary(payload, offset, length);
            }

            public void onWebSocketText(String message) {
                listener.onWebSocketText(message);
            }

            public void onWebSocketClose(int statusCode, String reason) {
                listener.onWebSocketClose(statusCode, reason);
            }

            public void onWebSocketConnect(Session session) {
                sessions.put(listener, session);
                listener.onWebSocketConnect();
            }

            public void onWebSocketError(Throwable cause) {
                listener.onWebSocketError(cause);
            }
        };
    }

    private static final class WriteCallbackImpl
    implements WriteCallback {
        private final CompletableFuture<Void> f;

        WriteCallbackImpl(CompletableFuture<Void> f) {
            this.f = f;
        }

        public void writeSuccess() {
            this.f.complete(null);
        }

        public void writeFailed(Throwable x) {
            this.f.completeExceptionally(x);
        }
    }
}

