/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.cli.auth.ssh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.jenkinsci.main.modules.cli.auth.ssh.KeyEncodeHelper;
import org.jenkinsci.main.modules.cli.auth.ssh.PublicKeySignatureWriterException;

public class PublicKeySignatureWriter {
    public String asString(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            return this.asString((RSAPublicKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return this.asString((DSAPublicKey)key);
        }
        throw new IllegalArgumentException("Unknown key type: " + key);
    }

    public String asString(DSAPublicKey key) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DSAParams keyParams = Objects.requireNonNull(key.getParams(), "No DSA params available");
            KeyEncodeHelper.encodeString(output, "ssh-dss", StandardCharsets.ISO_8859_1);
            KeyEncodeHelper.encodeBigInt(output, keyParams.getP());
            KeyEncodeHelper.encodeBigInt(output, keyParams.getQ());
            KeyEncodeHelper.encodeBigInt(output, keyParams.getG());
            KeyEncodeHelper.encodeBigInt(output, key.getY());
            return Base64.encodeBase64String((byte[])output.toByteArray());
        }
        catch (IOException e) {
            throw new PublicKeySignatureWriterException(e);
        }
    }

    public String asString(RSAPublicKey key) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            KeyEncodeHelper.encodeString(output, "ssh-rsa", StandardCharsets.ISO_8859_1);
            KeyEncodeHelper.encodeBigInt(output, key.getPublicExponent());
            KeyEncodeHelper.encodeBigInt(output, key.getModulus());
            return Base64.encodeBase64String((byte[])output.toByteArray());
        }
        catch (IOException e) {
            throw new PublicKeySignatureWriterException(e);
        }
    }
}

