/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import hudson.model.User;
import java.security.PublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.security.SecurityListener;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.jenkinsci.main.modules.cli.auth.ssh.PublicKeySignatureWriter;
import org.jenkinsci.main.modules.cli.auth.ssh.UserPropertyImpl;

class PublicKeyAuthenticatorImpl
implements PublickeyAuthenticator {
    private final PublicKeySignatureWriter signatureWriter = new PublicKeySignatureWriter();
    private static final Logger LOGGER = Logger.getLogger(PublicKeyAuthenticatorImpl.class.getName());

    PublicKeyAuthenticatorImpl() {
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        User user = this.retrieveOnlyKeyValidatedUser(username, key);
        if (user == null) {
            SecurityListener.fireFailedToAuthenticate((String)username);
            return false;
        }
        UserDetails userDetails = this.verifyUserUsingSecurityRealm(user);
        if (userDetails == null) {
            SecurityListener.fireFailedToAuthenticate((String)username);
            return false;
        }
        SecurityListener.fireAuthenticated((UserDetails)user.getUserDetailsForImpersonation());
        return true;
    }

    @CheckForNull
    private User retrieveOnlyKeyValidatedUser(String username, PublicKey key) {
        LOGGER.log(Level.FINE, "Authentication attempted from {0} with {1}", new Object[]{username, key});
        User u = User.getById((String)username, (boolean)false);
        if (u == null) {
            LOGGER.log(Level.FINE, "No such user exists: {0}", new Object[]{username});
            return null;
        }
        UserPropertyImpl sshKey = (UserPropertyImpl)u.getProperty(UserPropertyImpl.class);
        if (sshKey == null) {
            LOGGER.log(Level.FINE, "No SSH key registered for user: {0}", new Object[]{username});
            return null;
        }
        String signature = this.signatureWriter.asString(key);
        if (!sshKey.isAuthorizedKey(signature)) {
            LOGGER.log(Level.FINE, "Key signature did not match for the user: {0} : {1}", new Object[]{username, signature});
            return null;
        }
        return u;
    }

    @CheckForNull
    private UserDetails verifyUserUsingSecurityRealm(@Nonnull User user) {
        try {
            return user.getUserDetailsForImpersonation();
        }
        catch (UsernameNotFoundException e) {
            LOGGER.log(Level.FINE, e, () -> user.getId() + " is not a real user according to SecurityRealm");
            return null;
        }
        catch (AuthenticationException e) {
            LOGGER.log(Level.FINE, e, () -> user.getId() + " is not available according to SecurityRealm");
            return null;
        }
    }
}

