/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeSpecific;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks._ant.AntConsoleAnnotator;
import hudson.tasks._ant.Messages;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Ant
extends Builder {
    private final String targets;
    private final String antName;
    private final String antOpts;
    private final String buildFile;
    private final String properties;

    @DataBoundConstructor
    public Ant(String targets, String antName, String antOpts, String buildFile, String properties) {
        this.targets = targets;
        this.antName = antName;
        this.antOpts = Util.fixEmptyAndTrim((String)antOpts);
        this.buildFile = Util.fixEmptyAndTrim((String)buildFile);
        this.properties = Util.fixEmptyAndTrim((String)properties);
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getTargets() {
        return this.targets;
    }

    public AntInstallation getAnt() {
        for (AntInstallation i : this.getDescriptor().getInstallations()) {
            if (this.antName == null || !this.antName.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    public String getAntOpts() {
        return this.antOpts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        for (Map.Entry e : build.getBuildVariables().entrySet()) {
            if (e.getValue() != null && ((String)e.getValue()).length() == 0) {
                env.put((String)e.getKey(), (String)e.getValue());
                continue;
            }
            env.override((String)e.getKey(), (String)e.getValue());
        }
        AntInstallation ai = this.getAnt();
        if (ai == null) {
            args.add(launcher.isUnix() ? "ant" : "ant.bat");
        } else {
            Node node = Computer.currentComputer().getNode();
            if (node == null) {
                throw new AbortException(Messages.Ant_NodeOffline());
            }
            ai = ai.forNode(node, (TaskListener)listener);
            String exe = (ai = ai.forEnvironment(env)).getExecutable(launcher);
            if (exe == null) {
                throw new AbortException(Messages.Ant_ExecutableNotFound(ai.getName()));
            }
            args.add(exe);
        }
        VariableResolver.ByMap vr = new VariableResolver.ByMap((Map)env);
        String buildFile = env.expand(this.buildFile);
        String targets = env.expand(this.targets);
        FilePath buildFilePath = Ant.buildFilePath(build.getModuleRoot(), buildFile, targets);
        if (!buildFilePath.exists()) {
            FilePath workspaceFilePath = build.getWorkspace();
            if (workspaceFilePath == null) throw new AbortException("Workspace is not available. Agent may be disconnected.");
            FilePath buildFilePath2 = Ant.buildFilePath(workspaceFilePath, buildFile, targets);
            if (!buildFilePath2.exists()) throw new AbortException("Unable to find build script at " + buildFilePath);
            buildFilePath = buildFilePath2;
        }
        if (buildFile != null) {
            args.add(new String[]{"-file", buildFilePath.getName()});
        }
        Set sensitiveVars = build.getSensitiveBuildVariables();
        args.addKeyValuePairs("-D", build.getBuildVariables(), sensitiveVars);
        args.addKeyValuePairsFromPropertyString("-D", this.properties, (VariableResolver)vr, sensitiveVars);
        args.addTokenized(targets.replaceAll("[\t\r\n]+", " "));
        if (ai != null) {
            ai.buildEnvVars(env);
        }
        if (this.antOpts != null) {
            env.put("ANT_OPTS", env.expand(this.antOpts));
        }
        if (!launcher.isUnix()) {
            args = Ant.toWindowsCommand(args.toWindowsCommand());
        }
        long startTime = System.currentTimeMillis();
        try {
            int r;
            AntConsoleAnnotator aca = new AntConsoleAnnotator(listener.getLogger(), build.getCharset());
            try {
                r = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)((Object)aca)).pwd(buildFilePath.getParent()).join();
            }
            finally {
                aca.forceEol();
            }
            if (r != 0) return false;
            return true;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            String errorMessage = Messages.Ant_ExecFailed();
            if (ai != null) throw new AbortException(errorMessage);
            if (System.currentTimeMillis() - startTime >= 1000L) throw new AbortException(errorMessage);
            errorMessage = this.getDescriptor().getInstallations() == null ? errorMessage + Messages.Ant_GlobalConfigNeeded() : errorMessage + Messages.Ant_ProjectConfigNeeded();
            throw new AbortException(errorMessage);
        }
    }

    protected static ArgumentListBuilder toWindowsCommand(ArgumentListBuilder args) {
        List arguments = args.toList();
        if (arguments.size() > 3) {
            boolean[] masks = args.toMaskArray();
            args = new ArgumentListBuilder();
            args.add(new String[]{(String)arguments.get(0), (String)arguments.get(1)});
            int size = arguments.size();
            for (int i = 2; i < size; ++i) {
                String arg = ((String)arguments.get(i)).replaceAll("^(-D[^\" ]+)=$", "$0\"\"");
                if (masks[i]) {
                    args.addMasked(arg);
                    continue;
                }
                args.add(arg);
            }
        } else {
            ArrayList<String> newArgs = new ArrayList<String>(args.toList());
            newArgs.set(newArgs.size() - 1, ((String)newArgs.get(newArgs.size() - 1)).replaceAll("(?<= )(-D[^\" ]+)= ", "$1=\"\" "));
            args = new ArgumentListBuilder(newArgs.toArray(new String[newArgs.size()]));
        }
        return args;
    }

    private static FilePath buildFilePath(FilePath base, String buildFile, String targets) {
        if (buildFile != null) {
            return base.child(buildFile);
        }
        String[] tokens = Util.tokenize((String)targets);
        for (int i = 0; i < tokens.length - 1; ++i) {
            String a = tokens[i];
            if (!a.equals("-f") && !a.equals("-file") && !a.equals("-buildfile")) continue;
            return base.child(tokens[i + 1]);
        }
        return base.child("build.xml");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static class AntInstaller
    extends DownloadFromUrlInstaller {
        @DataBoundConstructor
        public AntInstaller(String id) {
            super(id);
        }

        @Extension
        @Symbol(value={"antFromApache"})
        public static final class DescriptorImpl
        extends DownloadFromUrlInstaller.DescriptorImpl<AntInstaller> {
            public String getDisplayName() {
                return Messages.Ant_InstallFromApache();
            }

            public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
                return toolType == AntInstallation.class;
            }
        }
    }

    public static final class AntInstallation
    extends ToolInstallation
    implements EnvironmentSpecific<AntInstallation>,
    NodeSpecific<AntInstallation> {
        @Deprecated
        private transient String antHome;
        private static final long serialVersionUID = 1L;

        @DataBoundConstructor
        public AntInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
            super(name, AntInstallation.launderHome(StringUtils.defaultString((String)home)), properties);
        }

        @Deprecated
        public AntInstallation(String name, String home) {
            this(name, home, Collections.emptyList());
        }

        private static String launderHome(String home) {
            if (home.endsWith("/") || home.endsWith("\\")) {
                return home.substring(0, home.length() - 1);
            }
            return home;
        }

        public String getAntHome() {
            return this.getHome();
        }

        public void buildEnvVars(EnvVars env) {
            env.put("ANT_HOME", this.getHome());
            env.put("PATH+ANT", this.getHome() + "/bin");
        }

        public String getExecutable(Launcher launcher) throws IOException, InterruptedException {
            VirtualChannel channel = launcher.getChannel();
            if (channel == null) {
                throw new IOException("offline?");
            }
            return (String)channel.call((Callable)new GetExecutable(this.getHome()));
        }

        public boolean getExists() throws IOException, InterruptedException {
            return this.getExecutable((Launcher)new Launcher.LocalLauncher(TaskListener.NULL)) != null;
        }

        public AntInstallation forEnvironment(EnvVars environment) {
            return new AntInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
        }

        public AntInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
            return new AntInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
        }

        public static class ConverterImpl
        extends ToolInstallation.ToolConverter {
            public ConverterImpl(XStream2 xstream) {
                super(xstream);
            }

            protected String oldHomeField(ToolInstallation obj) {
                return ((AntInstallation)obj).antHome;
            }
        }

        @Extension
        @Symbol(value={"ant"})
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="https://github.com/jenkinsci/jenkins/pull/2094")
        public static class DescriptorImpl
        extends ToolDescriptor<AntInstallation> {
            public String getDisplayName() {
                return "Ant";
            }

            public AntInstallation[] getInstallations() {
                return ((hudson.tasks.Ant$DescriptorImpl)Jenkins.get().getDescriptorByType(hudson.tasks.Ant$DescriptorImpl.class)).getInstallations();
            }

            public void setInstallations(AntInstallation ... installations) {
                ((hudson.tasks.Ant$DescriptorImpl)Jenkins.get().getDescriptorByType(hudson.tasks.Ant$DescriptorImpl.class)).setInstallations(installations);
            }

            public List<? extends ToolInstaller> getDefaultInstallers() {
                return Collections.singletonList(new AntInstaller(null));
            }

            public FormValidation doCheckHome(@QueryParameter File value) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    return FormValidation.ok();
                }
                if (value.getPath().equals("")) {
                    return FormValidation.ok();
                }
                if (!value.isDirectory()) {
                    return FormValidation.error((String)Messages.Ant_NotADirectory(value));
                }
                File antJar = new File(value, "lib/ant.jar");
                if (!antJar.exists()) {
                    return FormValidation.error((String)Messages.Ant_NotAntDirectory(value));
                }
                return FormValidation.ok();
            }

            public FormValidation doCheckName(@QueryParameter String value) {
                return FormValidation.validateRequired((String)value);
            }
        }

        private static class GetExecutable
        extends MasterToSlaveCallable<String, IOException> {
            private static final long serialVersionUID = 906341330603832653L;
            private final String rawHome;

            GetExecutable(String rawHome) {
                this.rawHome = rawHome;
            }

            public String call() throws IOException {
                String execName = Functions.isWindows() ? "ant.bat" : "ant";
                String home = Util.replaceMacro((String)this.rawHome, (Map)EnvVars.masterEnvVars);
                File exe = new File(home, "bin/" + execName);
                if (exe.exists()) {
                    return exe.getPath();
                }
                return null;
            }
        }
    }

    @Extension
    @Symbol(value={"ant"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile AntInstallation[] installations = new AntInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        protected DescriptorImpl(Class<? extends Ant> clazz) {
            super(clazz);
        }

        public AntInstallation.DescriptorImpl getToolDescriptor() {
            return (AntInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(AntInstallation.DescriptorImpl.class));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.Ant_DisplayName();
        }

        public AntInstallation[] getInstallations() {
            return Arrays.copyOf(this.installations, this.installations.length);
        }

        public void setInstallations(AntInstallation ... antInstallations) {
            this.installations = antInstallations;
            this.save();
        }
    }
}

