/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.builder.PromotionStatusBuilder;
import org.jfrog.build.extractor.builder.BuildInfoBuilder;
import org.jfrog.build.extractor.ci.Agent;
import org.jfrog.build.extractor.ci.BuildAgent;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Vcs;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.IssuesTrackerHelper;

public class AbstractBuildInfoDeployer {
    protected Run build;
    protected TaskListener listener;
    protected ArtifactoryManager artifactoryManager;
    private BuildInfoAwareConfigurator configurator;
    private EnvVars env;

    public AbstractBuildInfoDeployer(BuildInfoAwareConfigurator configurator, Run build, TaskListener listener, ArtifactoryManager artifactoryManager) throws IOException, InterruptedException {
        this.configurator = configurator;
        this.build = build;
        this.listener = listener;
        this.artifactoryManager = artifactoryManager;
        this.env = build.getEnvironment(listener);
    }

    protected BuildInfo createBuildInfo(String buildAgentName, String buildAgentVersion) {
        ReleaseAction release;
        Vcs vcs;
        String url;
        String revision;
        Cause.UpstreamCause parent;
        String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(this.configurator, this.build);
        BuildInfoBuilder builder = new BuildInfoBuilder(buildName).number(BuildUniqueIdentifierHelper.getBuildNumber(this.build)).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).buildAgent(new BuildAgent(buildAgentName, buildAgentVersion)).agent(new Agent("Jenkins", Jenkins.VERSION));
        String buildUrl = ActionableHelper.getBuildUrl(this.build);
        if (StringUtils.isNotBlank((CharSequence)buildUrl)) {
            builder.url(buildUrl);
        }
        Calendar startedTimestamp = this.build.getTimestamp();
        builder.startedDate(startedTimestamp.getTime());
        long duration = System.currentTimeMillis() - startedTimestamp.getTimeInMillis();
        builder.durationMillis(duration);
        String artifactoryPrincipal = this.configurator.getArtifactoryServer().getResolvingCredentialsConfig().provideCredentials((Item)this.build.getParent()).getUsername();
        if (StringUtils.isBlank((CharSequence)artifactoryPrincipal)) {
            artifactoryPrincipal = "";
        }
        builder.artifactoryPrincipal(artifactoryPrincipal);
        String userCause = ActionableHelper.getUserCausePrincipal(this.build);
        if (userCause != null) {
            builder.principal(userCause);
        }
        if ((parent = ActionableHelper.getUpstreamCause(this.build)) != null) {
            String parentProject = ExtractorUtils.sanitizeBuildName(parent.getUpstreamProject());
            int parentNumber = parent.getUpstreamBuild();
            builder.parentName(parentProject);
            builder.parentNumber(parentNumber + "");
            if (StringUtils.isBlank((CharSequence)userCause)) {
                builder.principal("auto");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(revision = ExtractorUtils.getVcsRevision((Map<String, String>)this.env)))) {
            builder.vcsRevision(revision);
        }
        if (StringUtils.isNotBlank((CharSequence)(url = ExtractorUtils.getVcsUrl((Map<String, String>)this.env)))) {
            builder.vcsUrl(url);
        }
        if (!(vcs = new Vcs(url, revision, ExtractorUtils.getVcsBranch((Map<String, String>)this.env), ExtractorUtils.getVcsMessage((Map<String, String>)this.env))).isEmpty()) {
            ArrayList<Vcs> vcsList = new ArrayList<Vcs>();
            vcsList.add(vcs);
            builder.vcs(vcsList);
        }
        this.addBuildInfoProperties(builder);
        if (Jenkins.get().getPlugin("jira") != null && this.configurator.isEnableIssueTrackerIntegration()) {
            new IssuesTrackerHelper(this.build, this.listener, this.configurator.isAggregateBuildIssues(), this.configurator.getAggregationBuildStatus()).setIssueTrackerInfo(builder);
        }
        if ((release = ActionableHelper.getLatestAction(this.build, ReleaseAction.class)) != null) {
            String stagingRepoKey = release.getStagingRepositoryKey();
            if (StringUtils.isBlank((CharSequence)stagingRepoKey)) {
                stagingRepoKey = Util.replaceMacro((String)this.configurator.getRepositoryKey(), (Map)this.env);
            }
            builder.addStatus(new PromotionStatusBuilder("Staged").timestampDate(startedTimestamp.getTime()).comment(release.getStagingComment()).repository(stagingRepoKey).ciUser(userCause).user(artifactoryPrincipal).build());
        }
        BuildInfo buildInfo = builder.build();
        if (parent != null) {
            buildInfo.setParentName(parent.getUpstreamProject());
        }
        return buildInfo;
    }

    protected void addBuildInfoProperties(BuildInfoBuilder builder) {
        IncludesExcludes envVarsPatterns;
        if (this.configurator.isIncludeEnvVars() && (envVarsPatterns = this.configurator.getEnvVarsPatterns()) != null) {
            IncludeExcludePatterns patterns = new IncludeExcludePatterns(Util.replaceMacro((String)envVarsPatterns.getIncludePatterns(), (Map)this.env), Util.replaceMacro((String)envVarsPatterns.getExcludePatterns(), (Map)this.env));
            this.addBuildVariables(builder, patterns);
            this.addEnvVariables(builder, patterns);
            this.addSystemVariables(builder, patterns);
        }
    }

    private void addBuildVariables(BuildInfoBuilder builder, IncludeExcludePatterns patterns) {
        if (!(this.build instanceof AbstractBuild)) {
            return;
        }
        Map buildVariables = ((AbstractBuild)this.build).getBuildVariables();
        for (Map.Entry entry : buildVariables.entrySet()) {
            String varKey = (String)entry.getKey();
            if (PatternMatcher.pathConflicts((String)varKey, (IncludeExcludePatterns)patterns)) continue;
            builder.addProperty((Object)("buildInfo.env." + varKey), entry.getValue());
        }
    }

    private void addEnvVariables(BuildInfoBuilder builder, IncludeExcludePatterns patterns) {
        for (Map.Entry entry : this.env.entrySet()) {
            String varKey = (String)entry.getKey();
            if (PatternMatcher.pathConflicts((String)varKey, (IncludeExcludePatterns)patterns)) continue;
            builder.addProperty((Object)("buildInfo.env." + varKey), entry.getValue());
        }
    }

    private void addSystemVariables(BuildInfoBuilder builder, IncludeExcludePatterns patterns) {
        Properties systemProperties = System.getProperties();
        Enumeration<?> enumeration = systemProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyKey = (String)enumeration.nextElement();
            if (PatternMatcher.pathConflicts((String)propertyKey, (IncludeExcludePatterns)patterns)) continue;
            builder.addProperty((Object)propertyKey, (Object)systemProperties.getProperty(propertyKey));
        }
    }
}

