/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.JFrogPlatformInstance;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.UserPluginInfo;
import org.jfrog.hudson.UserPluginInfoParam;
import org.jfrog.hudson.VirtualRepository;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AbstractBuildWrapperDescriptor
extends BuildWrapperDescriptor {
    protected AbstractProject<?, ?> item;
    private String configPrefix;
    private String displayName;

    public AbstractBuildWrapperDescriptor(Class<? extends BuildWrapper> configuratorClass, String displayName, String configPrefix) {
        super(configuratorClass);
        this.configPrefix = configPrefix;
        this.displayName = displayName;
        this.load();
    }

    public boolean isApplicable(AbstractProject<?, ?> item) {
        this.item = item;
        Class<Object> itemClass = item.getClass();
        return itemClass.isAssignableFrom(FreeStyleProject.class) || itemClass.isAssignableFrom(MatrixProject.class) || Jenkins.get().getPlugin("jenkins-multijob-plugin") != null && itemClass.isAssignableFrom(MultiJobProject.class) || "PromotionProcess".equals(itemClass.getSimpleName());
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        req.bindParameters((Object)this, this.configPrefix);
        this.save();
        return true;
    }

    public List<JFrogPlatformInstance> getJfrogInstances() {
        return RepositoriesUtils.getJFrogPlatformInstances();
    }

    public boolean isUseCredentialsPlugin() {
        return PluginsUtils.isUseCredentialsPlugin();
    }

    public boolean isJiraPluginEnabled() {
        return Jenkins.get().getPlugin("jira") != null;
    }

    protected RefreshServerResponse refreshResolversFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
        RefreshServerResponse response = new RefreshServerResponse();
        CredentialsConfig credentialsConfig = new CredentialsConfig(username, password, credentialsId, overrideCredentials);
        ArtifactoryServer artifactoryServer = RepositoriesUtils.getArtifactoryServer(url);
        try {
            List<VirtualRepository> virtualRepositories = this.refreshVirtualRepositories(artifactoryServer, credentialsConfig);
            response.setVirtualRepositories(virtualRepositories);
            response.setSuccess(true);
        }
        catch (Exception e) {
            response.setResponseMessage(e.getMessage());
            response.setSuccess(false);
        }
        return response;
    }

    protected RefreshServerResponse refreshDeployersFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials, boolean refreshUserPlugins) {
        RefreshServerResponse response = new RefreshServerResponse();
        CredentialsConfig credentialsConfig = new CredentialsConfig(username, password, credentialsId, overrideCredentials);
        ArtifactoryServer artifactoryServer = RepositoriesUtils.getArtifactoryServer(url);
        try {
            response.setRepositories(this.refreshRepositories(artifactoryServer, credentialsConfig));
            if (refreshUserPlugins) {
                response.setUserPlugins(this.refreshUserPlugins(artifactoryServer, credentialsConfig));
            }
            response.setSuccess(true);
        }
        catch (Exception e) {
            response.setResponseMessage(e.getMessage());
            response.setSuccess(false);
        }
        return response;
    }

    private List<PluginSettings> refreshUserPlugins(ArtifactoryServer artifactoryServer, final CredentialsConfig credentialsConfigs) {
        List<UserPluginInfo> pluginInfoList = artifactoryServer.getStagingUserPluginInfo(new DeployerOverrider(){

            @Override
            public boolean isOverridingDefaultDeployer() {
                return credentialsConfigs != null && credentialsConfigs.isCredentialsProvided();
            }

            @Override
            public Credentials getOverridingDeployerCredentials() {
                return null;
            }

            @Override
            public CredentialsConfig getDeployerCredentialsConfig() {
                return credentialsConfigs;
            }
        }, (Item)this.item);
        ArrayList<PluginSettings> list = new ArrayList<PluginSettings>(pluginInfoList.size());
        for (UserPluginInfo p : pluginInfoList) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            List<UserPluginInfoParam> params = p.getPluginParams();
            for (UserPluginInfoParam param : params) {
                paramsMap.put((String)param.getKey(), (String)param.getDefaultValue());
            }
            PluginSettings plugin = new PluginSettings(p.getPluginName(), paramsMap);
            list.add(plugin);
        }
        return list;
    }

    private List<VirtualRepository> refreshVirtualRepositories(ArtifactoryServer artifactoryServer, CredentialsConfig credentialsConfig) throws IOException {
        List<VirtualRepository> virtualRepositories = RepositoriesUtils.getVirtualRepositoryKeys(artifactoryServer.getArtifactoryUrl(), credentialsConfig, artifactoryServer, this.item);
        Collections.sort(virtualRepositories);
        return virtualRepositories;
    }

    private List<Repository> refreshRepositories(ArtifactoryServer artifactoryServer, CredentialsConfig credentialsConfig) throws IOException {
        List<String> releaseRepositoryKeysFirst = RepositoriesUtils.getLocalRepositories(artifactoryServer.getArtifactoryUrl(), credentialsConfig, artifactoryServer, this.item);
        Collections.sort(releaseRepositoryKeysFirst);
        return RepositoriesUtils.createRepositoriesList(releaseRepositoryKeysFirst);
    }

    public boolean isMultiConfProject() {
        return this.item.getClass().isAssignableFrom(MatrixProject.class);
    }
}

