/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import java.io.Serializable;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.PublishBuildInfo;

public class PublishedBuildDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String artifactoryUrl;
    private String buildName;
    private String buildNumber;
    private String platformUrl;
    private String startedTimeStamp;
    private String project;

    public PublishedBuildDetails(String artifactoryUrl, String buildName, String buildNumber) {
        this.artifactoryUrl = artifactoryUrl;
        this.buildName = buildName;
        this.buildNumber = buildNumber;
    }

    public PublishedBuildDetails(String artifactoryUrl, String buildName, String buildNumber, String platformUrl, String startedTimeStamp, String project) {
        this(artifactoryUrl, buildName, buildNumber);
        this.platformUrl = platformUrl;
        this.startedTimeStamp = startedTimeStamp;
        this.project = project;
    }

    public String getBuildInfoUrl() throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)this.platformUrl) && StringUtils.isNotBlank((CharSequence)this.startedTimeStamp)) {
            return PublishBuildInfo.createBuildInfoUrl((String)this.platformUrl, (String)this.buildName, (String)this.buildNumber, (String)this.startedTimeStamp, (String)this.project, (boolean)false);
        }
        return PublishBuildInfo.createBuildInfoUrl((String)this.artifactoryUrl, (String)this.buildName, (String)this.buildNumber, (boolean)false);
    }

    public String getDisplayName() {
        return this.buildName + " / " + this.buildNumber;
    }
}

