/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.action;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.model.TransientProjectActionFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.TransientActionFactory;
import jenkins.util.TimeDuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesServer;
import org.jfrog.hudson.jfpipelines.Utils;
import org.jfrog.hudson.jfpipelines.payloads.JobStartedPayload;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.SerializationUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class JfrogPipelinesAction<JobT extends Job<?, ?>>
implements Action {
    private final JenkinsBuildInfoLog logger = new JenkinsBuildInfoLog(TaskListener.NULL);
    private final JobT project;

    public JfrogPipelinesAction(JobT job) {
        this.project = job;
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return "JFrog Pipelines job wrapper";
    }

    public String getUrlName() {
        return "jfrog";
    }

    @RequirePOST
    public void doPipelines(StaplerRequest req, StaplerResponse resp) throws IOException {
        try {
            JobStartedPayload payload = this.getJobStartedPayload(req);
            Utils.injectJfPipelinesInfoParameter(this.project, "");
            Queue.Item queueItem = this.runBuild(this.project, req, resp);
            if (queueItem != null) {
                JFrogPipelinesServer.reportQueueId(queueItem, payload.getStepId());
            }
            this.logger.debug(String.format("Queued job '%s', stepId: '%s', queueId: '%s'", this.project.getName(), payload.getStepId(), queueItem != null ? Long.valueOf(queueItem.getId()) : "N/A"));
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtils.getRootCauseMessage((Throwable)e), e);
            resp.sendError(400, ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private JobStartedPayload getJobStartedPayload(StaplerRequest req) throws IOException {
        String jfPipelinesInfo = req.getParameter("JFROG_PIPELINES_INFO");
        if (StringUtils.isBlank((CharSequence)jfPipelinesInfo)) {
            throw new IOException("JFROG_PIPELINES_INFO parameter is missing");
        }
        JobStartedPayload payload = (JobStartedPayload)SerializationUtils.createMapper().readValue(jfPipelinesInfo, JobStartedPayload.class);
        if (StringUtils.isBlank((CharSequence)payload.getStepId())) {
            throw new IOException("'stepId' is missing in JFROG_PIPELINES_INFO parameter");
        }
        return payload;
    }

    private Queue.Item runBuild(JobT job, StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        TimeDuration quietPeriod = new TimeDuration((long)Jenkins.get().getQuietPeriod());
        ((ParameterizedJobMixIn.ParameterizedJob)job).doBuildWithParameters(req, resp, quietPeriod);
        return job.getQueueItem();
    }

    @Extension
    public static class UiJobsActionFactory
    extends TransientProjectActionFactory {
        public Collection<? extends Action> createFor(AbstractProject target) {
            return Collections.singletonList(new JfrogPipelinesAction<AbstractProject>(target));
        }
    }

    @Extension
    public static class WorkflowActionFactory
    extends TransientActionFactory<WorkflowJob> {
        public Class<WorkflowJob> type() {
            return WorkflowJob.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull WorkflowJob run) {
            return Collections.singletonList(new JfrogPipelinesAction<WorkflowJob>(run));
        }
    }
}

