/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.AbstractBuildWrapperDescriptor;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.MultiConfigurationAware;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.SpecConfiguration;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.generic.FilesResolverCallable;
import org.jfrog.hudson.generic.GenericArtifactsDeployer;
import org.jfrog.hudson.generic.GenericArtifactsResolver;
import org.jfrog.hudson.generic.GenericBuildInfoDeployer;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.ProxyUtils;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.SpecUtils;
import org.jfrog.hudson.util.converters.GenericDeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.MultiConfigurationUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ArtifactoryGenericConfigurator
extends BuildWrapper
implements DeployerOverrider,
ResolverOverrider,
BuildInfoAwareConfigurator,
MultiConfigurationAware {
    private final ServerDetails specsDeployerDetails;
    private final ServerDetails specsResolverDetails;
    private final ServerDetails legacyDeployerDetails;
    private final ServerDetails legacyResolverDetails;
    private CredentialsConfig deployerCredentialsConfig;
    private CredentialsConfig resolverCredentialsConfig;
    private SpecConfiguration uploadSpec;
    private SpecConfiguration downloadSpec;
    private String deployPattern;
    private String resolvePattern;
    private String deploymentProperties;
    private boolean deployBuildInfo;
    private boolean includeEnvVars;
    private IncludesExcludes envVarsPatterns;
    private boolean discardOldBuilds;
    private boolean discardBuildArtifacts;
    private boolean asyncBuildRetention;
    private transient List<Dependency> publishedDependencies;
    private transient List<BuildDependency> buildDependencies;
    private String artifactoryCombinationFilter;
    private boolean multiConfProject;
    private String customBuildName;
    private boolean overrideBuildName;
    @Deprecated
    private Boolean useSpecs;
    @Deprecated
    private Credentials overridingDeployerCredentials;
    @Deprecated
    private Credentials overridingResolverCredentials;
    @Deprecated
    private ServerDetails details;
    @Deprecated
    private ServerDetails deployerDetails;
    @Deprecated
    private ServerDetails resolverDetails;
    @Deprecated
    private final String matrixParams;

    @DataBoundConstructor
    public ArtifactoryGenericConfigurator(ServerDetails specsDeployerDetails, ServerDetails specsResolverDetails, ServerDetails legacyDeployerDetails, ServerDetails legacyResolverDetails, CredentialsConfig deployerCredentialsConfig, CredentialsConfig resolverCredentialsConfig, String deployPattern, String resolvePattern, String matrixParams, String deploymentProperties, boolean useSpecs, SpecConfiguration uploadSpec, SpecConfiguration downloadSpec, boolean deployBuildInfo, boolean includeEnvVars, IncludesExcludes envVarsPatterns, boolean discardOldBuilds, boolean discardBuildArtifacts, boolean asyncBuildRetention, boolean multiConfProject, String artifactoryCombinationFilter, String customBuildName, boolean overrideBuildName) {
        this.matrixParams = null;
        this.specsDeployerDetails = specsDeployerDetails;
        this.specsResolverDetails = specsResolverDetails;
        this.legacyDeployerDetails = legacyDeployerDetails;
        this.legacyResolverDetails = legacyResolverDetails;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.resolverCredentialsConfig = resolverCredentialsConfig;
        this.deployPattern = deployPattern;
        this.resolvePattern = resolvePattern;
        this.useSpecs = useSpecs;
        this.uploadSpec = uploadSpec;
        this.downloadSpec = downloadSpec;
        this.deploymentProperties = deploymentProperties;
        this.deployBuildInfo = deployBuildInfo;
        this.includeEnvVars = includeEnvVars;
        this.envVarsPatterns = envVarsPatterns;
        this.discardOldBuilds = discardOldBuilds;
        this.discardBuildArtifacts = discardBuildArtifacts;
        this.asyncBuildRetention = asyncBuildRetention;
        this.multiConfProject = multiConfProject;
        this.artifactoryCombinationFilter = artifactoryCombinationFilter;
        this.customBuildName = customBuildName;
        this.overrideBuildName = overrideBuildName;
    }

    public ArtifactoryGenericConfigurator(ServerDetails details, ServerDetails deployerDetails, ServerDetails resolverDetails, ServerDetails specsDeployerDetails, ServerDetails specsResolverDetails, ServerDetails legacyDeployerDetails, ServerDetails legacyResolverDetails) {
        this.matrixParams = null;
        this.details = details;
        this.deployerDetails = deployerDetails;
        this.resolverDetails = resolverDetails;
        this.specsDeployerDetails = specsDeployerDetails;
        this.specsResolverDetails = specsResolverDetails;
        this.legacyDeployerDetails = legacyDeployerDetails;
        this.legacyResolverDetails = legacyResolverDetails;
    }

    public String getArtifactoryName() {
        ServerDetails deployerDetails = this.isUseSpecs() ? this.specsDeployerDetails : this.legacyDeployerDetails;
        return deployerDetails != null ? deployerDetails.getArtifactoryName() : null;
    }

    public String getArtifactoryResolverName() {
        ServerDetails resolverDetails = this.isUseSpecs() ? this.specsResolverDetails : this.legacyResolverDetails;
        return resolverDetails != null ? resolverDetails.getArtifactoryName() : null;
    }

    public String getArtifactoryUrl() {
        ArtifactoryServer server = this.getArtifactoryServer();
        return server != null ? server.getArtifactoryUrl() : null;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return this.deployerCredentialsConfig != null && this.deployerCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public String getRepositoryKey() {
        return this.legacyDeployerDetails.getDeployReleaseRepository().getRepoKey();
    }

    @Override
    public String getDefaultPromotionTargetRepository() {
        return null;
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return this.overridingDeployerCredentials;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    public String getDeployPattern() {
        return this.deployPattern;
    }

    public String getResolvePattern() {
        return this.resolvePattern;
    }

    public boolean isUseSpecs() {
        return this.useSpecs == null || this.useSpecs != false;
    }

    public SpecConfiguration getUploadSpec() {
        return this.uploadSpec;
    }

    public SpecConfiguration getDownloadSpec() {
        return this.downloadSpec;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public boolean isDeployBuildInfo() {
        return this.deployBuildInfo;
    }

    @Override
    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    @Override
    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    @Override
    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    @Override
    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    @Override
    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    @Override
    public boolean isEnableIssueTrackerIntegration() {
        return false;
    }

    @Override
    public boolean isAggregateBuildIssues() {
        return false;
    }

    @Override
    public String getAggregationBuildStatus() {
        return null;
    }

    @Override
    public String getArtifactoryCombinationFilter() {
        return this.artifactoryCombinationFilter;
    }

    @Override
    public boolean isMultiConfProject() {
        return this.multiConfProject;
    }

    @Override
    public String getCustomBuildName() {
        return this.customBuildName;
    }

    @Override
    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    public ServerDetails getSpecsDeployerDetails() {
        return this.specsDeployerDetails;
    }

    public ServerDetails getSpecsResolverDetails() {
        return this.specsResolverDetails;
    }

    public ServerDetails getLegacyDeployerDetails() {
        return this.legacyDeployerDetails;
    }

    public ServerDetails getLegacyResolverDetails() {
        return this.legacyResolverDetails;
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryName());
    }

    public ArtifactoryServer getArtifactoryResolverServer() {
        String serverId = this.getArtifactoryResolverName();
        if (serverId == null) {
            throw new RuntimeException("Artifactory server for dependencies resolution is null");
        }
        ArtifactoryServer server = RepositoriesUtils.getArtifactoryServer(serverId);
        if (server == null) {
            throw new RuntimeException(String.format("The job is configured to use an Artifactory server with ID '%s' for dependencies resolution. This server however does not exist", serverId));
        }
        return server;
    }

    public List<Repository> getReleaseRepositoryList() {
        if (this.legacyDeployerDetails.getDeploySnapshotRepository() == null) {
            return new ArrayList<Repository>();
        }
        return RepositoriesUtils.collectRepositories(this.legacyDeployerDetails.getDeploySnapshotRepository().getKeyFromSelect());
    }

    public Collection<? extends Action> getProjectActions(AbstractProject project) {
        if (this.isOverrideBuildName()) {
            return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project, this.getCustomBuildName());
        }
        return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project);
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        RepositoriesUtils.validateServerConfig(build, listener, this.getArtifactoryServer(), this.getArtifactoryUrl());
        if (StringUtils.isBlank((CharSequence)this.getArtifactoryName())) {
            return super.setUp(build, launcher, listener);
        }
        ArtifactoryServer resolverServer = this.getArtifactoryResolverServer();
        CredentialsConfig preferredResolver = CredentialManager.getPreferredResolver(this, resolverServer);
        Credentials resolverCredentials = preferredResolver.provideCredentials((Item)build.getProject());
        ProxyConfiguration proxyConfiguration = null;
        if (Jenkins.get().proxy != null && !resolverServer.isBypassProxy()) {
            proxyConfiguration = ProxyUtils.createProxyConfiguration();
        }
        if (this.isUseSpecs()) {
            String spec = SpecUtils.getSpecStringFromSpecConf(this.downloadSpec, build.getEnvironment((TaskListener)listener), build.getExecutor().getCurrentWorkspace(), listener.getLogger());
            FilePath workspace = build.getExecutor().getCurrentWorkspace();
            this.publishedDependencies = (List)workspace.act((FilePath.FileCallable)new FilesResolverCallable(new JenkinsBuildInfoLog((TaskListener)listener), resolverCredentials, resolverServer.getArtifactoryUrl(), spec, proxyConfiguration));
        } else {
            try (ArtifactoryManager artifactoryManager = resolverServer.createArtifactoryManager(resolverCredentials, proxyConfiguration, (TaskListener)listener);){
                GenericArtifactsResolver artifactsResolver = new GenericArtifactsResolver(build, listener, artifactoryManager);
                this.publishedDependencies = artifactsResolver.retrievePublishedDependencies(this.resolvePattern);
                this.buildDependencies = artifactsResolver.retrieveBuildDependencies(this.resolvePattern);
            }
        }
        return this.createEnvironmentOnSuccessfulSetup();
    }

    private BuildWrapper.Environment createEnvironmentOnSuccessfulSetup() {
        return new BuildWrapper.Environment(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean tearDown(AbstractBuild build, BuildListener listener) {
                Result result = build.getResult();
                if (result != null && result.isWorseThan(Result.SUCCESS)) {
                    return true;
                }
                ArtifactoryServer server = ArtifactoryGenericConfigurator.this.getArtifactoryServer();
                CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(ArtifactoryGenericConfigurator.this, server);
                try (ArtifactoryManager artifactoryManager = server.createArtifactoryManager(preferredDeployer.provideCredentials((Item)build.getProject()), ProxyUtils.createProxyConfiguration());){
                    server.setLog((TaskListener)listener, artifactoryManager);
                    boolean isFiltered = false;
                    if (ArtifactoryGenericConfigurator.this.isMultiConfProject(build)) {
                        if (ArtifactoryGenericConfigurator.this.multiConfProject && StringUtils.isBlank((CharSequence)ArtifactoryGenericConfigurator.this.getArtifactoryCombinationFilter())) {
                            String error = "The field \"Combination Matches\" is empty, but is defined as mandatory!";
                            listener.getLogger().println(error);
                            throw new IllegalArgumentException(error);
                        }
                        isFiltered = MultiConfigurationUtils.isfiltrated(build, ArtifactoryGenericConfigurator.this.getArtifactoryCombinationFilter());
                    }
                    if (!isFiltered) {
                        GenericArtifactsDeployer artifactsDeployer = new GenericArtifactsDeployer((Run)build, ArtifactoryGenericConfigurator.this, listener, preferredDeployer);
                        artifactsDeployer.deploy();
                        List<Artifact> deployedArtifacts = artifactsDeployer.getDeployedArtifacts();
                        if (ArtifactoryGenericConfigurator.this.deployBuildInfo) {
                            new GenericBuildInfoDeployer(ArtifactoryGenericConfigurator.this, artifactoryManager, (Run)build, (TaskListener)listener, deployedArtifacts, ArtifactoryGenericConfigurator.this.buildDependencies, ArtifactoryGenericConfigurator.this.publishedDependencies).deploy();
                            String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(ArtifactoryGenericConfigurator.this, (Run)build);
                            build.addAction((Action)new BuildInfoResultAction(ArtifactoryGenericConfigurator.this.getArtifactoryUrl(), (Run)build, buildName));
                            build.addAction((Action)new UnifiedPromoteBuildAction((Run<?, ?>)build, ArtifactoryGenericConfigurator.this));
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    e.printStackTrace(listener.error(e.getMessage()));
                    build.setResult(Result.FAILURE);
                    return true;
                }
            }
        };
    }

    private boolean isMultiConfProject(AbstractBuild build) {
        return build.getProject().getClass().equals(MatrixConfiguration.class);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public boolean isOverridingDefaultResolver() {
        return this.resolverCredentialsConfig != null && this.resolverCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingResolverCredentials() {
        return this.overridingResolverCredentials;
    }

    @Override
    public CredentialsConfig getResolverCredentialsConfig() {
        return this.resolverCredentialsConfig;
    }

    public static final class ConverterImpl
    extends GenericDeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractBuildWrapperDescriptor {
        private static final String DISPLAY_NAME = "Generic-Artifactory Integration";
        private static final String CONFIG_PREFIX = "generic";

        public DescriptorImpl() {
            super(ArtifactoryGenericConfigurator.class, DISPLAY_NAME, CONFIG_PREFIX);
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            return super.refreshDeployersFromArtifactory(url, credentialsId, username, password, overrideCredentials, false);
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginCredentials(project);
        }
    }
}

