/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.util.EditPropertiesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;
import org.jfrog.hudson.util.Credentials;

public class EditPropertiesCallable
extends MasterToSlaveFileCallable<Boolean> {
    private Log log;
    private String username;
    private String password;
    private String accessToken;
    private String serverUrl;
    private String spec;
    private ProxyConfiguration proxyConfig;
    private EditPropertiesHelper.EditPropertiesActionType editType;
    private String props;

    public EditPropertiesCallable(Log log, Credentials credentials, String serverUrl, String spec, ProxyConfiguration proxyConfig, EditPropertiesHelper.EditPropertiesActionType editType, String props) {
        this.log = log;
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
        this.accessToken = credentials.getAccessToken();
        this.serverUrl = serverUrl;
        this.spec = spec;
        this.proxyConfig = proxyConfig;
        this.editType = editType;
        this.props = props;
    }

    public Boolean invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
        if (StringUtils.isEmpty((CharSequence)this.spec)) {
            return false;
        }
        SpecsHelper specsHelper = new SpecsHelper(this.log);
        try (ArtifactoryManager artifactoryManager = new ArtifactoryManager(this.serverUrl, this.username, this.password, this.accessToken, this.log);){
            if (this.proxyConfig != null) {
                artifactoryManager.setProxyConfiguration(this.proxyConfig);
            }
            Boolean bl = specsHelper.editPropertiesBySpec(this.spec, artifactoryManager, this.editType, this.props);
            return bl;
        }
    }
}

