/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;
import org.jfrog.hudson.util.Credentials;

public class FilesResolverCallable
extends MasterToSlaveFileCallable<List<Dependency>> {
    private Log log;
    private String username;
    private String password;
    private String accessToken;
    private String serverUrl;
    private String downloadSpec;
    private ProxyConfiguration proxyConfig;

    public FilesResolverCallable(Log log, Credentials credentials, String serverUrl, String downloadSpec, ProxyConfiguration proxyConfig) {
        this.log = log;
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
        this.accessToken = credentials.getAccessToken();
        this.serverUrl = serverUrl;
        this.downloadSpec = downloadSpec;
        this.proxyConfig = proxyConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dependency> invoke(File file, VirtualChannel channel) throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.downloadSpec)) {
            return new ArrayList<Dependency>();
        }
        SpecsHelper specsHelper = new SpecsHelper(this.log);
        ArtifactoryManager artifactoryManager = new ArtifactoryManager(this.serverUrl, this.username, this.password, this.accessToken, this.log);
        if (this.proxyConfig != null) {
            artifactoryManager.setProxyConfiguration(this.proxyConfig);
        }
        try {
            List list = specsHelper.downloadArtifactsBySpec(this.downloadSpec, artifactoryManager, file.getCanonicalPath());
            return list;
        }
        finally {
            artifactoryManager.close();
        }
    }
}

