/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.gradle;

import hudson.EnvVars;
import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.jfrog.hudson.util.PluginDependencyHelper;

public class GradleInitScriptWriter {
    private FilePath rootPath;

    public GradleInitScriptWriter(FilePath rootPath) {
        this.rootPath = rootPath;
    }

    public String generateInitScript(EnvVars env) throws IOException, InterruptedException {
        StringBuilder initScript = new StringBuilder();
        InputStream templateStream = this.getClass().getResourceAsStream("/initscripttemplate.gradle");
        String templateAsString = IOUtils.toString((InputStream)templateStream, (String)StandardCharsets.UTF_8.name());
        File extractorJar = PluginDependencyHelper.getExtractorJar(env);
        FilePath dependencyDir = PluginDependencyHelper.getActualDependencyDirectory(extractorJar, this.rootPath);
        String absoluteDependencyDirPath = dependencyDir.getRemote();
        absoluteDependencyDirPath = absoluteDependencyDirPath.replace("\\", "/");
        String str = templateAsString.replace("${pluginLibDir}", absoluteDependencyDirPath);
        initScript.append(str);
        return initScript.toString();
    }
}

