/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.ivy;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Which;
import hudson.tasks.Ant;
import hudson.tasks.BuildWrapper;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.listener.ArtifactoryBuildListener;
import org.jfrog.hudson.AbstractBuildWrapperDescriptor;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.MultiConfigurationAware;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.ConcurrentJobsHelper;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.PluginDependencyHelper;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.MultiConfigurationUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ArtifactoryIvyFreeStyleConfigurator
extends BuildWrapper
implements DeployerOverrider,
BuildInfoAwareConfigurator,
MultiConfigurationAware {
    public final String remotePluginLocation;
    public final boolean deployBuildInfo;
    public final boolean includeEnvVars;
    private final CredentialsConfig deployerCredentialsConfig;
    private final String ivyPattern;
    private final String artifactPattern;
    private final Boolean useMavenPatterns;
    private final IncludesExcludes artifactDeploymentPatterns;
    private final boolean discardOldBuilds;
    private final boolean asyncBuildRetention;
    private final boolean passIdentifiedDownstream;
    private final boolean discardBuildArtifacts;
    private final String deploymentProperties;
    private final boolean enableIssueTrackerIntegration;
    private final boolean filterExcludedArtifactsFromBuild;
    private ServerDetails deployerDetails;
    private boolean deployArtifacts;
    private IncludesExcludes envVarsPatterns;
    private String aggregationBuildStatus;
    private boolean aggregateBuildIssues;
    private String artifactoryCombinationFilter;
    private String customBuildName;
    private boolean overrideBuildName;
    @Deprecated
    private Credentials overridingDeployerCredentials;
    @Deprecated
    private final ServerDetails details = null;
    @Deprecated
    private final String matrixParams;
    @Deprecated
    private final Boolean notM2Compatible = null;

    @DataBoundConstructor
    public ArtifactoryIvyFreeStyleConfigurator(ServerDetails details, ServerDetails deployerDetails, CredentialsConfig deployerCredentialsConfig, boolean deployArtifacts, String remotePluginLocation, boolean includeEnvVars, IncludesExcludes envVarsPatterns, boolean deployBuildInfo, String ivyPattern, String artifactPattern, Boolean useMavenPatterns, Boolean notM2Compatible, IncludesExcludes artifactDeploymentPatterns, boolean discardOldBuilds, boolean asyncBuildRetention, boolean passIdentifiedDownstream, boolean discardBuildArtifacts, String matrixParams, String deploymentProperties, boolean enableIssueTrackerIntegration, boolean aggregateBuildIssues, String aggregationBuildStatus, boolean filterExcludedArtifactsFromBuild, String artifactoryCombinationFilter, String customBuildName, boolean overrideBuildName) {
        this.matrixParams = null;
        this.deployerDetails = deployerDetails;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.deployArtifacts = deployArtifacts;
        this.remotePluginLocation = remotePluginLocation;
        this.includeEnvVars = includeEnvVars;
        this.envVarsPatterns = envVarsPatterns;
        this.deployBuildInfo = deployBuildInfo;
        this.ivyPattern = ivyPattern;
        this.aggregationBuildStatus = aggregationBuildStatus;
        this.filterExcludedArtifactsFromBuild = filterExcludedArtifactsFromBuild;
        this.artifactPattern = this.clearApostrophes(artifactPattern);
        this.useMavenPatterns = useMavenPatterns;
        this.artifactDeploymentPatterns = artifactDeploymentPatterns;
        this.discardOldBuilds = discardOldBuilds;
        this.asyncBuildRetention = asyncBuildRetention;
        this.passIdentifiedDownstream = passIdentifiedDownstream;
        this.deploymentProperties = deploymentProperties;
        this.enableIssueTrackerIntegration = enableIssueTrackerIntegration;
        this.aggregateBuildIssues = aggregateBuildIssues;
        this.discardBuildArtifacts = discardBuildArtifacts;
        this.artifactoryCombinationFilter = artifactoryCombinationFilter;
        this.customBuildName = customBuildName;
        this.overrideBuildName = overrideBuildName;
    }

    private String clearApostrophes(String artifactPattern) {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)artifactPattern, (String)"\""), (String)"\"");
    }

    public ServerDetails getDeployerDetails() {
        return this.deployerDetails;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public boolean isPassIdentifiedDownstream() {
        return this.passIdentifiedDownstream;
    }

    @Override
    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    @Override
    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    @Override
    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return this.deployerCredentialsConfig != null && this.deployerCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return this.overridingDeployerCredentials;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    public String getArtifactPattern() {
        return this.clearApostrophes(this.artifactPattern);
    }

    public String getIvyPattern() {
        return this.ivyPattern;
    }

    public IncludesExcludes getArtifactDeploymentPatterns() {
        return this.artifactDeploymentPatterns;
    }

    public boolean isDeployBuildInfo() {
        return this.deployBuildInfo;
    }

    @Override
    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    @Override
    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    @Override
    public String getRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getDeployReleaseRepository().getRepoKey() : null;
    }

    @Override
    public String getDefaultPromotionTargetRepository() {
        return null;
    }

    public String getArtifactoryName() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().artifactoryName : null;
    }

    public String getArtifactoryUrl() {
        ArtifactoryServer server = this.getArtifactoryServer();
        return server != null ? server.getArtifactoryUrl() : null;
    }

    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    public boolean isUseMavenPatterns() {
        return this.useMavenPatterns;
    }

    @Override
    public boolean isEnableIssueTrackerIntegration() {
        return this.enableIssueTrackerIntegration;
    }

    @Override
    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    @Override
    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return this.filterExcludedArtifactsFromBuild;
    }

    @Override
    public String getArtifactoryCombinationFilter() {
        return this.artifactoryCombinationFilter;
    }

    @Override
    public boolean isMultiConfProject() {
        return this.getDescriptor().isMultiConfProject();
    }

    @Override
    public String getCustomBuildName() {
        return this.customBuildName;
    }

    @Override
    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject project) {
        if (this.isOverrideBuildName()) {
            return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project, this.getCustomBuildName());
        }
        return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project);
    }

    public BuildWrapper.Environment setUp(final AbstractBuild build, final Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        Ant antBuild;
        listener.getLogger().println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        PublisherContext.Builder publisherBuilder = this.getBuilder();
        RepositoriesUtils.validateServerConfig(build, listener, this.getArtifactoryServer(), this.getArtifactoryUrl());
        int totalBuilds = 1;
        if (this.isMultiConfProject(build)) {
            totalBuilds = ((MatrixProject)build.getParent().getParent()).getActiveConfigurations().size();
            if (this.isDeployArtifacts()) {
                MultiConfigurationUtils.validateCombinationFilter(build, listener, this.getArtifactoryCombinationFilter());
                boolean isFiltered = MultiConfigurationUtils.isfiltrated(build, this.getArtifactoryCombinationFilter());
                if (isFiltered) {
                    publisherBuilder.skipBuildInfoDeploy(true).deployArtifacts(false);
                }
            }
        }
        if ((antBuild = this.getLastAntBuild(build.getProject())) != null) {
            new ConcurrentJobsHelper.ConcurrentBuildSetupSync(build, totalBuilds){

                @Override
                public void setUp() {
                    ConcurrentJobsHelper.ConcurrentBuild concurrentBuild = ConcurrentJobsHelper.getConcurrentBuild(build);
                    String targets = antBuild.getTargets() != null ? antBuild.getTargets().replace(ArtifactoryIvyFreeStyleConfigurator.this.getAntArgs(), "") : "";
                    concurrentBuild.putParam("targets", targets);
                    ArtifactoryIvyFreeStyleConfigurator.this.setTargetsField(antBuild, targets + " " + ArtifactoryIvyFreeStyleConfigurator.this.getAntArgs());
                }
            };
        }
        build.setResult(Result.SUCCESS);
        final PublisherContext finalPublisherContext = publisherBuilder.build();
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                super.buildEnvVars(env);
                try {
                    String actualDependencyDirPath = ArtifactoryIvyFreeStyleConfigurator.this.actualDependencyDirPath(build, launcher);
                    env.put("ARTIFACTORY_CACHE_LIBS", actualDependencyDirPath);
                    ExtractorUtils.addBuilderInfoArguments(env, (Run)build, (TaskListener)listener, finalPublisherContext, null, build.getWorkspace(), launcher);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean tearDown(final AbstractBuild build2, BuildListener listener2) throws IOException, InterruptedException {
                Result result = build2.getResult();
                if (antBuild != null) {
                    new ConcurrentJobsHelper.ConcurrentBuildTearDownSync(build2, result){

                        @Override
                        public void tearDown() {
                            ConcurrentJobsHelper.ConcurrentBuild concurrentBuild = ConcurrentJobsHelper.getConcurrentBuild(build2);
                            String targets = concurrentBuild.getParam("targets");
                            targets = targets.replace(ArtifactoryIvyFreeStyleConfigurator.this.getAntArgs(), "");
                            ArtifactoryIvyFreeStyleConfigurator.this.setTargetsField(antBuild, targets);
                        }
                    };
                }
                if (!finalPublisherContext.isSkipBuildInfoDeploy() && (result == null || result.isBetterOrEqualTo(Result.SUCCESS))) {
                    String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(ArtifactoryIvyFreeStyleConfigurator.this, (Run)build2);
                    build2.addAction((Action)new BuildInfoResultAction(ArtifactoryIvyFreeStyleConfigurator.this.getArtifactoryUrl(), (Run)build2, buildName));
                    build2.addAction((Action)new UnifiedPromoteBuildAction((Run<?, ?>)build2, ArtifactoryIvyFreeStyleConfigurator.this));
                }
                if (Result.ABORTED.equals(result)) {
                    ConcurrentJobsHelper.removeConcurrentBuildJob(build2);
                }
                return true;
            }
        };
    }

    private String actualDependencyDirPath(AbstractBuild build, Launcher launcher) throws IOException, InterruptedException {
        File localDependencyFile = Which.jarFile(ArtifactoryBuildListener.class);
        FilePath actualDependencyDir = PluginDependencyHelper.getActualDependencyDirectory(localDependencyFile, ActionableHelper.getNode(launcher).getRootPath());
        String actualDependencyDirPath = actualDependencyDir.getRemote();
        actualDependencyDirPath = actualDependencyDirPath.replace('\\', '/');
        actualDependencyDirPath = "\"" + actualDependencyDirPath + "\"";
        return actualDependencyDirPath;
    }

    private void setTargetsField(Ant builder, String targets) {
        try {
            Field targetsField = builder.getClass().getDeclaredField("targets");
            targetsField.setAccessible(true);
            targetsField.set(builder, targets);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getAntArgs() {
        String lib = "-lib ${ARTIFACTORY_CACHE_LIBS} ";
        String listener = "-listener org.jfrog.build.extractor.listener.ArtifactoryBuildListener";
        return lib + listener;
    }

    private Ant getLastAntBuild(AbstractProject project) {
        List<Ant> ants;
        if (project instanceof Project && (ants = ActionableHelper.getBuilder((Project)project, Ant.class)) != null && !ants.isEmpty()) {
            return ants.get(ants.size() - 1);
        }
        return null;
    }

    private PublisherContext.Builder getBuilder() {
        return new PublisherContext.Builder().artifactoryServer(this.getArtifactoryServer()).serverDetails(this.getDeployerDetails()).deployerOverrider(this).discardOldBuilds(this.isDiscardOldBuilds()).deployArtifacts(this.isDeployArtifacts()).includesExcludes(this.getArtifactDeploymentPatterns()).skipBuildInfoDeploy(!this.isDeployBuildInfo()).includeEnvVars(this.isIncludeEnvVars()).envVarsPatterns(this.getEnvVarsPatterns()).discardBuildArtifacts(this.isDiscardBuildArtifacts()).asyncBuildRetention(this.isAsyncBuildRetention()).deploymentProperties(this.getDeploymentProperties()).maven2Compatible(this.isUseMavenPatterns()).artifactsPattern(this.getArtifactPattern()).ivyPattern(this.getIvyPattern()).enableIssueTrackerIntegration(this.isEnableIssueTrackerIntegration()).aggregateBuildIssues(this.isAggregateBuildIssues()).aggregationBuildStatus(this.getAggregationBuildStatus()).filterExcludedArtifactsFromBuild(this.isFilterExcludedArtifactsFromBuild()).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).overrideBuildName(this.isOverrideBuildName()).customBuildName(this.getCustomBuildName());
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryName());
    }

    public List<Repository> getReleaseRepositoryList() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeploySnapshotRepository().getKeyFromSelect());
    }

    private boolean isMultiConfProject(AbstractBuild build) {
        return build.getProject().getClass().equals(MatrixConfiguration.class);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static final class ConverterImpl
    extends DeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractBuildWrapperDescriptor {
        private static final String DISPLAY_NAME = "Ant/Ivy-Artifactory Integration";
        private static final String CONFIG_PREFIX = "ivy";

        public DescriptorImpl() {
            super(ArtifactoryIvyFreeStyleConfigurator.class, DISPLAY_NAME, CONFIG_PREFIX);
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            return super.refreshDeployersFromArtifactory(url, credentialsId, username, password, overrideCredentials, false);
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginCredentials(project);
        }
    }
}

