/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.jfpipelines;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import hudson.FilePath;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.ArtifactoryBuilder;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesJobInfo;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesParameter;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesServer;
import org.jfrog.hudson.jfpipelines.payloads.JobStartedPayload;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.SerializationUtils;

public class Utils {
    public static FilePath getWorkspace(Job<?, ?> project) {
        FilePath projectJob = new FilePath(project.getRootDir());
        return projectJob.getParent().sibling("workspace").child(project.getName());
    }

    public static JFrogPipelinesServer getPipelinesServer() {
        ArtifactoryBuilder.DescriptorImpl descriptor = (ArtifactoryBuilder.DescriptorImpl)Jenkins.get().getDescriptor(ArtifactoryBuilder.class);
        if (descriptor == null) {
            return null;
        }
        JFrogPipelinesServer pipelinesServer = descriptor.getJfrogPipelinesServer();
        if (StringUtils.isBlank((CharSequence)pipelinesServer.getIntegrationUrl())) {
            return null;
        }
        return pipelinesServer;
    }

    public static void injectJfPipelinesInfoParameter(Job<?, ?> project, String defaultValue) throws IOException {
        ParametersDefinitionProperty parametersProperty = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        JFrogPipelinesParameter parameterDefinition = new JFrogPipelinesParameter(defaultValue);
        if (parametersProperty == null) {
            project.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{parameterDefinition}));
        } else if (parametersProperty.getParameterDefinition("JFROG_PIPELINES_INFO") == null) {
            ArrayList<JFrogPipelinesParameter> parameterDefinitions = new ArrayList<JFrogPipelinesParameter>(parametersProperty.getParameterDefinitions());
            parameterDefinitions.add(parameterDefinition);
            project.removeProperty((JobProperty)parametersProperty);
            project.addProperty((JobProperty)new ParametersDefinitionProperty(parameterDefinitions));
        }
    }

    public static JobStartedPayload getJobStartedPayload(Run<?, ?> build, TaskListener listener) {
        ParametersAction parametersAction = (ParametersAction)build.getAction(ParametersAction.class);
        if (parametersAction == null) {
            return null;
        }
        ParameterValue value = parametersAction.getParameter("JFROG_PIPELINES_INFO");
        if (value == null) {
            return null;
        }
        try {
            return (JobStartedPayload)SerializationUtils.createMapper().readValue((String)value.getValue(), JobStartedPayload.class);
        }
        catch (JsonProcessingException exception) {
            listener.error("Couldn't deserialize 'JFROG_PIPELINES_INFO' parameter", new Object[]{exception});
            return null;
        }
    }

    public static JFrogPipelinesJobInfo getPipelinesJobInfo(Run<?, ?> build) throws IOException, InterruptedException {
        BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(Utils.getWorkspace(build.getParent()), String.valueOf(build.getNumber()), "jfPipelines", "0");
        if (buildDataFile == null) {
            return null;
        }
        return (JFrogPipelinesJobInfo)SerializationUtils.createMapper().treeToValue((TreeNode)buildDataFile.get("jfPipelines"), JFrogPipelinesJobInfo.class);
    }

    public static boolean isNotConfigured(JFrogPipelinesServer pipelinesServer) {
        return pipelinesServer == null || !StringUtils.isNotBlank((CharSequence)pipelinesServer.getIntegrationUrl());
    }

    public static Map<String, String> createJobInfo(final Queue.Item queueItem) {
        return new HashMap<String, String>(){
            {
                this.put("queueId", String.valueOf(queueItem.getId()));
            }
        };
    }

    public static Map<String, String> createJobInfo(final Run<?, ?> build) {
        final Cause.UserIdCause cause = (Cause.UserIdCause)build.getCause(Cause.UserIdCause.class);
        return new HashMap<String, String>(){
            {
                this.put("job-name", build.getParent().getName());
                this.put("job-number", String.valueOf(build.getNumber()));
                this.put("start-time", String.valueOf(build.getStartTimeInMillis()));
                if (build.getDuration() > 0L) {
                    this.put("duration", String.valueOf(build.getDuration()));
                }
                this.put("build-url", build.getParent().getAbsoluteUrl() + build.getNumber());
                if (cause != null) {
                    this.put("user", cause.getUserId());
                }
            }
        };
    }
}

