/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.jfpipelines.listeners;

import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionListener;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesServer;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

@Extension
public class WorkflowListener
extends FlowExecutionListener {
    public void onRunning(@Nonnull FlowExecution execution) {
        this.reportStatus(execution, true);
    }

    public void onCompleted(@Nonnull FlowExecution execution) {
        this.reportStatus(execution, false);
    }

    private void reportStatus(@Nonnull FlowExecution execution, boolean started) {
        TaskListener listener = null;
        try {
            listener = this.getTaskListener(execution);
            WorkflowRun run = this.getWorkflowRun(execution);
            if (started) {
                JFrogPipelinesServer.reportStarted(run, listener);
            } else {
                JFrogPipelinesServer.reportCompleted(run, listener);
            }
        }
        catch (IOException e) {
            if (listener != null) {
                new JenkinsBuildInfoLog(listener).error("Failed to report status to JFrog Pipelines: " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
            }
            System.err.println("Failed to report status to JFrog Pipelines: ");
            ExceptionUtils.printRootCauseStackTrace((Throwable)e);
        }
    }

    private TaskListener getTaskListener(FlowExecution execution) throws IOException {
        return execution.getOwner().getListener();
    }

    private WorkflowRun getWorkflowRun(FlowExecution execution) throws IOException {
        return (WorkflowRun)execution.getOwner().getExecutable();
    }
}

